import { Validators } from '@angular/forms';
import { CheckboxConfiguration } from '../../../../core/components/dynamic-form/dynamic-form-fields/fields/checkbox/checkbox.model';
import { MultiSelectConfiguration } from '../../../../core/components/dynamic-form/dynamic-form-fields/fields/multiselect/multi-select.model';
import { BaseField } from '../../../../core/components/dynamic-form/models/base-field';
import { ControlName } from '../../../../core/components/dynamic-form/models/constants/control-names';
import { ReferenceType } from '../../../../core/components/dynamic-form/models/constants/reference-type';
/**
 * Constant that defines the fields and actions for the dynamic form dashboard
 */
export const DASHBOARD_DYNAMIC_FORM = {
    fields: [
        new BaseField({
            controlName: ControlName.inputText,
            value: null,
            key: 'name',
            validators: [Validators.required],
            basePathTranslation: '',
            disabledOutputEvent: false,
        }),
        new CheckboxConfiguration({
            key: 'isPublic',
            basePathTranslation: '',
            disabledOutputEvent: false,
        }),
        new MultiSelectConfiguration({
            referenceType: ReferenceType.EntityType,
            key: 'entityTypeIds',
            placeholder: 'Select Entity',
            value: null,
            validators: [Validators.required],
            optionLabel: 'label',
            optionValue: 'id',
            showClear: true,
            basePathTranslation: '',
            disabledOutputEvent: false,
        }),
    ],
    /*actions: [
      new BaseAction({
        controlName: ActionName.Button,
        key: BaseActionKey.Save,
        disableWhenFormInvalid: true,
        toolbarSlot: ToolbarSlot.Right,
        visibleExpression: "this.viewMode==='edit'",
      }),
      new BaseAction({
        controlName: ActionName.Button,
        key: BaseActionKey.Cancel,
        disableWhenFormInvalid: false,
        toolbarSlot: ToolbarSlot.Right,
        visibleExpression: "this.viewMode==='edit'",
      }),
      new BaseAction({
        controlName: ActionName.Button,
        key: BaseActionKey.Edit,
        disableWhenFormInvalid: false,
        toolbarSlot: ToolbarSlot.Right,
        visibleExpression: "this.viewMode==='read'",
      }),
    ],*/
};
//# sourceMappingURL=data:application/json;base64,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