import { Component } from '@angular/core';
import { BaseActionKey, } from '../../../core/components/dynamic-form/models/base-action';
import { ViewMode } from '../../../core/models/constants/view-mode.enum';
import { DASHBOARD_OPTIONS_DYNAMIC_FORM } from './dashboard-options-dynamic-form-structure/dashboard-options-dynamic-form';
import * as i0 from "@angular/core";
import * as i1 from "../../../core/services/utility/array-utility.service";
import * as i2 from "primeng/dynamicdialog";
import * as i3 from "../../../core/services/utility/objects-utility.service";
import * as i4 from "../../services/dashboard/abstract-dashboard.service";
import * as i5 from "../../../core/components/dynamic-form/prg-dynamic-form.component";
/**
 * Dashboard Options Component
 */
export class PrgDashboardOptionsComponent {
    /**
     * Constructor
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {DynamicDialogRef} dynamicDialogRef
     * @param {DynamicDialogConfig} dynamicDialogConfig
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {AbstractDashboardService} dashboardService
     */
    constructor(arrayUtilityService, dynamicDialogRef, dynamicDialogConfig, objectsUtilityService, dashboardService) {
        this.arrayUtilityService = arrayUtilityService;
        this.dynamicDialogRef = dynamicDialogRef;
        this.dynamicDialogConfig = dynamicDialogConfig;
        this.objectsUtilityService = objectsUtilityService;
        this.dashboardService = dashboardService;
        /**
         * The view mode for dynamic form
         * @type {ViewMode}
         */
        this.dashboardOptionsViewMode = ViewMode.Read;
        /**
         * The dynamic form fields to build dynamic dashboard options form in template
         */
        this.dashboardOptionsDynamicFormFields = this.arrayUtilityService.clone(DASHBOARD_OPTIONS_DYNAMIC_FORM.fields);
        /**
         * The dynamic form actions to build dynamic dashboard options form  in template
         */
        this.dashboardOptionsDynamicFormActions = this.arrayUtilityService.clone(DASHBOARD_OPTIONS_DYNAMIC_FORM.actions);
    }
    /**
     * ngOnInit
     *
     * Get the data from parent component
     */
    ngOnInit() {
        this.dashboardOptions = this.objectsUtilityService.cloneObject(this.dynamicDialogConfig.data?.dashboardOptions);
        this.dashboardOptionsFlatten = this.objectsUtilityService.cloneObject(this.objectsUtilityService.flattenObj(this.dashboardOptions, '.'));
    }
    /**
     * This function is responsible to handle actions from the dynamic form
     * @param {DynamicFormActionOutput} event
     */
    actionOutput(event) {
        switch (event.action) {
            case BaseActionKey.Save:
                this.dynamicDialogRef.close(this.objectsUtilityService.unFlattenObj(event.formEntity, '.'));
                this.dashboardOptionsViewMode = ViewMode.Read;
                break;
            case BaseActionKey.Cancel:
                this.dashboardService.setDashboardOptionsChanges({
                    gridsterConfig: this.objectsUtilityService.unFlattenObj(this.dashboardOptionsFlatten, '.'),
                    gridsterItems: null,
                });
                this.dashboardOptionsViewMode = ViewMode.Read;
                break;
            case BaseActionKey.Edit:
                this.dashboardOptionsViewMode = ViewMode.Edit;
                break;
            default:
                break;
        }
    }
    /**
     * This function is called whenever is a change on a field and emit a new value for DashboardOptionsChangesSubject
     * @param {DynamicFormFieldChangeOutput} event
     */
    fieldChanges(event) {
        this.dashboardService.setDashboardOptionsChanges({
            gridsterConfig: this.objectsUtilityService.unFlattenObj(event.formEntity, '.'),
            gridsterItems: null,
        });
    }
}
PrgDashboardOptionsComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDashboardOptionsComponent, deps: [{ token: i1.ArrayUtilityService }, { token: i2.DynamicDialogRef }, { token: i2.DynamicDialogConfig }, { token: i3.ObjectsUtilityService }, { token: i4.AbstractDashboardService }], target: i0.ɵɵFactoryTarget.Component });
PrgDashboardOptionsComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgDashboardOptionsComponent, selector: "prg-dashboard-options", ngImport: i0, template: "<!--<p-tabMenu [model]=\"tabMenuItems\" [activeItem]=\"activeItemTabMenu\">\r\n\r\n</p-tabMenu>-->\r\n  <prg-dynamic-form [context]=\"this\" [formGroupType]=\"'tab'\"\r\n                    (fieldChangeOutput)=\"fieldChanges($event)\" [viewMode]=\"dashboardOptionsViewMode\"\r\n                    [fields]=\"dashboardOptionsDynamicFormFields\" [entity]=\"dashboardOptionsFlatten\"\r\n                    (actionOutput)=\"actionOutput($event)\"\r\n                    [actions]=\"dashboardOptionsDynamicFormActions\" ></prg-dynamic-form>\r\n\r\n\r\n", styles: [""], dependencies: [{ kind: "component", type: i5.PrgDynamicFormComponent, selector: "prg-dynamic-form", inputs: ["context", "fields", "actions", "entity", "viewMode", "formGroupType"], outputs: ["actionOutput", "fieldChangeOutput"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDashboardOptionsComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-dashboard-options', template: "<!--<p-tabMenu [model]=\"tabMenuItems\" [activeItem]=\"activeItemTabMenu\">\r\n\r\n</p-tabMenu>-->\r\n  <prg-dynamic-form [context]=\"this\" [formGroupType]=\"'tab'\"\r\n                    (fieldChangeOutput)=\"fieldChanges($event)\" [viewMode]=\"dashboardOptionsViewMode\"\r\n                    [fields]=\"dashboardOptionsDynamicFormFields\" [entity]=\"dashboardOptionsFlatten\"\r\n                    (actionOutput)=\"actionOutput($event)\"\r\n                    [actions]=\"dashboardOptionsDynamicFormActions\" ></prg-dynamic-form>\r\n\r\n\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.ArrayUtilityService }, { type: i2.DynamicDialogRef }, { type: i2.DynamicDialogConfig }, { type: i3.ObjectsUtilityService }, { type: i4.AbstractDashboardService }]; } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJnLWRhc2hib2FyZC1vcHRpb25zLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL1ByZ0ZyYW1ld29yay5GRS5Db3JlTGliL3NyYy9saWIvbW9kdWxlcy9kYXNoYm9hcmQvY29tcG9uZW50cy9kYXNoYm9hcmQtb3B0aW9ucy9wcmctZGFzaGJvYXJkLW9wdGlvbnMuY29tcG9uZW50LnRzIiwiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvUHJnRnJhbWV3b3JrLkZFLkNvcmVMaWIvc3JjL2xpYi9tb2R1bGVzL2Rhc2hib2FyZC9jb21wb25lbnRzL2Rhc2hib2FyZC1vcHRpb25zL3ByZy1kYXNoYm9hcmQtb3B0aW9ucy5jb21wb25lbnQuaHRtbCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFVLE1BQU0sZUFBZSxDQUFDO0FBRWxELE9BQU8sRUFDTCxhQUFhLEdBR2QsTUFBTSwwREFBMEQsQ0FBQztBQUNsRSxPQUFPLEVBQUUsUUFBUSxFQUFFLE1BQU0sK0NBQStDLENBQUM7QUFLekUsT0FBTyxFQUFFLDhCQUE4QixFQUFFLE1BQU0sMkVBQTJFLENBQUM7Ozs7Ozs7QUFFM0g7O0dBRUc7QUFNSCxNQUFNLE9BQU8sNEJBQTRCO0lBNkJ2Qzs7Ozs7OztPQU9HO0lBQ0gsWUFDVSxtQkFBd0MsRUFDeEMsZ0JBQWtDLEVBQ2xDLG1CQUF3QyxFQUN4QyxxQkFBNEMsRUFDNUMsZ0JBQTBDO1FBSjFDLHdCQUFtQixHQUFuQixtQkFBbUIsQ0FBcUI7UUFDeEMscUJBQWdCLEdBQWhCLGdCQUFnQixDQUFrQjtRQUNsQyx3QkFBbUIsR0FBbkIsbUJBQW1CLENBQXFCO1FBQ3hDLDBCQUFxQixHQUFyQixxQkFBcUIsQ0FBdUI7UUFDNUMscUJBQWdCLEdBQWhCLGdCQUFnQixDQUEwQjtRQXpDcEQ7OztXQUdHO1FBQ0ksNkJBQXdCLEdBQUcsUUFBUSxDQUFDLElBQUksQ0FBQztRQUNoRDs7V0FFRztRQUNJLHNDQUFpQyxHQUN0QyxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxDQUFDLDhCQUE4QixDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3hFOztXQUVHO1FBQ0ksdUNBQWtDLEdBQ3ZDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLENBQUMsOEJBQThCLENBQUMsT0FBTyxDQUFDLENBQUM7SUE0QnRFLENBQUM7SUFFSjs7OztPQUlHO0lBQ0ksUUFBUTtRQUNiLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsV0FBVyxDQUM1RCxJQUFJLENBQUMsbUJBQW1CLENBQUMsSUFBSSxFQUFFLGdCQUFnQixDQUNoRCxDQUFDO1FBQ0YsSUFBSSxDQUFDLHVCQUF1QixHQUFHLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxXQUFXLENBQ25FLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLGdCQUFnQixFQUFFLEdBQUcsQ0FBQyxDQUNsRSxDQUFDO0lBQ0osQ0FBQztJQUVEOzs7T0FHRztJQUNJLFlBQVksQ0FBQyxLQUE4QjtRQUNoRCxRQUFRLEtBQUssQ0FBQyxNQUFNLEVBQUU7WUFDcEIsS0FBSyxhQUFhLENBQUMsSUFBSTtnQkFDckIsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEtBQUssQ0FDekIsSUFBSSxDQUFDLHFCQUFxQixDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxDQUMvRCxDQUFDO2dCQUNGLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxRQUFRLENBQUMsSUFBSSxDQUFDO2dCQUM5QyxNQUFNO1lBRVIsS0FBSyxhQUFhLENBQUMsTUFBTTtnQkFDdkIsSUFBSSxDQUFDLGdCQUFnQixDQUFDLDBCQUEwQixDQUFDO29CQUMvQyxjQUFjLEVBQUUsSUFBSSxDQUFDLHFCQUFxQixDQUFDLFlBQVksQ0FDckQsSUFBSSxDQUFDLHVCQUF1QixFQUM1QixHQUFHLENBQ0o7b0JBQ0QsYUFBYSxFQUFFLElBQUk7aUJBQ3BCLENBQUMsQ0FBQztnQkFDSCxJQUFJLENBQUMsd0JBQXdCLEdBQUcsUUFBUSxDQUFDLElBQUksQ0FBQztnQkFDOUMsTUFBTTtZQUVSLEtBQUssYUFBYSxDQUFDLElBQUk7Z0JBQ3JCLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxRQUFRLENBQUMsSUFBSSxDQUFDO2dCQUM5QyxNQUFNO1lBQ1I7Z0JBQ0UsTUFBTTtTQUNUO0lBQ0gsQ0FBQztJQUVEOzs7T0FHRztJQUNJLFlBQVksQ0FBQyxLQUFtQztRQUNyRCxJQUFJLENBQUMsZ0JBQWdCLENBQUMsMEJBQTBCLENBQUM7WUFDL0MsY0FBYyxFQUFFLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxZQUFZLENBQ3JELEtBQUssQ0FBQyxVQUFVLEVBQ2hCLEdBQUcsQ0FDSjtZQUNELGFBQWEsRUFBRSxJQUFJO1NBQ3BCLENBQUMsQ0FBQztJQUNMLENBQUM7O3lIQXZHVSw0QkFBNEI7NkdBQTVCLDRCQUE0Qiw2REN0QnpDLHVpQkFVQTsyRkRZYSw0QkFBNEI7a0JBTHhDLFNBQVM7K0JBQ0UsdUJBQXVCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50LCBPbkluaXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcclxuaW1wb3J0IHsgRHluYW1pY0RpYWxvZ0NvbmZpZywgRHluYW1pY0RpYWxvZ1JlZiB9IGZyb20gJ3ByaW1lbmcvZHluYW1pY2RpYWxvZyc7XHJcbmltcG9ydCB7XHJcbiAgQmFzZUFjdGlvbktleSxcclxuICBEeW5hbWljRm9ybUFjdGlvbk91dHB1dCxcclxuICBEeW5hbWljRm9ybUZpZWxkQ2hhbmdlT3V0cHV0LFxyXG59IGZyb20gJy4uLy4uLy4uL2NvcmUvY29tcG9uZW50cy9keW5hbWljLWZvcm0vbW9kZWxzL2Jhc2UtYWN0aW9uJztcclxuaW1wb3J0IHsgVmlld01vZGUgfSBmcm9tICcuLi8uLi8uLi9jb3JlL21vZGVscy9jb25zdGFudHMvdmlldy1tb2RlLmVudW0nO1xyXG5pbXBvcnQgeyBBcnJheVV0aWxpdHlTZXJ2aWNlIH0gZnJvbSAnLi4vLi4vLi4vY29yZS9zZXJ2aWNlcy91dGlsaXR5L2FycmF5LXV0aWxpdHkuc2VydmljZSc7XHJcbmltcG9ydCB7IE9iamVjdHNVdGlsaXR5U2VydmljZSB9IGZyb20gJy4uLy4uLy4uL2NvcmUvc2VydmljZXMvdXRpbGl0eS9vYmplY3RzLXV0aWxpdHkuc2VydmljZSc7XHJcbmltcG9ydCB7IFByZ0dyaWRzdGVyQ29uZmlnIH0gZnJvbSAnLi4vLi4vbW9kZWxzL3ByZy1ncmlkc3Rlci1jb25maWcnO1xyXG5pbXBvcnQgeyBBYnN0cmFjdERhc2hib2FyZFNlcnZpY2UgfSBmcm9tICcuLi8uLi9zZXJ2aWNlcy9kYXNoYm9hcmQvYWJzdHJhY3QtZGFzaGJvYXJkLnNlcnZpY2UnO1xyXG5pbXBvcnQgeyBEQVNIQk9BUkRfT1BUSU9OU19EWU5BTUlDX0ZPUk0gfSBmcm9tICcuL2Rhc2hib2FyZC1vcHRpb25zLWR5bmFtaWMtZm9ybS1zdHJ1Y3R1cmUvZGFzaGJvYXJkLW9wdGlvbnMtZHluYW1pYy1mb3JtJztcclxuXHJcbi8qKlxyXG4gKiBEYXNoYm9hcmQgT3B0aW9ucyBDb21wb25lbnRcclxuICovXHJcbkBDb21wb25lbnQoe1xyXG4gIHNlbGVjdG9yOiAncHJnLWRhc2hib2FyZC1vcHRpb25zJyxcclxuICB0ZW1wbGF0ZVVybDogJy4vcHJnLWRhc2hib2FyZC1vcHRpb25zLmNvbXBvbmVudC5odG1sJyxcclxuICBzdHlsZVVybHM6IFsnLi9wcmctZGFzaGJvYXJkLW9wdGlvbnMuY29tcG9uZW50LnNjc3MnXSxcclxufSlcclxuZXhwb3J0IGNsYXNzIFByZ0Rhc2hib2FyZE9wdGlvbnNDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xyXG4gIC8qKlxyXG4gICAqIFRoZSB2aWV3IG1vZGUgZm9yIGR5bmFtaWMgZm9ybVxyXG4gICAqIEB0eXBlIHtWaWV3TW9kZX1cclxuICAgKi9cclxuICBwdWJsaWMgZGFzaGJvYXJkT3B0aW9uc1ZpZXdNb2RlID0gVmlld01vZGUuUmVhZDtcclxuICAvKipcclxuICAgKiBUaGUgZHluYW1pYyBmb3JtIGZpZWxkcyB0byBidWlsZCBkeW5hbWljIGRhc2hib2FyZCBvcHRpb25zIGZvcm0gaW4gdGVtcGxhdGVcclxuICAgKi9cclxuICBwdWJsaWMgZGFzaGJvYXJkT3B0aW9uc0R5bmFtaWNGb3JtRmllbGRzOiBhbnlbXSA9XHJcbiAgICB0aGlzLmFycmF5VXRpbGl0eVNlcnZpY2UuY2xvbmUoREFTSEJPQVJEX09QVElPTlNfRFlOQU1JQ19GT1JNLmZpZWxkcyk7XHJcbiAgLyoqXHJcbiAgICogVGhlIGR5bmFtaWMgZm9ybSBhY3Rpb25zIHRvIGJ1aWxkIGR5bmFtaWMgZGFzaGJvYXJkIG9wdGlvbnMgZm9ybSAgaW4gdGVtcGxhdGVcclxuICAgKi9cclxuICBwdWJsaWMgZGFzaGJvYXJkT3B0aW9uc0R5bmFtaWNGb3JtQWN0aW9uczogYW55W10gPVxyXG4gICAgdGhpcy5hcnJheVV0aWxpdHlTZXJ2aWNlLmNsb25lKERBU0hCT0FSRF9PUFRJT05TX0RZTkFNSUNfRk9STS5hY3Rpb25zKTtcclxuXHJcbiAgLyoqXHJcbiAgICogVGhlIGRhc2hib2FyZCBzZXR0aW5ncyBvYmplY3QgZmxhdHRlbiBvYmplY3QgYmFzZWQgb24gR3JpZHN0ZXIgb3B0aW9uc1xyXG4gICAqIEB0eXBlIHthbnl9XHJcbiAgICovXHJcbiAgcHVibGljIGRhc2hib2FyZE9wdGlvbnNGbGF0dGVuOiBhbnk7XHJcbiAgLyoqXHJcbiAgICogVGhlIGRhc2hib2FyZCBzZXR0aW5ncyBvYmplY3QgYmFzZWQgb24gR3JpZHN0ZXIgb3B0aW9uc1xyXG4gICAqIEB0eXBlIHtQcmdHcmlkc3RlckNvbmZpZ31cclxuICAgKiBAcHJpdmF0ZVxyXG4gICAqL1xyXG4gIHByaXZhdGUgZGFzaGJvYXJkT3B0aW9uczogUHJnR3JpZHN0ZXJDb25maWc7XHJcblxyXG4gIC8qKlxyXG4gICAqIENvbnN0cnVjdG9yXHJcbiAgICogQHBhcmFtIHtBcnJheVV0aWxpdHlTZXJ2aWNlfSBhcnJheVV0aWxpdHlTZXJ2aWNlXHJcbiAgICogQHBhcmFtIHtEeW5hbWljRGlhbG9nUmVmfSBkeW5hbWljRGlhbG9nUmVmXHJcbiAgICogQHBhcmFtIHtEeW5hbWljRGlhbG9nQ29uZmlnfSBkeW5hbWljRGlhbG9nQ29uZmlnXHJcbiAgICogQHBhcmFtIHtPYmplY3RzVXRpbGl0eVNlcnZpY2V9IG9iamVjdHNVdGlsaXR5U2VydmljZVxyXG4gICAqIEBwYXJhbSB7QWJzdHJhY3REYXNoYm9hcmRTZXJ2aWNlfSBkYXNoYm9hcmRTZXJ2aWNlXHJcbiAgICovXHJcbiAgY29uc3RydWN0b3IoXHJcbiAgICBwcml2YXRlIGFycmF5VXRpbGl0eVNlcnZpY2U6IEFycmF5VXRpbGl0eVNlcnZpY2UsXHJcbiAgICBwcml2YXRlIGR5bmFtaWNEaWFsb2dSZWY6IER5bmFtaWNEaWFsb2dSZWYsXHJcbiAgICBwcml2YXRlIGR5bmFtaWNEaWFsb2dDb25maWc6IER5bmFtaWNEaWFsb2dDb25maWcsXHJcbiAgICBwcml2YXRlIG9iamVjdHNVdGlsaXR5U2VydmljZTogT2JqZWN0c1V0aWxpdHlTZXJ2aWNlLFxyXG4gICAgcHJpdmF0ZSBkYXNoYm9hcmRTZXJ2aWNlOiBBYnN0cmFjdERhc2hib2FyZFNlcnZpY2VcclxuICApIHt9XHJcblxyXG4gIC8qKlxyXG4gICAqIG5nT25Jbml0XHJcbiAgICpcclxuICAgKiBHZXQgdGhlIGRhdGEgZnJvbSBwYXJlbnQgY29tcG9uZW50XHJcbiAgICovXHJcbiAgcHVibGljIG5nT25Jbml0KCkge1xyXG4gICAgdGhpcy5kYXNoYm9hcmRPcHRpb25zID0gdGhpcy5vYmplY3RzVXRpbGl0eVNlcnZpY2UuY2xvbmVPYmplY3QoXHJcbiAgICAgIHRoaXMuZHluYW1pY0RpYWxvZ0NvbmZpZy5kYXRhPy5kYXNoYm9hcmRPcHRpb25zXHJcbiAgICApO1xyXG4gICAgdGhpcy5kYXNoYm9hcmRPcHRpb25zRmxhdHRlbiA9IHRoaXMub2JqZWN0c1V0aWxpdHlTZXJ2aWNlLmNsb25lT2JqZWN0KFxyXG4gICAgICB0aGlzLm9iamVjdHNVdGlsaXR5U2VydmljZS5mbGF0dGVuT2JqKHRoaXMuZGFzaGJvYXJkT3B0aW9ucywgJy4nKVxyXG4gICAgKTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIFRoaXMgZnVuY3Rpb24gaXMgcmVzcG9uc2libGUgdG8gaGFuZGxlIGFjdGlvbnMgZnJvbSB0aGUgZHluYW1pYyBmb3JtXHJcbiAgICogQHBhcmFtIHtEeW5hbWljRm9ybUFjdGlvbk91dHB1dH0gZXZlbnRcclxuICAgKi9cclxuICBwdWJsaWMgYWN0aW9uT3V0cHV0KGV2ZW50OiBEeW5hbWljRm9ybUFjdGlvbk91dHB1dCk6IHZvaWQge1xyXG4gICAgc3dpdGNoIChldmVudC5hY3Rpb24pIHtcclxuICAgICAgY2FzZSBCYXNlQWN0aW9uS2V5LlNhdmU6XHJcbiAgICAgICAgdGhpcy5keW5hbWljRGlhbG9nUmVmLmNsb3NlKFxyXG4gICAgICAgICAgdGhpcy5vYmplY3RzVXRpbGl0eVNlcnZpY2UudW5GbGF0dGVuT2JqKGV2ZW50LmZvcm1FbnRpdHksICcuJylcclxuICAgICAgICApO1xyXG4gICAgICAgIHRoaXMuZGFzaGJvYXJkT3B0aW9uc1ZpZXdNb2RlID0gVmlld01vZGUuUmVhZDtcclxuICAgICAgICBicmVhaztcclxuXHJcbiAgICAgIGNhc2UgQmFzZUFjdGlvbktleS5DYW5jZWw6XHJcbiAgICAgICAgdGhpcy5kYXNoYm9hcmRTZXJ2aWNlLnNldERhc2hib2FyZE9wdGlvbnNDaGFuZ2VzKHtcclxuICAgICAgICAgIGdyaWRzdGVyQ29uZmlnOiB0aGlzLm9iamVjdHNVdGlsaXR5U2VydmljZS51bkZsYXR0ZW5PYmooXHJcbiAgICAgICAgICAgIHRoaXMuZGFzaGJvYXJkT3B0aW9uc0ZsYXR0ZW4sXHJcbiAgICAgICAgICAgICcuJ1xyXG4gICAgICAgICAgKSxcclxuICAgICAgICAgIGdyaWRzdGVySXRlbXM6IG51bGwsXHJcbiAgICAgICAgfSk7XHJcbiAgICAgICAgdGhpcy5kYXNoYm9hcmRPcHRpb25zVmlld01vZGUgPSBWaWV3TW9kZS5SZWFkO1xyXG4gICAgICAgIGJyZWFrO1xyXG5cclxuICAgICAgY2FzZSBCYXNlQWN0aW9uS2V5LkVkaXQ6XHJcbiAgICAgICAgdGhpcy5kYXNoYm9hcmRPcHRpb25zVmlld01vZGUgPSBWaWV3TW9kZS5FZGl0O1xyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgICBkZWZhdWx0OlxyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgLyoqXHJcbiAgICogVGhpcyBmdW5jdGlvbiBpcyBjYWxsZWQgd2hlbmV2ZXIgaXMgYSBjaGFuZ2Ugb24gYSBmaWVsZCBhbmQgZW1pdCBhIG5ldyB2YWx1ZSBmb3IgRGFzaGJvYXJkT3B0aW9uc0NoYW5nZXNTdWJqZWN0XHJcbiAgICogQHBhcmFtIHtEeW5hbWljRm9ybUZpZWxkQ2hhbmdlT3V0cHV0fSBldmVudFxyXG4gICAqL1xyXG4gIHB1YmxpYyBmaWVsZENoYW5nZXMoZXZlbnQ6IER5bmFtaWNGb3JtRmllbGRDaGFuZ2VPdXRwdXQpOiB2b2lkIHtcclxuICAgIHRoaXMuZGFzaGJvYXJkU2VydmljZS5zZXREYXNoYm9hcmRPcHRpb25zQ2hhbmdlcyh7XHJcbiAgICAgIGdyaWRzdGVyQ29uZmlnOiB0aGlzLm9iamVjdHNVdGlsaXR5U2VydmljZS51bkZsYXR0ZW5PYmooXHJcbiAgICAgICAgZXZlbnQuZm9ybUVudGl0eSxcclxuICAgICAgICAnLidcclxuICAgICAgKSxcclxuICAgICAgZ3JpZHN0ZXJJdGVtczogbnVsbCxcclxuICAgIH0pO1xyXG4gIH1cclxufVxyXG4iLCI8IS0tPHAtdGFiTWVudSBbbW9kZWxdPVwidGFiTWVudUl0ZW1zXCIgW2FjdGl2ZUl0ZW1dPVwiYWN0aXZlSXRlbVRhYk1lbnVcIj5cclxuXHJcbjwvcC10YWJNZW51Pi0tPlxyXG4gIDxwcmctZHluYW1pYy1mb3JtIFtjb250ZXh0XT1cInRoaXNcIiBbZm9ybUdyb3VwVHlwZV09XCIndGFiJ1wiXHJcbiAgICAgICAgICAgICAgICAgICAgKGZpZWxkQ2hhbmdlT3V0cHV0KT1cImZpZWxkQ2hhbmdlcygkZXZlbnQpXCIgW3ZpZXdNb2RlXT1cImRhc2hib2FyZE9wdGlvbnNWaWV3TW9kZVwiXHJcbiAgICAgICAgICAgICAgICAgICAgW2ZpZWxkc109XCJkYXNoYm9hcmRPcHRpb25zRHluYW1pY0Zvcm1GaWVsZHNcIiBbZW50aXR5XT1cImRhc2hib2FyZE9wdGlvbnNGbGF0dGVuXCJcclxuICAgICAgICAgICAgICAgICAgICAoYWN0aW9uT3V0cHV0KT1cImFjdGlvbk91dHB1dCgkZXZlbnQpXCJcclxuICAgICAgICAgICAgICAgICAgICBbYWN0aW9uc109XCJkYXNoYm9hcmRPcHRpb25zRHluYW1pY0Zvcm1BY3Rpb25zXCIgPjwvcHJnLWR5bmFtaWMtZm9ybT5cclxuXHJcblxyXG4iXX0=