/**
 * Constant that defines the fields and actions for the dynamic form query filter
 */
import { CheckboxConfiguration } from '../../../../core/components/dynamic-form/dynamic-form-fields/fields/checkbox/checkbox.model';
import { InputNumberConfiguration } from '../../../../core/components/dynamic-form/dynamic-form-fields/fields/input-number/input-number.model';
import { InputTextConfiguration } from '../../../../core/components/dynamic-form/dynamic-form-fields/fields/input-text/input-text.model';
import { SelectConfiguration } from '../../../../core/components/dynamic-form/dynamic-form-fields/fields/select/select.model';
import { BaseAction, BaseActionKey, } from '../../../../core/components/dynamic-form/models/base-action';
import { ActionName } from '../../../../core/components/dynamic-form/models/constants/action-names';
import { ToolbarSlot } from '../../../../core/components/dynamic-form/models/constants/toolbar-slots';
import { PrgCompactType, PrgGridType, } from '../../../models/prg-gridster-config';
/**
 * This constant defines the fields and actions to be used on dynamic form for dashboard options
 * @type {{fields: (SelectConfiguration | InputNumberConfiguration | CheckboxConfiguration | InputTextConfiguration)[], actions: BaseAction[]}}
 */
export const DASHBOARD_OPTIONS_DYNAMIC_FORM = {
    fields: [
        //Group General
        new SelectConfiguration({
            key: 'gridType',
            options: Object.values(PrgGridType).map((gridType) => {
                return { label: gridType, value: gridType };
            }),
            showClear: true,
            disabledOutputEvent: false,
            groupFieldsId: 'general',
        }),
        new SelectConfiguration({
            key: 'compactType',
            options: Object.values(PrgCompactType).map((compactType) => {
                return { label: compactType, value: compactType };
            }),
            showClear: true,
            disabledOutputEvent: false,
            groupFieldsId: 'general',
        }),
        new InputNumberConfiguration({
            key: 'fixedColWidth',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'general',
        }),
        new InputNumberConfiguration({
            key: 'fixedRowHeight',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'general',
        }),
        new InputNumberConfiguration({
            key: 'mobileBreakpoint',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'general',
        }),
        new InputNumberConfiguration({
            key: 'rowHeightRatio',
            disabledOutputEvent: false,
            showButtons: true,
            mode: 'decimal',
            minFractionDigits: 1,
            maxFractionDigits: 2,
            step: 0.1,
            groupFieldsId: 'general',
        }),
        new CheckboxConfiguration({
            key: 'setGridSize',
            disabledOutputEvent: false,
            groupFieldsId: 'general',
        }),
        new CheckboxConfiguration({
            key: 'keepFixedHeightInMobile',
            disabledOutputEvent: false,
            groupFieldsId: 'general',
        }),
        new CheckboxConfiguration({
            key: 'keepFixedWidthInMobile',
            disabledOutputEvent: false,
            groupFieldsId: 'general',
        }),
        new CheckboxConfiguration({
            key: 'useBodyForBreakpoint',
            disabledOutputEvent: false,
            groupFieldsId: 'general',
        }),
        //Group Resizable
        new InputNumberConfiguration({
            key: 'resizable.delayStart',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'resizable',
        }),
        new CheckboxConfiguration({
            key: 'resizable.enabled',
            disabledOutputEvent: false,
            groupFieldsId: 'resizable',
        }),
        new CheckboxConfiguration({
            key: 'resizable.handles.s',
            disabledOutputEvent: false,
            groupFieldsId: 'resizable',
        }),
        new CheckboxConfiguration({
            key: 'resizable.handles.e',
            disabledOutputEvent: false,
            groupFieldsId: 'resizable',
        }),
        new CheckboxConfiguration({
            key: 'resizable.handles.n',
            disabledOutputEvent: false,
            groupFieldsId: 'resizable',
        }),
        new CheckboxConfiguration({
            key: 'resizable.handles.w',
            disabledOutputEvent: false,
            groupFieldsId: 'resizable',
        }),
        new CheckboxConfiguration({
            key: 'resizable.handles.se',
            disabledOutputEvent: false,
            groupFieldsId: 'resizable',
        }),
        new CheckboxConfiguration({
            key: 'resizable.handles.ne',
            disabledOutputEvent: false,
            groupFieldsId: 'resizable',
        }),
        new CheckboxConfiguration({
            key: 'resizable.handles.sw',
            disabledOutputEvent: false,
            groupFieldsId: 'resizable',
        }),
        new CheckboxConfiguration({
            key: 'resizable.handles.nw',
            disabledOutputEvent: false,
            groupFieldsId: 'resizable',
        }),
        //Group Push
        new CheckboxConfiguration({
            key: 'pushItems',
            disabledOutputEvent: false,
            groupFieldsId: 'push',
        }),
        new CheckboxConfiguration({
            key: 'disablePushOnDrag',
            disabledOutputEvent: false,
            groupFieldsId: 'push',
        }),
        new CheckboxConfiguration({
            key: 'disablePushOnResize',
            disabledOutputEvent: false,
            groupFieldsId: 'push',
        }),
        new CheckboxConfiguration({
            key: 'pushResizeItems',
            disabledOutputEvent: false,
            groupFieldsId: 'push',
        }),
        new CheckboxConfiguration({
            key: 'pushDirections.north',
            disabledOutputEvent: false,
            groupFieldsId: 'push',
        }),
        new CheckboxConfiguration({
            key: 'pushDirections.east',
            disabledOutputEvent: false,
            groupFieldsId: 'push',
        }),
        new CheckboxConfiguration({
            key: 'pushDirections.south',
            disabledOutputEvent: false,
            groupFieldsId: 'push',
        }),
        new CheckboxConfiguration({
            key: 'pushDirections.west',
            disabledOutputEvent: false,
            groupFieldsId: 'push',
        }),
        //Group Swap
        new CheckboxConfiguration({
            key: 'swap',
            disabledOutputEvent: false,
            groupFieldsId: 'swap',
        }),
        new CheckboxConfiguration({
            key: 'swapWhileDragging',
            disabledOutputEvent: false,
            groupFieldsId: 'swap',
        }),
        //Group Draggable
        new InputNumberConfiguration({
            key: 'draggable.delayStart',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'draggable',
        }),
        new CheckboxConfiguration({
            key: 'draggable.enabled',
            disabledOutputEvent: false,
            groupFieldsId: 'draggable',
        }),
        new CheckboxConfiguration({
            key: 'draggable.ignoreContent',
            disabledOutputEvent: false,
            groupFieldsId: 'draggable',
        }),
        new CheckboxConfiguration({
            key: 'draggable.dropOverItems',
            disabledOutputEvent: false,
            groupFieldsId: 'draggable',
        }),
        new InputTextConfiguration({
            key: 'draggable.dragHandleClass',
            disabledOutputEvent: true,
            groupFieldsId: 'draggable',
        }),
        new InputTextConfiguration({
            key: 'draggable.ignoreContentClass',
            disabledOutputEvent: true,
            groupFieldsId: 'draggable',
        }),
        //Group EmptyCell
        new CheckboxConfiguration({
            key: 'enableEmptyCellClick',
            disabledOutputEvent: false,
            groupFieldsId: 'emptyCell',
        }),
        new CheckboxConfiguration({
            key: 'enableEmptyCellContextMenu',
            disabledOutputEvent: false,
            groupFieldsId: 'emptyCell',
        }),
        new CheckboxConfiguration({
            key: 'enableEmptyCellDrop',
            disabledOutputEvent: false,
            groupFieldsId: 'emptyCell',
        }),
        new CheckboxConfiguration({
            key: 'enableEmptyCellDrag',
            disabledOutputEvent: false,
            groupFieldsId: 'emptyCell',
        }),
        new CheckboxConfiguration({
            key: 'enableOccupiedCellDrop',
            disabledOutputEvent: false,
            groupFieldsId: 'emptyCell',
        }),
        new InputNumberConfiguration({
            key: 'emptyCellDragMaxCols',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'emptyCell',
        }),
        new InputNumberConfiguration({
            key: 'emptyCellDragMaxRows',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'emptyCell',
        }),
        //Group Margins
        new InputNumberConfiguration({
            key: 'margin',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'margins',
        }),
        new CheckboxConfiguration({
            key: 'outerMargin',
            disabledOutputEvent: false,
            groupFieldsId: 'emptyCell',
        }),
        new InputNumberConfiguration({
            key: 'outerMarginLeft',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'margins',
        }),
        new InputNumberConfiguration({
            key: 'outerMarginTop',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'margins',
        }),
        new InputNumberConfiguration({
            key: 'outerMarginRight',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'margins',
        }),
        new InputNumberConfiguration({
            key: 'outerMarginBottom',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'margins',
        }),
        //Grid Sizes
        new InputNumberConfiguration({
            key: 'minCols',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'gridSizes',
        }),
        new InputNumberConfiguration({
            key: 'maxRows',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'gridSizes',
        }),
        new InputNumberConfiguration({
            key: 'maxCols',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'gridSizes',
        }),
        new InputNumberConfiguration({
            key: 'minRows',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'gridSizes',
        }),
        new InputNumberConfiguration({
            key: 'defaultItemCols',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'gridSizes',
        }),
        new InputNumberConfiguration({
            key: 'defaultItemRows',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'gridSizes',
        }),
        new InputNumberConfiguration({
            key: 'minItemCols',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'gridSizes',
        }),
        new InputNumberConfiguration({
            key: 'maxItemCols',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'gridSizes',
        }),
        new InputNumberConfiguration({
            key: 'minItemRows',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'gridSizes',
        }),
        new InputNumberConfiguration({
            key: 'maxItemRows',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'gridSizes',
        }),
        new InputNumberConfiguration({
            key: 'minItemArea',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'gridSizes',
        }),
        new InputNumberConfiguration({
            key: 'maxItemArea',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'gridSizes',
        }),
        new InputNumberConfiguration({
            key: 'addEmptyRowsCount',
            disabledOutputEvent: false,
            showButtons: true,
            groupFieldsId: 'gridSizes',
        }),
    ],
    actions: [
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Save,
            disableWhenFormInvalid: true,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Cancel,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Edit,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='read'",
        }),
    ],
};
//# sourceMappingURL=data:application/json;base64,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