import { Component, Inject, Input } from '@angular/core';
import { PRG_DASHBOARD_CONFIG } from '../../services/prg-dashboard-configuration/prg-dashboard-configuration.service';
import * as i0 from "@angular/core";
import * as i1 from "../../../entity-types/components/list-specific-entity-type/prg-list-specific-entity-type.component";
/**
 * Dashboard List Component
 */
export class PrgDashboardListComponent {
    /**
     * Constructor
     * @param {PrgDashboardConfig} prgDashboardConfig
     */
    constructor(prgDashboardConfig) {
        this.prgDashboardConfig = prgDashboardConfig;
        /**
         * Entity type name to pass to component prg-list-specific-entity-type
         * @type {string}
         */
        this.entityTypeName = 'dashboard';
        /**
         * The route for editing a dashboard
         */
        this.editDashboardPageRoute = '/' +
            this.prgDashboardConfig.dashboardRoutingBasePath +
            '/' +
            this.prgDashboardConfig.dashboardEditRoutingPath;
    }
}
PrgDashboardListComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDashboardListComponent, deps: [{ token: PRG_DASHBOARD_CONFIG }], target: i0.ɵɵFactoryTarget.Component });
PrgDashboardListComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgDashboardListComponent, selector: "prg-dashboard-list", inputs: { entityTypeName: "entityTypeName", editDashboardPageRoute: "editDashboardPageRoute" }, ngImport: i0, template: "<prg-list-specific-entity-type [onClickGoTo]=\"editDashboardPageRoute\" [entityTypeName]=\"entityTypeName\"></prg-list-specific-entity-type>\r\n", styles: [""], dependencies: [{ kind: "component", type: i1.PrgListSpecificEntityTypeComponent, selector: "prg-list-specific-entity-type", inputs: ["entityTypeName", "onClickGoTo"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDashboardListComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-dashboard-list', template: "<prg-list-specific-entity-type [onClickGoTo]=\"editDashboardPageRoute\" [entityTypeName]=\"entityTypeName\"></prg-list-specific-entity-type>\r\n" }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_DASHBOARD_CONFIG]
                }] }]; }, propDecorators: { entityTypeName: [{
                type: Input
            }], editDashboardPageRoute: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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