import { Component, Input } from '@angular/core';
import { filter, lastValueFrom, map } from 'rxjs';
import { BaseDashboardComponent } from '../base-dashboard-component';
import { PRG_TABLE_SETTINGS } from './prg-table-settings';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "../../../../layouts/services/main-layout.service";
import * as i3 from "../../../services/dashboard/abstract-dashboard.service";
import * as i4 from "../../../../core/services/utility/utility.service";
import * as i5 from "../../../../core/services/utility/objects-utility.service";
import * as i6 from "primeng/api";
import * as i7 from "@angular/common";
import * as i8 from "primeng/table";
/**
 * Table Component
 */
export class PrgTableComponent extends BaseDashboardComponent {
    /**
     * Constructor
     * @param {HttpClient} http
     * @param {MainLayoutService} mainLayoutService
     * @param {AbstractDashboardService} dashboardService
     * @param {UtilityService} utilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(http, mainLayoutService, dashboardService, utilityService, objectsUtilityService) {
        super();
        this.http = http;
        this.mainLayoutService = mainLayoutService;
        this.dashboardService = dashboardService;
        this.utilityService = utilityService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * A class property used to unsubscribe observables on ngOnDestroy
         * @type {Subscription[]}
         * @private
         */
        this.subscription = [];
        PrgTableComponent.key = PRG_TABLE_SETTINGS.key;
        PrgTableComponent.staticSettings = PRG_TABLE_SETTINGS.staticSettings;
        PrgTableComponent.configurationSettings =
            PRG_TABLE_SETTINGS.configurationSettings;
    }
    /**
     * The custom settings for this component
     * @param itemSettings
     */
    set itemSettings(itemSettings) {
        if (itemSettings != null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(itemSettings));
        }
    }
    /**
     * Getter for item settings
     * @returns {any}
     */
    get itemSettings() {
        return this._itemSettings;
    }
    /**
     * ngOnInit
     * @returns {Promise<void>}
     */
    async ngOnInit() {
        if (this._itemSettings == null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(PrgTableComponent.staticSettings));
        }
        this._itemSettings = Object.values(this._itemSettings);
        this.subscription.push(this.dashboardService
            .getDashboardItemsResizeObservable()
            .pipe(filter((item) => item?.item?.id === this.itemId))
            .subscribe((item) => {
            this.height = (item.height - item.height * 0.05).toString() + 'px';
            this.width = (item.width - item.width * 0.02).toString() + 'px';
        }));
        this.products = await lastValueFrom(this.http
            .get('assets/products.json')
            .pipe(map((res) => res.data)));
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.subscription.forEach((subs) => {
            subs.unsubscribe();
        });
    }
}
PrgTableComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTableComponent, deps: [{ token: i1.HttpClient }, { token: i2.MainLayoutService }, { token: i3.AbstractDashboardService }, { token: i4.UtilityService }, { token: i5.ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgTableComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgTableComponent, selector: "prg-table", inputs: { itemId: "itemId", itemSettings: "itemSettings" }, usesInheritance: true, ngImport: i0, template: "<div *ngIf=\"height&&width\" class=\"card\" [style]=\"{'height':height,'width':width}\">\r\n<p-table   [value]=\"products\"  [scrollable]=\"true\" [scrollHeight]=\"height\" >\r\n  <ng-template pTemplate=\"header\">\r\n    <tr style=\"text-align: center\">\r\n      <th style=\"text-align: center\" >Code</th>\r\n      <th style=\"text-align: center\">Name</th>\r\n      <th style=\"text-align: center\">Category</th>\r\n      <th style=\"text-align: center\">Quantity</th>\r\n    </tr>\r\n  </ng-template>\r\n  <ng-template pTemplate=\"body\" let-product>\r\n    <tr style=\"text-align: center\">\r\n      <td style=\"text-align: center\">{{product.code}}</td>\r\n      <td style=\"text-align: center\">{{product.name}}</td>\r\n      <td style=\"text-align: center\">{{product.category}}</td>\r\n      <td style=\"text-align: center\">{{product.quantity}}</td>\r\n    </tr>\r\n  </ng-template>\r\n</p-table>\r\n</div>\r\n", styles: [":host ::ng-deep .p-datatable-scrollable .p-datatable-thead>tr>th,:host .p-datatable-scrollable .p-datatable-tbody>tr>td,:host .p-datatable-scrollable .p-datatable-tfoot>tr>td{justify-content:center}:host ::ng-deep .p-datatable-scrollable .p-datatable-tbody>tr>td{justify-content:center}\n"], dependencies: [{ kind: "directive", type: i6.PrimeTemplate, selector: "[pTemplate]", inputs: ["type", "pTemplate"] }, { kind: "directive", type: i7.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i8.Table, selector: "p-table", inputs: ["frozenColumns", "frozenValue", "style", "styleClass", "tableStyle", "tableStyleClass", "paginator", "pageLinks", "rowsPerPageOptions", "alwaysShowPaginator", "paginatorPosition", "paginatorDropdownAppendTo", "paginatorDropdownScrollHeight", "currentPageReportTemplate", "showCurrentPageReport", "showJumpToPageDropdown", "showJumpToPageInput", "showFirstLastIcon", "showPageLinks", "defaultSortOrder", "sortMode", "resetPageOnSort", "selectionMode", "selectionPageOnly", "contextMenuSelection", "contextMenuSelectionMode", "dataKey", "metaKeySelection", "rowSelectable", "rowTrackBy", "lazy", "lazyLoadOnInit", "compareSelectionBy", "csvSeparator", "exportFilename", "filters", "globalFilterFields", "filterDelay", "filterLocale", "expandedRowKeys", "editingRowKeys", "rowExpandMode", "scrollable", "scrollDirection", "rowGroupMode", "scrollHeight", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "virtualScrollDelay", "frozenWidth", "responsive", "contextMenu", "resizableColumns", "columnResizeMode", "reorderableColumns", "loading", "loadingIcon", "showLoader", "rowHover", "customSort", "showInitialSortBadge", "autoLayout", "exportFunction", "exportHeader", "stateKey", "stateStorage", "editMode", "groupRowsBy", "groupRowsByOrder", "responsiveLayout", "breakpoint", "virtualRowHeight", "value", "columns", "first", "rows", "totalRecords", "sortField", "sortOrder", "multiSortMeta", "selection", "selectAll"], outputs: ["selectAllChange", "selectionChange", "contextMenuSelectionChange", "onRowSelect", "onRowUnselect", "onPage", "onSort", "onFilter", "onLazyLoad", "onRowExpand", "onRowCollapse", "onContextMenuSelect", "onColResize", "onColReorder", "onRowReorder", "onEditInit", "onEditComplete", "onEditCancel", "onHeaderCheckboxToggle", "sortFunction", "firstChange", "rowsChange", "onStateSave", "onStateRestore"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTableComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-table', template: "<div *ngIf=\"height&&width\" class=\"card\" [style]=\"{'height':height,'width':width}\">\r\n<p-table   [value]=\"products\"  [scrollable]=\"true\" [scrollHeight]=\"height\" >\r\n  <ng-template pTemplate=\"header\">\r\n    <tr style=\"text-align: center\">\r\n      <th style=\"text-align: center\" >Code</th>\r\n      <th style=\"text-align: center\">Name</th>\r\n      <th style=\"text-align: center\">Category</th>\r\n      <th style=\"text-align: center\">Quantity</th>\r\n    </tr>\r\n  </ng-template>\r\n  <ng-template pTemplate=\"body\" let-product>\r\n    <tr style=\"text-align: center\">\r\n      <td style=\"text-align: center\">{{product.code}}</td>\r\n      <td style=\"text-align: center\">{{product.name}}</td>\r\n      <td style=\"text-align: center\">{{product.category}}</td>\r\n      <td style=\"text-align: center\">{{product.quantity}}</td>\r\n    </tr>\r\n  </ng-template>\r\n</p-table>\r\n</div>\r\n", styles: [":host ::ng-deep .p-datatable-scrollable .p-datatable-thead>tr>th,:host .p-datatable-scrollable .p-datatable-tbody>tr>td,:host .p-datatable-scrollable .p-datatable-tfoot>tr>td{justify-content:center}:host ::ng-deep .p-datatable-scrollable .p-datatable-tbody>tr>td{justify-content:center}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.HttpClient }, { type: i2.MainLayoutService }, { type: i3.AbstractDashboardService }, { type: i4.UtilityService }, { type: i5.ObjectsUtilityService }]; }, propDecorators: { itemId: [{
                type: Input,
                args: ['itemId']
            }], itemSettings: [{
                type: Input,
                args: ['itemSettings']
            }] } });
//# sourceMappingURL=data:application/json;base64,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