import { Validators } from '@angular/forms';
import { InputNumberConfiguration } from '../../../../core/components/dynamic-form/dynamic-form-fields/fields/input-number/input-number.model';
import { InputTextConfiguration } from '../../../../core/components/dynamic-form/dynamic-form-fields/fields/input-text/input-text.model';
/**
 * Constant that define the key , configuration settings and settings for table component
 * @type {{staticSettings: string, configurationSettings: {fields: (InputNumberConfiguration | InputTextConfiguration)[]}, key: string}}
 */
export const PRG_TABLE_SETTINGS = {
    key: 'Table',
    configurationSettings: {
        fields: [
            new InputNumberConfiguration({
                key: 'tableProperty1',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'tableProperty2',
                disabledOutputEvent: false,
                showButtons: true,
                validators: [Validators.required],
            }),
            new InputTextConfiguration({
                key: 'tableProperty3',
                disabledOutputEvent: false,
            }),
        ],
    },
    staticSettings: JSON.stringify({
        tableProperty1: 1,
        tableProperty2: 10,
        tableProperty3: 15,
    }),
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJnLXRhYmxlLXNldHRpbmdzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvUHJnRnJhbWV3b3JrLkZFLkNvcmVMaWIvc3JjL2xpYi9tb2R1bGVzL2Rhc2hib2FyZC9jb21wb25lbnRzL2Rhc2hib2FyZC1pdGVtcy90YWJsZS9wcmctdGFibGUtc2V0dGluZ3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLGdCQUFnQixDQUFDO0FBQzVDLE9BQU8sRUFBRSx3QkFBd0IsRUFBRSxNQUFNLHFHQUFxRyxDQUFDO0FBQy9JLE9BQU8sRUFBRSxzQkFBc0IsRUFBRSxNQUFNLGlHQUFpRyxDQUFDO0FBRXpJOzs7R0FHRztBQUNILE1BQU0sQ0FBQyxNQUFNLGtCQUFrQixHQUFHO0lBQ2hDLEdBQUcsRUFBRSxPQUFPO0lBQ1oscUJBQXFCLEVBQUU7UUFDckIsTUFBTSxFQUFFO1lBQ04sSUFBSSx3QkFBd0IsQ0FBQztnQkFDM0IsR0FBRyxFQUFFLGdCQUFnQjtnQkFDckIsbUJBQW1CLEVBQUUsS0FBSztnQkFDMUIsV0FBVyxFQUFFLElBQUk7Z0JBQ2pCLFVBQVUsRUFBRSxLQUFLO2FBQ2xCLENBQUM7WUFDRixJQUFJLHdCQUF3QixDQUFDO2dCQUMzQixHQUFHLEVBQUUsZ0JBQWdCO2dCQUNyQixtQkFBbUIsRUFBRSxLQUFLO2dCQUMxQixXQUFXLEVBQUUsSUFBSTtnQkFDakIsVUFBVSxFQUFFLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQzthQUNsQyxDQUFDO1lBQ0YsSUFBSSxzQkFBc0IsQ0FBQztnQkFDekIsR0FBRyxFQUFFLGdCQUFnQjtnQkFDckIsbUJBQW1CLEVBQUUsS0FBSzthQUMzQixDQUFDO1NBQ0g7S0FDRjtJQUNELGNBQWMsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDO1FBQzdCLGNBQWMsRUFBRSxDQUFDO1FBQ2pCLGNBQWMsRUFBRSxFQUFFO1FBQ2xCLGNBQWMsRUFBRSxFQUFFO0tBQ25CLENBQUM7Q0FDSCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVmFsaWRhdG9ycyB9IGZyb20gJ0Bhbmd1bGFyL2Zvcm1zJztcclxuaW1wb3J0IHsgSW5wdXROdW1iZXJDb25maWd1cmF0aW9uIH0gZnJvbSAnLi4vLi4vLi4vLi4vY29yZS9jb21wb25lbnRzL2R5bmFtaWMtZm9ybS9keW5hbWljLWZvcm0tZmllbGRzL2ZpZWxkcy9pbnB1dC1udW1iZXIvaW5wdXQtbnVtYmVyLm1vZGVsJztcclxuaW1wb3J0IHsgSW5wdXRUZXh0Q29uZmlndXJhdGlvbiB9IGZyb20gJy4uLy4uLy4uLy4uL2NvcmUvY29tcG9uZW50cy9keW5hbWljLWZvcm0vZHluYW1pYy1mb3JtLWZpZWxkcy9maWVsZHMvaW5wdXQtdGV4dC9pbnB1dC10ZXh0Lm1vZGVsJztcclxuXHJcbi8qKlxyXG4gKiBDb25zdGFudCB0aGF0IGRlZmluZSB0aGUga2V5ICwgY29uZmlndXJhdGlvbiBzZXR0aW5ncyBhbmQgc2V0dGluZ3MgZm9yIHRhYmxlIGNvbXBvbmVudFxyXG4gKiBAdHlwZSB7e3N0YXRpY1NldHRpbmdzOiBzdHJpbmcsIGNvbmZpZ3VyYXRpb25TZXR0aW5nczoge2ZpZWxkczogKElucHV0TnVtYmVyQ29uZmlndXJhdGlvbiB8IElucHV0VGV4dENvbmZpZ3VyYXRpb24pW119LCBrZXk6IHN0cmluZ319XHJcbiAqL1xyXG5leHBvcnQgY29uc3QgUFJHX1RBQkxFX1NFVFRJTkdTID0ge1xyXG4gIGtleTogJ1RhYmxlJyxcclxuICBjb25maWd1cmF0aW9uU2V0dGluZ3M6IHtcclxuICAgIGZpZWxkczogW1xyXG4gICAgICBuZXcgSW5wdXROdW1iZXJDb25maWd1cmF0aW9uKHtcclxuICAgICAgICBrZXk6ICd0YWJsZVByb3BlcnR5MScsXHJcbiAgICAgICAgZGlzYWJsZWRPdXRwdXRFdmVudDogZmFsc2UsXHJcbiAgICAgICAgc2hvd0J1dHRvbnM6IHRydWUsXHJcbiAgICAgICAgYWxsb3dFbXB0eTogZmFsc2UsXHJcbiAgICAgIH0pLFxyXG4gICAgICBuZXcgSW5wdXROdW1iZXJDb25maWd1cmF0aW9uKHtcclxuICAgICAgICBrZXk6ICd0YWJsZVByb3BlcnR5MicsXHJcbiAgICAgICAgZGlzYWJsZWRPdXRwdXRFdmVudDogZmFsc2UsXHJcbiAgICAgICAgc2hvd0J1dHRvbnM6IHRydWUsXHJcbiAgICAgICAgdmFsaWRhdG9yczogW1ZhbGlkYXRvcnMucmVxdWlyZWRdLFxyXG4gICAgICB9KSxcclxuICAgICAgbmV3IElucHV0VGV4dENvbmZpZ3VyYXRpb24oe1xyXG4gICAgICAgIGtleTogJ3RhYmxlUHJvcGVydHkzJyxcclxuICAgICAgICBkaXNhYmxlZE91dHB1dEV2ZW50OiBmYWxzZSxcclxuICAgICAgfSksXHJcbiAgICBdLFxyXG4gIH0sXHJcbiAgc3RhdGljU2V0dGluZ3M6IEpTT04uc3RyaW5naWZ5KHtcclxuICAgIHRhYmxlUHJvcGVydHkxOiAxLFxyXG4gICAgdGFibGVQcm9wZXJ0eTI6IDEwLFxyXG4gICAgdGFibGVQcm9wZXJ0eTM6IDE1LFxyXG4gIH0pLFxyXG59O1xyXG4iXX0=