import { Component, Input, ViewChild } from '@angular/core';
import { filter } from 'rxjs';
import { BaseDashboardComponent } from '../base-dashboard-component';
import { PRG_BAR_LINE_SETTINGS } from './prg-line-chart-settings';
import * as i0 from "@angular/core";
import * as i1 from "../../../services/dashboard/abstract-dashboard.service";
import * as i2 from "../../../../core/services/utility/utility.service";
import * as i3 from "../../../../core/services/utility/objects-utility.service";
import * as i4 from "primeng/chart";
/**
 * Line Chart Component
 */
export class PrgLineChartComponent extends BaseDashboardComponent {
    /**
     * Constructor
     * @param {AbstractDashboardService} dashboardService
     * @param {UtilityService} utilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(dashboardService, utilityService, objectsUtilityService) {
        super();
        this.dashboardService = dashboardService;
        this.utilityService = utilityService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * A class property used to unsubscribe observables on ngOnDestroy
         * @type {Subscription[]}
         * @private
         */
        this.subscription = [];
        PrgLineChartComponent.key = PRG_BAR_LINE_SETTINGS.key;
        PrgLineChartComponent.staticSettings = PRG_BAR_LINE_SETTINGS.staticSettings;
        PrgLineChartComponent.configurationSettings =
            PRG_BAR_LINE_SETTINGS.configurationSettings;
    }
    /**
     * The custom settings for this component
     * @param itemSettings
     */
    set itemSettings(itemSettings) {
        if (itemSettings != null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(itemSettings));
        }
    }
    /**
     * Getter for item settings
     * @returns {any}
     */
    get itemSettings() {
        return this._itemSettings;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        if (this._itemSettings == null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(PrgLineChartComponent.staticSettings));
        }
        this._itemSettings = Object.values(this._itemSettings);
        this.basicData = {
            labels: ['January', 'February', 'March', 'April', 'May', 'June', 'July'],
            datasets: [
                {
                    label: 'First Dataset',
                    data: this._itemSettings,
                    fill: false,
                    borderColor: '#42A5F5',
                    tension: 0.4,
                },
                {
                    label: 'Second Dataset',
                    data: [28, 48, 40, 19, 86, 27, 90],
                    fill: false,
                    borderColor: '#FFA726',
                    tension: 0.4,
                },
            ],
        };
        this.basicOptions = {
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    labels: {
                        color: '#495057',
                    },
                },
            },
            scales: {
                x: {
                    ticks: {
                        color: '#495057',
                    },
                    grid: {
                        color: '#ebedef',
                    },
                },
                y: {
                    ticks: {
                        color: '#495057',
                    },
                    grid: {
                        color: '#ebedef',
                    },
                },
            },
        };
        this.subscription.push(this.dashboardService
            .getDashboardItemsResizeObservable()
            .pipe(filter((item) => item?.item?.id === this.itemId))
            .subscribe((item) => {
            this.height = (item.height - item.height * 0.05).toString() + 'px';
            this.width = (item.width - item.width * 0.02).toString() + 'px';
            if (this.chart?.chart) {
                this.chart.chart.canvas.parentNode.style.height =
                    (item.height - item.height * 0.05).toString() + 'px';
                this.chart.chart.canvas.parentNode.style.width =
                    (item.width - item.width * 0.02).toString() + 'px';
                this.chart.reinit();
            }
        }));
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.subscription.forEach((subs) => {
            subs.unsubscribe();
        });
    }
}
PrgLineChartComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLineChartComponent, deps: [{ token: i1.AbstractDashboardService }, { token: i2.UtilityService }, { token: i3.ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgLineChartComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgLineChartComponent, selector: "prg-line-chart", inputs: { itemId: "itemId", itemSettings: "itemSettings" }, viewQueries: [{ propertyName: "chart", first: true, predicate: ["chart"], descendants: true }], usesInheritance: true, ngImport: i0, template: "<div class=\"graph-size\" [style]=\"{'height':height,'width':width}\">\r\n  <p-chart  type=\"line\"  #chart  [data]=\"basicData\" [options]=\"basicOptions\"></p-chart>\r\n\r\n</div>\r\n", styles: [".graph-size{position:relative}\n"], dependencies: [{ kind: "component", type: i4.UIChart, selector: "p-chart", inputs: ["type", "plugins", "width", "height", "responsive", "data", "options"], outputs: ["onDataSelect"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLineChartComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-line-chart', template: "<div class=\"graph-size\" [style]=\"{'height':height,'width':width}\">\r\n  <p-chart  type=\"line\"  #chart  [data]=\"basicData\" [options]=\"basicOptions\"></p-chart>\r\n\r\n</div>\r\n", styles: [".graph-size{position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.AbstractDashboardService }, { type: i2.UtilityService }, { type: i3.ObjectsUtilityService }]; }, propDecorators: { itemId: [{
                type: Input,
                args: ['itemId']
            }], itemSettings: [{
                type: Input,
                args: ['itemSettings']
            }], chart: [{
                type: ViewChild,
                args: ['chart']
            }] } });
//# sourceMappingURL=data:application/json;base64,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