import { Component, Input, ViewChild } from '@angular/core';
import { filter } from 'rxjs';
import { BaseDashboardComponent } from '../base-dashboard-component';
import { PRG_BAR_DOUGHNUT_SETTINGS } from './prg-doughnut-chart-settings';
import * as i0 from "@angular/core";
import * as i1 from "../../../services/dashboard/abstract-dashboard.service";
import * as i2 from "../../../../core/services/utility/utility.service";
import * as i3 from "../../../../core/services/utility/objects-utility.service";
import * as i4 from "primeng/chart";
/**
 * Doughnut Chart Component
 */
export class PrgDoughnutChartComponent extends BaseDashboardComponent {
    /**
     * Cosntructor
     * @param {AbstractDashboardService} dashboardService
     * @param {UtilityService} utilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(dashboardService, utilityService, objectsUtilityService) {
        super();
        this.dashboardService = dashboardService;
        this.utilityService = utilityService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * A class property used to unsubscribe observables on ngOnDestroy
         * @type {Subscription[]}
         * @private
         */
        this.subscription = [];
        PrgDoughnutChartComponent.key = PRG_BAR_DOUGHNUT_SETTINGS.key;
        PrgDoughnutChartComponent.staticSettings =
            PRG_BAR_DOUGHNUT_SETTINGS.staticSettings;
        PrgDoughnutChartComponent.configurationSettings =
            PRG_BAR_DOUGHNUT_SETTINGS.configurationSettings;
    }
    /**
     * The custom settings for this component
     * @param itemSettings
     */
    set itemSettings(itemSettings) {
        if (itemSettings != null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(itemSettings));
        }
    }
    /**
     * Getter for item settings
     * @returns {any}
     */
    get itemSettings() {
        return this._itemSettings;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        if (this._itemSettings == null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(PrgDoughnutChartComponent.staticSettings));
        }
        this._itemSettings = Object.values(this._itemSettings);
        this.basicData = {
            labels: ['A', 'B', 'C'],
            datasets: [
                {
                    data: this._itemSettings,
                    backgroundColor: ['#FF6384', '#36A2EB', '#FFCE56'],
                    hoverBackgroundColor: ['#FF6384', '#36A2EB', '#FFCE56'],
                },
            ],
        };
        this.basicOptions = {
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    labels: {
                        color: '#495057',
                    },
                },
            },
        };
        this.subscription.push(this.dashboardService
            .getDashboardItemsResizeObservable()
            .pipe(filter((item) => item?.item?.id === this.itemId))
            .subscribe((item) => {
            this.height = (item.height - item.height * 0.05).toString() + 'px';
            this.width = (item.width - item.width * 0.02).toString() + 'px';
            if (this.chart?.chart) {
                this.chart.chart.canvas.parentNode.style.height =
                    (item.height - item.height * 0.05).toString() + 'px';
                this.chart.chart.canvas.parentNode.style.width =
                    (item.width - item.width * 0.02).toString() + 'px';
                this.chart.reinit();
            }
        }));
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.subscription.forEach((subs) => {
            subs.unsubscribe();
        });
    }
}
PrgDoughnutChartComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDoughnutChartComponent, deps: [{ token: i1.AbstractDashboardService }, { token: i2.UtilityService }, { token: i3.ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgDoughnutChartComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgDoughnutChartComponent, selector: "prg-doughnut-chart", inputs: { itemId: "itemId", itemSettings: "itemSettings" }, viewQueries: [{ propertyName: "chart", first: true, predicate: ["chart"], descendants: true }], usesInheritance: true, ngImport: i0, template: "<div  class=\"graph-size\" [style]=\"{'height':height,'width':width}\">\r\n\r\n  <p-chart type=\"doughnut\"   #chart  [data]=\"basicData\" [options]=\"basicOptions\"></p-chart>\r\n\r\n</div>\r\n\r\n\r\n", styles: [".graph-size{position:relative}\n"], dependencies: [{ kind: "component", type: i4.UIChart, selector: "p-chart", inputs: ["type", "plugins", "width", "height", "responsive", "data", "options"], outputs: ["onDataSelect"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDoughnutChartComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-doughnut-chart', template: "<div  class=\"graph-size\" [style]=\"{'height':height,'width':width}\">\r\n\r\n  <p-chart type=\"doughnut\"   #chart  [data]=\"basicData\" [options]=\"basicOptions\"></p-chart>\r\n\r\n</div>\r\n\r\n\r\n", styles: [".graph-size{position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.AbstractDashboardService }, { type: i2.UtilityService }, { type: i3.ObjectsUtilityService }]; }, propDecorators: { itemId: [{
                type: Input,
                args: ['itemId']
            }], itemSettings: [{
                type: Input,
                args: ['itemSettings']
            }], chart: [{
                type: ViewChild,
                args: ['chart']
            }] } });
//# sourceMappingURL=data:application/json;base64,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