import { BaseAction, BaseActionKey, } from '../../../core/components/dynamic-form/models/base-action';
import { ActionName } from '../../../core/components/dynamic-form/models/constants/action-names';
import { ToolbarSlot } from '../../../core/components/dynamic-form/models/constants/toolbar-slots';
/**
 * A constant that define the dynamic form actions for the components used on dashboard
 * @type {BaseAction[]}
 */
export const DASHBOARD_ITEMS_DYNAMIC_FORM_ACTIONS = [
    new BaseAction({
        controlName: ActionName.Button,
        key: BaseActionKey.Save,
        disableWhenFormInvalid: true,
        toolbarSlot: ToolbarSlot.Right,
        visibleExpression: "this.viewMode==='edit'",
    }),
    new BaseAction({
        controlName: ActionName.Button,
        key: BaseActionKey.Cancel,
        disableWhenFormInvalid: false,
        toolbarSlot: ToolbarSlot.Right,
        visibleExpression: "this.viewMode==='edit'",
    }),
    new BaseAction({
        controlName: ActionName.Button,
        key: BaseActionKey.Edit,
        disableWhenFormInvalid: false,
        toolbarSlot: ToolbarSlot.Right,
        visibleExpression: "this.viewMode==='read'",
    }),
];
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGFzaGJvYXJkLWl0ZW1zLWR5bmFtaWMtZm9ybS1hY3Rpb25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvUHJnRnJhbWV3b3JrLkZFLkNvcmVMaWIvc3JjL2xpYi9tb2R1bGVzL2Rhc2hib2FyZC9jb21wb25lbnRzL2Rhc2hib2FyZC1pdGVtcy9kYXNoYm9hcmQtaXRlbXMtZHluYW1pYy1mb3JtLWFjdGlvbnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUNMLFVBQVUsRUFDVixhQUFhLEdBQ2QsTUFBTSwwREFBMEQsQ0FBQztBQUNsRSxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0scUVBQXFFLENBQUM7QUFDakcsT0FBTyxFQUFFLFdBQVcsRUFBRSxNQUFNLHNFQUFzRSxDQUFDO0FBRW5HOzs7R0FHRztBQUNILE1BQU0sQ0FBQyxNQUFNLG9DQUFvQyxHQUFpQjtJQUNoRSxJQUFJLFVBQVUsQ0FBQztRQUNiLFdBQVcsRUFBRSxVQUFVLENBQUMsTUFBTTtRQUM5QixHQUFHLEVBQUUsYUFBYSxDQUFDLElBQUk7UUFDdkIsc0JBQXNCLEVBQUUsSUFBSTtRQUM1QixXQUFXLEVBQUUsV0FBVyxDQUFDLEtBQUs7UUFDOUIsaUJBQWlCLEVBQUUsd0JBQXdCO0tBQzVDLENBQUM7SUFDRixJQUFJLFVBQVUsQ0FBQztRQUNiLFdBQVcsRUFBRSxVQUFVLENBQUMsTUFBTTtRQUM5QixHQUFHLEVBQUUsYUFBYSxDQUFDLE1BQU07UUFDekIsc0JBQXNCLEVBQUUsS0FBSztRQUM3QixXQUFXLEVBQUUsV0FBVyxDQUFDLEtBQUs7UUFDOUIsaUJBQWlCLEVBQUUsd0JBQXdCO0tBQzVDLENBQUM7SUFDRixJQUFJLFVBQVUsQ0FBQztRQUNiLFdBQVcsRUFBRSxVQUFVLENBQUMsTUFBTTtRQUM5QixHQUFHLEVBQUUsYUFBYSxDQUFDLElBQUk7UUFDdkIsc0JBQXNCLEVBQUUsS0FBSztRQUM3QixXQUFXLEVBQUUsV0FBVyxDQUFDLEtBQUs7UUFDOUIsaUJBQWlCLEVBQUUsd0JBQXdCO0tBQzVDLENBQUM7Q0FDSCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcclxuICBCYXNlQWN0aW9uLFxyXG4gIEJhc2VBY3Rpb25LZXksXHJcbn0gZnJvbSAnLi4vLi4vLi4vY29yZS9jb21wb25lbnRzL2R5bmFtaWMtZm9ybS9tb2RlbHMvYmFzZS1hY3Rpb24nO1xyXG5pbXBvcnQgeyBBY3Rpb25OYW1lIH0gZnJvbSAnLi4vLi4vLi4vY29yZS9jb21wb25lbnRzL2R5bmFtaWMtZm9ybS9tb2RlbHMvY29uc3RhbnRzL2FjdGlvbi1uYW1lcyc7XHJcbmltcG9ydCB7IFRvb2xiYXJTbG90IH0gZnJvbSAnLi4vLi4vLi4vY29yZS9jb21wb25lbnRzL2R5bmFtaWMtZm9ybS9tb2RlbHMvY29uc3RhbnRzL3Rvb2xiYXItc2xvdHMnO1xyXG5cclxuLyoqXHJcbiAqIEEgY29uc3RhbnQgdGhhdCBkZWZpbmUgdGhlIGR5bmFtaWMgZm9ybSBhY3Rpb25zIGZvciB0aGUgY29tcG9uZW50cyB1c2VkIG9uIGRhc2hib2FyZFxyXG4gKiBAdHlwZSB7QmFzZUFjdGlvbltdfVxyXG4gKi9cclxuZXhwb3J0IGNvbnN0IERBU0hCT0FSRF9JVEVNU19EWU5BTUlDX0ZPUk1fQUNUSU9OUzogQmFzZUFjdGlvbltdID0gW1xyXG4gIG5ldyBCYXNlQWN0aW9uKHtcclxuICAgIGNvbnRyb2xOYW1lOiBBY3Rpb25OYW1lLkJ1dHRvbixcclxuICAgIGtleTogQmFzZUFjdGlvbktleS5TYXZlLFxyXG4gICAgZGlzYWJsZVdoZW5Gb3JtSW52YWxpZDogdHJ1ZSxcclxuICAgIHRvb2xiYXJTbG90OiBUb29sYmFyU2xvdC5SaWdodCxcclxuICAgIHZpc2libGVFeHByZXNzaW9uOiBcInRoaXMudmlld01vZGU9PT0nZWRpdCdcIixcclxuICB9KSxcclxuICBuZXcgQmFzZUFjdGlvbih7XHJcbiAgICBjb250cm9sTmFtZTogQWN0aW9uTmFtZS5CdXR0b24sXHJcbiAgICBrZXk6IEJhc2VBY3Rpb25LZXkuQ2FuY2VsLFxyXG4gICAgZGlzYWJsZVdoZW5Gb3JtSW52YWxpZDogZmFsc2UsXHJcbiAgICB0b29sYmFyU2xvdDogVG9vbGJhclNsb3QuUmlnaHQsXHJcbiAgICB2aXNpYmxlRXhwcmVzc2lvbjogXCJ0aGlzLnZpZXdNb2RlPT09J2VkaXQnXCIsXHJcbiAgfSksXHJcbiAgbmV3IEJhc2VBY3Rpb24oe1xyXG4gICAgY29udHJvbE5hbWU6IEFjdGlvbk5hbWUuQnV0dG9uLFxyXG4gICAga2V5OiBCYXNlQWN0aW9uS2V5LkVkaXQsXHJcbiAgICBkaXNhYmxlV2hlbkZvcm1JbnZhbGlkOiBmYWxzZSxcclxuICAgIHRvb2xiYXJTbG90OiBUb29sYmFyU2xvdC5SaWdodCxcclxuICAgIHZpc2libGVFeHByZXNzaW9uOiBcInRoaXMudmlld01vZGU9PT0ncmVhZCdcIixcclxuICB9KSxcclxuXTtcclxuIl19