import { Component, Input, ViewChild } from '@angular/core';
import { filter } from 'rxjs';
import { BaseDashboardComponent } from '../base-dashboard-component';
import { PRG_BAR_CHART_SETTINGS } from './prg-bar-chart-settings';
import * as i0 from "@angular/core";
import * as i1 from "../../../services/dashboard/abstract-dashboard.service";
import * as i2 from "../../../../core/services/utility/utility.service";
import * as i3 from "../../../../core/services/utility/objects-utility.service";
import * as i4 from "primeng/chart";
/**
 * Bar Chart Component
 */
export class PrgBarChartComponent extends BaseDashboardComponent {
    /**
     * Constructor
     * @param {AbstractDashboardService} dashboardService
     * @param {UtilityService} utilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(dashboardService, utilityService, objectsUtilityService) {
        super();
        this.dashboardService = dashboardService;
        this.utilityService = utilityService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * A class property used to unsubscribe observables on ngOnDestroy
         * @type {Subscription[]}
         * @private
         */
        this.subscription = [];
        PrgBarChartComponent.key = PRG_BAR_CHART_SETTINGS.key;
        PrgBarChartComponent.staticSettings = PRG_BAR_CHART_SETTINGS.staticSettings;
        PrgBarChartComponent.configurationSettings =
            PRG_BAR_CHART_SETTINGS.configurationSettings;
    }
    /**
     * The custom settings for this component
     * @param itemSettings
     */
    set itemSettings(itemSettings) {
        if (itemSettings != null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(itemSettings));
        }
    }
    /**
     * Getter for item settings
     * @returns {any}
     */
    get itemSettings() {
        return this._itemSettings;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.subscription.push(this.dashboardService
            .getDashboardItemsResizeObservable()
            .pipe(filter((item) => item?.item?.id === this.itemId))
            .subscribe((item) => {
            this.height = (item.height - item.height * 0.05).toString() + 'px';
            this.width = (item.width - item.width * 0.02).toString() + 'px';
            if (this.chart?.chart) {
                this.chart.chart.canvas.parentNode.style.height =
                    (item.height - item.height * 0.05).toString() + 'px';
                this.chart.chart.canvas.parentNode.style.width =
                    (item.width - item.width * 0.02).toString() + 'px';
                this.chart.reinit();
            }
        }));
        if (this._itemSettings == null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(PrgBarChartComponent.staticSettings));
        }
        this._itemSettings = Object.values(this._itemSettings);
        this.basicData = {
            labels: ['January', 'February', 'March', 'April', 'May', 'June', 'July'],
            datasets: [
                {
                    label: 'My First dataset',
                    backgroundColor: '#42A5F5',
                    data: this._itemSettings,
                },
                {
                    label: 'My Second dataset',
                    backgroundColor: '#FFA726',
                    data: [28, 48, 40, 19, 86, 27, 90],
                },
            ],
        };
        this.basicOptions = {
            maintainAspectRatio: false,
            responsive: true,
            plugins: {
                legend: {
                    labels: {
                        color: '#495057',
                    },
                },
            },
            scales: {
                x: {
                    ticks: {
                        color: '#495057',
                    },
                    grid: {
                        color: '#ebedef',
                    },
                },
                y: {
                    ticks: {
                        color: '#495057',
                    },
                    grid: {
                        color: '#ebedef',
                    },
                },
            },
        };
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.subscription.forEach((subs) => {
            subs.unsubscribe();
        });
    }
}
PrgBarChartComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgBarChartComponent, deps: [{ token: i1.AbstractDashboardService }, { token: i2.UtilityService }, { token: i3.ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgBarChartComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgBarChartComponent, selector: "prg-bar-chart", inputs: { itemId: "itemId", itemSettings: "itemSettings" }, viewQueries: [{ propertyName: "chart", first: true, predicate: ["chart"], descendants: true }], usesInheritance: true, ngImport: i0, template: "<div  class=\"graph-size\" [style]=\"{'height':height,'width':width}\">\r\n\r\n  <p-chart type=\"bar\"    #chart  [data]=\"basicData\" [options]=\"basicOptions\"></p-chart>\r\n\r\n</div>\r\n\r\n\r\n", styles: [".graph-size{position:relative}\n"], dependencies: [{ kind: "component", type: i4.UIChart, selector: "p-chart", inputs: ["type", "plugins", "width", "height", "responsive", "data", "options"], outputs: ["onDataSelect"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgBarChartComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-bar-chart', template: "<div  class=\"graph-size\" [style]=\"{'height':height,'width':width}\">\r\n\r\n  <p-chart type=\"bar\"    #chart  [data]=\"basicData\" [options]=\"basicOptions\"></p-chart>\r\n\r\n</div>\r\n\r\n\r\n", styles: [".graph-size{position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.AbstractDashboardService }, { type: i2.UtilityService }, { type: i3.ObjectsUtilityService }]; }, propDecorators: { itemId: [{
                type: Input,
                args: ['itemId']
            }], itemSettings: [{
                type: Input,
                args: ['itemSettings']
            }], chart: [{
                type: ViewChild,
                args: ['chart']
            }] } });
//# sourceMappingURL=data:application/json;base64,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