import { Component } from '@angular/core';
import { BaseActionKey, } from '../../../core/components/dynamic-form/models/base-action';
import { ViewMode } from '../../../core/models/constants/view-mode.enum';
import { DASHBOARD_ITEMS_DYNAMIC_FORM_ACTIONS } from '../dashboard-items/dashboard-items-dynamic-form-actions';
import * as i0 from "@angular/core";
import * as i1 from "../../../core/services/utility/objects-utility.service";
import * as i2 from "../../../core/services/utility/array-utility.service";
import * as i3 from "primeng/dynamicdialog";
import * as i4 from "../../../core/services/utility/utility.service";
import * as i5 from "../../../core/components/dynamic-form/prg-dynamic-form.component";
/**
 * Dashboard Items Options Component
 */
export class PrgDashboardItemsOptionsComponent {
    /**
     * Constructor
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {DynamicDialogRef} dynamicDialogRef
     * @param {DynamicDialogConfig} dynamicDialogConfig
     * @param {UtilityService} utilityService
     */
    constructor(objectsUtilityService, arrayUtilityService, dynamicDialogRef, dynamicDialogConfig, utilityService) {
        this.objectsUtilityService = objectsUtilityService;
        this.arrayUtilityService = arrayUtilityService;
        this.dynamicDialogRef = dynamicDialogRef;
        this.dynamicDialogConfig = dynamicDialogConfig;
        this.utilityService = utilityService;
        /**
         * The dynamic form fields to build dashboard items form in template
         */
        this.dashboardItemsOptionsDynamicFormFields = [];
        /**
         * The dynamic form actions to build dashboard items form in template
         */
        this.dashboardItemsOptionsDynamicFormActions = this.arrayUtilityService.clone(DASHBOARD_ITEMS_DYNAMIC_FORM_ACTIONS);
        /**
         * The view mode for dynamic form
         * @type {ViewMode}
         */
        this.dashboardItemsOptionsViewMode = ViewMode.Read;
    }
    /**
     * ngOnInit
     *
     * Get the data from parent component
     */
    ngOnInit() {
        this.dashboardItem = this.objectsUtilityService.cloneObject(this.dynamicDialogConfig.data?.item);
        if (this.dashboardItem.settings) {
            this.dashboardItemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(this.dashboardItem.settings));
        }
        else {
            this.dashboardItemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(this.dashboardItem.item.staticSettings));
        }
        this.index = this.dynamicDialogConfig.data?.index;
        this.dashboardItemsOptionsDynamicFormFields =
            this.arrayUtilityService.clone(this.dashboardItem.item.configurationSettings.fields);
    }
    /**
     * This function is responsible to handle actions from the dynamic form
     * @param {DynamicFormActionOutput} event
     */
    actionOutput(event) {
        switch (event.action) {
            case BaseActionKey.Save:
                this.dashboardItem.settings = JSON.stringify(event.formEntity);
                this.dynamicDialogRef.close({
                    item: this.dashboardItem,
                    index: this.index,
                });
                this.dashboardItemsOptionsViewMode = ViewMode.Read;
                break;
            case BaseActionKey.Cancel:
                this.dashboardItemsOptionsViewMode = ViewMode.Read;
                break;
            case BaseActionKey.Edit:
                this.dashboardItemsOptionsViewMode = ViewMode.Edit;
                break;
            default:
                break;
        }
    }
}
PrgDashboardItemsOptionsComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDashboardItemsOptionsComponent, deps: [{ token: i1.ObjectsUtilityService }, { token: i2.ArrayUtilityService }, { token: i3.DynamicDialogRef }, { token: i3.DynamicDialogConfig }, { token: i4.UtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgDashboardItemsOptionsComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgDashboardItemsOptionsComponent, selector: "prg-dashboard-items-options", ngImport: i0, template: "<prg-dynamic-form\r\n                  [viewMode]=\"dashboardItemsOptionsViewMode\"\r\n                  [fields]=\"dashboardItemsOptionsDynamicFormFields\" [entity]=\"dashboardItemSettings\"\r\n                  (actionOutput)=\"actionOutput($event)\"\r\n                  [actions]=\"dashboardItemsOptionsDynamicFormActions\" ></prg-dynamic-form>\r\n", styles: [""], dependencies: [{ kind: "component", type: i5.PrgDynamicFormComponent, selector: "prg-dynamic-form", inputs: ["context", "fields", "actions", "entity", "viewMode", "formGroupType"], outputs: ["actionOutput", "fieldChangeOutput"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDashboardItemsOptionsComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-dashboard-items-options', template: "<prg-dynamic-form\r\n                  [viewMode]=\"dashboardItemsOptionsViewMode\"\r\n                  [fields]=\"dashboardItemsOptionsDynamicFormFields\" [entity]=\"dashboardItemSettings\"\r\n                  (actionOutput)=\"actionOutput($event)\"\r\n                  [actions]=\"dashboardItemsOptionsDynamicFormActions\" ></prg-dynamic-form>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.ObjectsUtilityService }, { type: i2.ArrayUtilityService }, { type: i3.DynamicDialogRef }, { type: i3.DynamicDialogConfig }, { type: i4.UtilityService }]; } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJnLWRhc2hib2FyZC1pdGVtcy1vcHRpb25zLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL1ByZ0ZyYW1ld29yay5GRS5Db3JlTGliL3NyYy9saWIvbW9kdWxlcy9kYXNoYm9hcmQvY29tcG9uZW50cy9kYXNoYm9hcmQtaXRlbXMtb3B0aW9ucy9wcmctZGFzaGJvYXJkLWl0ZW1zLW9wdGlvbnMuY29tcG9uZW50LnRzIiwiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvUHJnRnJhbWV3b3JrLkZFLkNvcmVMaWIvc3JjL2xpYi9tb2R1bGVzL2Rhc2hib2FyZC9jb21wb25lbnRzL2Rhc2hib2FyZC1pdGVtcy1vcHRpb25zL3ByZy1kYXNoYm9hcmQtaXRlbXMtb3B0aW9ucy5jb21wb25lbnQuaHRtbCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFVLE1BQU0sZUFBZSxDQUFDO0FBRWxELE9BQU8sRUFFTCxhQUFhLEdBRWQsTUFBTSwwREFBMEQsQ0FBQztBQUNsRSxPQUFPLEVBQUUsUUFBUSxFQUFFLE1BQU0sK0NBQStDLENBQUM7QUFLekUsT0FBTyxFQUFFLG9DQUFvQyxFQUFFLE1BQU0seURBQXlELENBQUM7Ozs7Ozs7QUFFL0c7O0dBRUc7QUFNSCxNQUFNLE9BQU8saUNBQWlDO0lBZ0M1Qzs7Ozs7OztPQU9HO0lBQ0gsWUFDVSxxQkFBNEMsRUFDNUMsbUJBQXdDLEVBQ3hDLGdCQUFrQyxFQUNsQyxtQkFBd0MsRUFDeEMsY0FBOEI7UUFKOUIsMEJBQXFCLEdBQXJCLHFCQUFxQixDQUF1QjtRQUM1Qyx3QkFBbUIsR0FBbkIsbUJBQW1CLENBQXFCO1FBQ3hDLHFCQUFnQixHQUFoQixnQkFBZ0IsQ0FBa0I7UUFDbEMsd0JBQW1CLEdBQW5CLG1CQUFtQixDQUFxQjtRQUN4QyxtQkFBYyxHQUFkLGNBQWMsQ0FBZ0I7UUE1Q3hDOztXQUVHO1FBQ0ksMkNBQXNDLEdBQVUsRUFBRSxDQUFDO1FBQzFEOztXQUVHO1FBQ0ksNENBQXVDLEdBQzVDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLENBQUMsb0NBQW9DLENBQUMsQ0FBQztRQUN2RTs7O1dBR0c7UUFDSSxrQ0FBNkIsR0FBRyxRQUFRLENBQUMsSUFBSSxDQUFDO0lBZ0NsRCxDQUFDO0lBRUo7Ozs7T0FJRztJQUNJLFFBQVE7UUFDYixJQUFJLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxXQUFXLENBQ3pELElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUNwQyxDQUFDO1FBQ0YsSUFBSSxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVEsRUFBRTtZQUMvQixJQUFJLENBQUMscUJBQXFCLEdBQUcsSUFBSSxDQUFDLHFCQUFxQixDQUFDLFdBQVcsQ0FDakUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUNwRSxDQUFDO1NBQ0g7YUFBTTtZQUNMLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsV0FBVyxDQUNqRSxJQUFJLENBQUMsY0FBYyxDQUFDLGtCQUFrQixDQUNwQyxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQ3ZDLENBQ0YsQ0FBQztTQUNIO1FBQ0QsSUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQztRQUNsRCxJQUFJLENBQUMsc0NBQXNDO1lBQ3pDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxLQUFLLENBQzVCLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLE1BQU0sQ0FDckQsQ0FBQztJQUNOLENBQUM7SUFFRDs7O09BR0c7SUFDSSxZQUFZLENBQUMsS0FBOEI7UUFDaEQsUUFBUSxLQUFLLENBQUMsTUFBTSxFQUFFO1lBQ3BCLEtBQUssYUFBYSxDQUFDLElBQUk7Z0JBQ3JCLElBQUksQ0FBQyxhQUFhLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxDQUFDO2dCQUMvRCxJQUFJLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxDQUFDO29CQUMxQixJQUFJLEVBQUUsSUFBSSxDQUFDLGFBQWE7b0JBQ3hCLEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSztpQkFDbEIsQ0FBQyxDQUFDO2dCQUNILElBQUksQ0FBQyw2QkFBNkIsR0FBRyxRQUFRLENBQUMsSUFBSSxDQUFDO2dCQUNuRCxNQUFNO1lBQ1IsS0FBSyxhQUFhLENBQUMsTUFBTTtnQkFDdkIsSUFBSSxDQUFDLDZCQUE2QixHQUFHLFFBQVEsQ0FBQyxJQUFJLENBQUM7Z0JBQ25ELE1BQU07WUFDUixLQUFLLGFBQWEsQ0FBQyxJQUFJO2dCQUNyQixJQUFJLENBQUMsNkJBQTZCLEdBQUcsUUFBUSxDQUFDLElBQUksQ0FBQztnQkFDbkQsTUFBTTtZQUNSO2dCQUNFLE1BQU07U0FDVDtJQUNILENBQUM7OzhIQWxHVSxpQ0FBaUM7a0hBQWpDLGlDQUFpQyxtRUN0QjlDLGtXQUtBOzJGRGlCYSxpQ0FBaUM7a0JBTDdDLFNBQVM7K0JBQ0UsNkJBQTZCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50LCBPbkluaXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcclxuaW1wb3J0IHsgRHluYW1pY0RpYWxvZ0NvbmZpZywgRHluYW1pY0RpYWxvZ1JlZiB9IGZyb20gJ3ByaW1lbmcvZHluYW1pY2RpYWxvZyc7XHJcbmltcG9ydCB7XHJcbiAgQmFzZUFjdGlvbixcclxuICBCYXNlQWN0aW9uS2V5LFxyXG4gIER5bmFtaWNGb3JtQWN0aW9uT3V0cHV0LFxyXG59IGZyb20gJy4uLy4uLy4uL2NvcmUvY29tcG9uZW50cy9keW5hbWljLWZvcm0vbW9kZWxzL2Jhc2UtYWN0aW9uJztcclxuaW1wb3J0IHsgVmlld01vZGUgfSBmcm9tICcuLi8uLi8uLi9jb3JlL21vZGVscy9jb25zdGFudHMvdmlldy1tb2RlLmVudW0nO1xyXG5pbXBvcnQgeyBBcnJheVV0aWxpdHlTZXJ2aWNlIH0gZnJvbSAnLi4vLi4vLi4vY29yZS9zZXJ2aWNlcy91dGlsaXR5L2FycmF5LXV0aWxpdHkuc2VydmljZSc7XHJcbmltcG9ydCB7IE9iamVjdHNVdGlsaXR5U2VydmljZSB9IGZyb20gJy4uLy4uLy4uL2NvcmUvc2VydmljZXMvdXRpbGl0eS9vYmplY3RzLXV0aWxpdHkuc2VydmljZSc7XHJcbmltcG9ydCB7IFV0aWxpdHlTZXJ2aWNlIH0gZnJvbSAnLi4vLi4vLi4vY29yZS9zZXJ2aWNlcy91dGlsaXR5L3V0aWxpdHkuc2VydmljZSc7XHJcbmltcG9ydCB7IFByZ0dyaWRzdGVySXRlbSB9IGZyb20gJy4uLy4uL21vZGVscy9wcmctZ3JpZHN0ZXItY29uZmlnJztcclxuaW1wb3J0IHsgREFTSEJPQVJEX0lURU1TX0RZTkFNSUNfRk9STV9BQ1RJT05TIH0gZnJvbSAnLi4vZGFzaGJvYXJkLWl0ZW1zL2Rhc2hib2FyZC1pdGVtcy1keW5hbWljLWZvcm0tYWN0aW9ucyc7XHJcblxyXG4vKipcclxuICogRGFzaGJvYXJkIEl0ZW1zIE9wdGlvbnMgQ29tcG9uZW50XHJcbiAqL1xyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogJ3ByZy1kYXNoYm9hcmQtaXRlbXMtb3B0aW9ucycsXHJcbiAgdGVtcGxhdGVVcmw6ICcuL3ByZy1kYXNoYm9hcmQtaXRlbXMtb3B0aW9ucy5jb21wb25lbnQuaHRtbCcsXHJcbiAgc3R5bGVVcmxzOiBbJy4vcHJnLWRhc2hib2FyZC1pdGVtcy1vcHRpb25zLmNvbXBvbmVudC5zY3NzJ10sXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBQcmdEYXNoYm9hcmRJdGVtc09wdGlvbnNDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xyXG4gIC8qKlxyXG4gICAqIFRoZSBkeW5hbWljIGZvcm0gZmllbGRzIHRvIGJ1aWxkIGRhc2hib2FyZCBpdGVtcyBmb3JtIGluIHRlbXBsYXRlXHJcbiAgICovXHJcbiAgcHVibGljIGRhc2hib2FyZEl0ZW1zT3B0aW9uc0R5bmFtaWNGb3JtRmllbGRzOiBhbnlbXSA9IFtdO1xyXG4gIC8qKlxyXG4gICAqIFRoZSBkeW5hbWljIGZvcm0gYWN0aW9ucyB0byBidWlsZCBkYXNoYm9hcmQgaXRlbXMgZm9ybSBpbiB0ZW1wbGF0ZVxyXG4gICAqL1xyXG4gIHB1YmxpYyBkYXNoYm9hcmRJdGVtc09wdGlvbnNEeW5hbWljRm9ybUFjdGlvbnM6IEJhc2VBY3Rpb25bXSA9XHJcbiAgICB0aGlzLmFycmF5VXRpbGl0eVNlcnZpY2UuY2xvbmUoREFTSEJPQVJEX0lURU1TX0RZTkFNSUNfRk9STV9BQ1RJT05TKTtcclxuICAvKipcclxuICAgKiBUaGUgdmlldyBtb2RlIGZvciBkeW5hbWljIGZvcm1cclxuICAgKiBAdHlwZSB7Vmlld01vZGV9XHJcbiAgICovXHJcbiAgcHVibGljIGRhc2hib2FyZEl0ZW1zT3B0aW9uc1ZpZXdNb2RlID0gVmlld01vZGUuUmVhZDtcclxuICAvKipcclxuICAgKiBUaGUgZGFzaGJvYXJkIGl0ZW0gc2V0dGluZ3MgdG8gYmUgdXNlZCBvbiB0aGUgZm9ybSAoZW50aXR5KVxyXG4gICAqL1xyXG4gIHB1YmxpYyBkYXNoYm9hcmRJdGVtU2V0dGluZ3M7XHJcbiAgLyoqXHJcbiAgICogVGhlIGRhc2hib2FyZCB3aWRnZXQgKGR5bmFtaWMgY29tcG9uZW50KSB0byBiZSBlZGl0ZWRcclxuICAgKiBAdHlwZSB7UHJnR3JpZHN0ZXJJdGVtfVxyXG4gICAqIEBwcml2YXRlXHJcbiAgICovXHJcbiAgcHJpdmF0ZSBkYXNoYm9hcmRJdGVtOiBQcmdHcmlkc3Rlckl0ZW07XHJcbiAgLyoqXHJcbiAgICogVGhlIGluZGV4IG9mIGRhc2hib2FyZCBpdGVtIG9uIHRoZSBhcnJheSBvZiBpdGVtc1xyXG4gICAqIEB0eXBlIHtudW1iZXJ9XHJcbiAgICogQHByaXZhdGVcclxuICAgKi9cclxuICBwcml2YXRlIGluZGV4OiBudW1iZXI7XHJcblxyXG4gIC8qKlxyXG4gICAqIENvbnN0cnVjdG9yXHJcbiAgICogQHBhcmFtIHtPYmplY3RzVXRpbGl0eVNlcnZpY2V9IG9iamVjdHNVdGlsaXR5U2VydmljZVxyXG4gICAqIEBwYXJhbSB7QXJyYXlVdGlsaXR5U2VydmljZX0gYXJyYXlVdGlsaXR5U2VydmljZVxyXG4gICAqIEBwYXJhbSB7RHluYW1pY0RpYWxvZ1JlZn0gZHluYW1pY0RpYWxvZ1JlZlxyXG4gICAqIEBwYXJhbSB7RHluYW1pY0RpYWxvZ0NvbmZpZ30gZHluYW1pY0RpYWxvZ0NvbmZpZ1xyXG4gICAqIEBwYXJhbSB7VXRpbGl0eVNlcnZpY2V9IHV0aWxpdHlTZXJ2aWNlXHJcbiAgICovXHJcbiAgY29uc3RydWN0b3IoXHJcbiAgICBwcml2YXRlIG9iamVjdHNVdGlsaXR5U2VydmljZTogT2JqZWN0c1V0aWxpdHlTZXJ2aWNlLFxyXG4gICAgcHJpdmF0ZSBhcnJheVV0aWxpdHlTZXJ2aWNlOiBBcnJheVV0aWxpdHlTZXJ2aWNlLFxyXG4gICAgcHJpdmF0ZSBkeW5hbWljRGlhbG9nUmVmOiBEeW5hbWljRGlhbG9nUmVmLFxyXG4gICAgcHJpdmF0ZSBkeW5hbWljRGlhbG9nQ29uZmlnOiBEeW5hbWljRGlhbG9nQ29uZmlnLFxyXG4gICAgcHJpdmF0ZSB1dGlsaXR5U2VydmljZTogVXRpbGl0eVNlcnZpY2VcclxuICApIHt9XHJcblxyXG4gIC8qKlxyXG4gICAqIG5nT25Jbml0XHJcbiAgICpcclxuICAgKiBHZXQgdGhlIGRhdGEgZnJvbSBwYXJlbnQgY29tcG9uZW50XHJcbiAgICovXHJcbiAgcHVibGljIG5nT25Jbml0KCkge1xyXG4gICAgdGhpcy5kYXNoYm9hcmRJdGVtID0gdGhpcy5vYmplY3RzVXRpbGl0eVNlcnZpY2UuY2xvbmVPYmplY3QoXHJcbiAgICAgIHRoaXMuZHluYW1pY0RpYWxvZ0NvbmZpZy5kYXRhPy5pdGVtXHJcbiAgICApO1xyXG4gICAgaWYgKHRoaXMuZGFzaGJvYXJkSXRlbS5zZXR0aW5ncykge1xyXG4gICAgICB0aGlzLmRhc2hib2FyZEl0ZW1TZXR0aW5ncyA9IHRoaXMub2JqZWN0c1V0aWxpdHlTZXJ2aWNlLmNsb25lT2JqZWN0KFxyXG4gICAgICAgIHRoaXMudXRpbGl0eVNlcnZpY2UuZ3VpU2V0dGluZ1RvT2JqZWN0KHRoaXMuZGFzaGJvYXJkSXRlbS5zZXR0aW5ncylcclxuICAgICAgKTtcclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIHRoaXMuZGFzaGJvYXJkSXRlbVNldHRpbmdzID0gdGhpcy5vYmplY3RzVXRpbGl0eVNlcnZpY2UuY2xvbmVPYmplY3QoXHJcbiAgICAgICAgdGhpcy51dGlsaXR5U2VydmljZS5ndWlTZXR0aW5nVG9PYmplY3QoXHJcbiAgICAgICAgICB0aGlzLmRhc2hib2FyZEl0ZW0uaXRlbS5zdGF0aWNTZXR0aW5nc1xyXG4gICAgICAgIClcclxuICAgICAgKTtcclxuICAgIH1cclxuICAgIHRoaXMuaW5kZXggPSB0aGlzLmR5bmFtaWNEaWFsb2dDb25maWcuZGF0YT8uaW5kZXg7XHJcbiAgICB0aGlzLmRhc2hib2FyZEl0ZW1zT3B0aW9uc0R5bmFtaWNGb3JtRmllbGRzID1cclxuICAgICAgdGhpcy5hcnJheVV0aWxpdHlTZXJ2aWNlLmNsb25lKFxyXG4gICAgICAgIHRoaXMuZGFzaGJvYXJkSXRlbS5pdGVtLmNvbmZpZ3VyYXRpb25TZXR0aW5ncy5maWVsZHNcclxuICAgICAgKTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIFRoaXMgZnVuY3Rpb24gaXMgcmVzcG9uc2libGUgdG8gaGFuZGxlIGFjdGlvbnMgZnJvbSB0aGUgZHluYW1pYyBmb3JtXHJcbiAgICogQHBhcmFtIHtEeW5hbWljRm9ybUFjdGlvbk91dHB1dH0gZXZlbnRcclxuICAgKi9cclxuICBwdWJsaWMgYWN0aW9uT3V0cHV0KGV2ZW50OiBEeW5hbWljRm9ybUFjdGlvbk91dHB1dCk6IHZvaWQge1xyXG4gICAgc3dpdGNoIChldmVudC5hY3Rpb24pIHtcclxuICAgICAgY2FzZSBCYXNlQWN0aW9uS2V5LlNhdmU6XHJcbiAgICAgICAgdGhpcy5kYXNoYm9hcmRJdGVtLnNldHRpbmdzID0gSlNPTi5zdHJpbmdpZnkoZXZlbnQuZm9ybUVudGl0eSk7XHJcbiAgICAgICAgdGhpcy5keW5hbWljRGlhbG9nUmVmLmNsb3NlKHtcclxuICAgICAgICAgIGl0ZW06IHRoaXMuZGFzaGJvYXJkSXRlbSxcclxuICAgICAgICAgIGluZGV4OiB0aGlzLmluZGV4LFxyXG4gICAgICAgIH0pO1xyXG4gICAgICAgIHRoaXMuZGFzaGJvYXJkSXRlbXNPcHRpb25zVmlld01vZGUgPSBWaWV3TW9kZS5SZWFkO1xyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgICBjYXNlIEJhc2VBY3Rpb25LZXkuQ2FuY2VsOlxyXG4gICAgICAgIHRoaXMuZGFzaGJvYXJkSXRlbXNPcHRpb25zVmlld01vZGUgPSBWaWV3TW9kZS5SZWFkO1xyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgICBjYXNlIEJhc2VBY3Rpb25LZXkuRWRpdDpcclxuICAgICAgICB0aGlzLmRhc2hib2FyZEl0ZW1zT3B0aW9uc1ZpZXdNb2RlID0gVmlld01vZGUuRWRpdDtcclxuICAgICAgICBicmVhaztcclxuICAgICAgZGVmYXVsdDpcclxuICAgICAgICBicmVhaztcclxuICAgIH1cclxuICB9XHJcbn1cclxuIiwiPHByZy1keW5hbWljLWZvcm1cclxuICAgICAgICAgICAgICAgICAgW3ZpZXdNb2RlXT1cImRhc2hib2FyZEl0ZW1zT3B0aW9uc1ZpZXdNb2RlXCJcclxuICAgICAgICAgICAgICAgICAgW2ZpZWxkc109XCJkYXNoYm9hcmRJdGVtc09wdGlvbnNEeW5hbWljRm9ybUZpZWxkc1wiIFtlbnRpdHldPVwiZGFzaGJvYXJkSXRlbVNldHRpbmdzXCJcclxuICAgICAgICAgICAgICAgICAgKGFjdGlvbk91dHB1dCk9XCJhY3Rpb25PdXRwdXQoJGV2ZW50KVwiXHJcbiAgICAgICAgICAgICAgICAgIFthY3Rpb25zXT1cImRhc2hib2FyZEl0ZW1zT3B0aW9uc0R5bmFtaWNGb3JtQWN0aW9uc1wiID48L3ByZy1keW5hbWljLWZvcm0+XHJcbiJdfQ==