import { Injectable } from '@angular/core';
import { PrgValidators } from '../../models/validators';
import * as i0 from "@angular/core";
import * as i1 from "./array-utility.service";
import * as i2 from "./objects-utility.service";
/**
 * Injectable
 */
/**
 * UtilityService
 */
export class UtilityService {
    /**
     * Constructor
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(arrayUtilityService, objectsUtilityService) {
        this.arrayUtilityService = arrayUtilityService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * the default debounce time
         * @type {number}
         * @private
         */
        this.defaultDebounceTime = 1500;
    }
    /**
     * this function generate a string
     * @returns string
     */
    newGuid() {
        return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
            // tslint:disable-next-line: no-bitwise
            const r = (Math.random() * 16) | 0, 
            // tslint:disable-next-line: no-bitwise
            v = c === 'x' ? r : (r & 0x3) | 0x8;
            return v.toString(16);
        });
    }
    /**
     * this function make a timeout
     *
     * @param timeInMs
     * @returns Promise<void>
     */
    sleepMsAsync(timeInMs) {
        return new Promise((resolve) => {
            setTimeout(() => {
                resolve();
            }, timeInMs);
        });
    }
    /**
     * this function make a timeout
     *
     * @param timeInSec
     * @returns Promise<void>
     */
    sleepSecAsync(timeInSec) {
        return this.sleepMsAsync(timeInSec * 1000);
    }
    /**
     * Make eval of expression
     * @param {string} expression
     * @param context
     * @returns {any}
     */
    evalFunction(expression, ...context) {
        if (context == null || context.length === 0 || context[0] == null) {
            return function () {
                return eval(expression);
            };
        }
        let mergeContext = this.shallowClone(context[0]);
        context.forEach((cont) => {
            if (cont != null) {
                mergeContext = Object.assign(mergeContext, cont);
            }
        });
        return function () {
            return eval(expression);
        }.call(mergeContext);
        // return eval(expression.replace(new RegExp('this.', 'g'), 'context.'));
    }
    /**
     * An auxiliary function to make a deeper copy of the object
     * @param obj
     * @returns {any}
     * @private
     */
    shallowClone(obj) {
        var clone = Object.create(Object.getPrototypeOf(obj));
        var props = Object.getOwnPropertyNames(obj);
        props.forEach(function (key) {
            var desc = Object.getOwnPropertyDescriptor(obj, key);
            Object.defineProperty(clone, key, desc);
        });
        return clone;
    }
    /**
     * debounce function
     * @param func
     * @param wait
     * @param immediate
     * @returns
     */
    debounce(func, wait = this.defaultDebounceTime, immediate = false) {
        let timeout;
        return function (args = null) {
            const context = this;
            const later = function () {
                timeout = null;
                if (!immediate) {
                    if (Array.isArray(args)) {
                        func.apply(context, args);
                    }
                    else {
                        func.call(context, args);
                    }
                }
            };
            const callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) {
                if (Array.isArray(args)) {
                    func.apply(context, args);
                }
                else {
                    func.call(context, args);
                }
            }
        };
    }
    /**
     * this function transforms the guiSettings into an object,
     * even managing the validators if they exist
     * @param guiSettings
     * @param basePathTranslation
     * @returns
     */
    guiSettingToObject(guiSettings, basePathTranslation = null) {
        const guiSettingsObject = JSON.parse(guiSettings);
        if (!guiSettingsObject.basePathTranslation && basePathTranslation) {
            guiSettingsObject.basePathTranslation = basePathTranslation;
        }
        const validators = guiSettingsObject['validators'];
        if (validators) {
            guiSettingsObject['validators'] = [];
            validators.forEach((validator) => {
                guiSettingsObject['validators'].push(this.evalFunction('this.' + validator.trim(), PrgValidators));
            });
        }
        return guiSettingsObject;
    }
    /**
     * This function build a tree structure to be used on primeng from a list of paths (array of strings) that
     * are joined with a separator ex: "[Configs:UserPreferences:Defaults,Configs:UserPreferences:User...]"
     * @param {string[]} arrayOfPaths
     * @param {string} separator
     * @returns {TreeNode[]}
     */
    arrayOfPathsToTree(arrayOfPaths, separator) {
        //Remove duplicates from the array of paths
        const itemsUniquePath = this.arrayUtilityService.clone(Array.from(new Set(arrayOfPaths)));
        //Sort array of paths alphabetically
        const itemsUniquePathSorted = itemsUniquePath.sort((a, b) => a.localeCompare(b));
        //split the path in subArrays with separator
        const itemsSplitPath = itemsUniquePathSorted.map((value) => value.split(separator));
        //Find out the number of levels that will have the menu
        const menuLevels = itemsSplitPath.reduce((previousValue, currentValue) => previousValue > currentValue.length
            ? previousValue
            : currentValue.length, 0 // initial value
        );
        // Tree table construction
        const tree = [];
        const levels = [tree];
        let lastPath = [];
        itemsUniquePathSorted.forEach((path) => {
            let splitPathTemp = path.split(':');
            splitPathTemp.forEach((label, index) => {
                if (lastPath[index] === label)
                    return;
                let parentPath = [];
                splitPathTemp.map((path, subIndex) => {
                    if (index >= subIndex) {
                        parentPath.push(path);
                    }
                });
                if (index < menuLevels - 1) {
                    levels[index].push({
                        label,
                        expanded: true,
                        key: parentPath.join(separator),
                        children: (levels[index + 1] = []),
                        selectable: index === splitPathTemp.length - 1,
                    });
                }
                else {
                    levels[index].push({
                        label,
                        key: parentPath.join(separator),
                        selectable: true,
                    });
                }
            });
            lastPath = splitPathTemp;
        });
        return tree;
    }
    /**
     * This function is responsible to search for a key in map by a given value
     * @param map
     * @param searchValue
     * @returns {any}
     */
    getKeyByValueOnMap(map, searchValue) {
        for (let [key, value] of map.entries()) {
            if (value === searchValue)
                return key;
        }
    }
}
UtilityService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: UtilityService, deps: [{ token: i1.ArrayUtilityService }, { token: i2.ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Injectable });
UtilityService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: UtilityService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: UtilityService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: i1.ArrayUtilityService }, { type: i2.ObjectsUtilityService }]; } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbGl0eS5zZXJ2aWNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvUHJnRnJhbWV3b3JrLkZFLkNvcmVMaWIvc3JjL2xpYi9tb2R1bGVzL2NvcmUvc2VydmljZXMvdXRpbGl0eS91dGlsaXR5LnNlcnZpY2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUUzQyxPQUFPLEVBQUUsYUFBYSxFQUFFLE1BQU0seUJBQXlCLENBQUM7Ozs7QUFJeEQ7O0dBRUc7QUFLSDs7R0FFRztBQUNILE1BQU0sT0FBTyxjQUFjO0lBQ3pCOzs7O09BSUc7SUFDSCxZQUNVLG1CQUF3QyxFQUN4QyxxQkFBNEM7UUFENUMsd0JBQW1CLEdBQW5CLG1CQUFtQixDQUFxQjtRQUN4QywwQkFBcUIsR0FBckIscUJBQXFCLENBQXVCO1FBR3REOzs7O1dBSUc7UUFDSyx3QkFBbUIsR0FBVyxJQUFJLENBQUM7SUFQeEMsQ0FBQztJQVNKOzs7T0FHRztJQUNJLE9BQU87UUFDWixPQUFPLHNDQUFzQyxDQUFDLE9BQU8sQ0FDbkQsT0FBTyxFQUNQLFVBQVUsQ0FBQztZQUNULHVDQUF1QztZQUN2QyxNQUFNLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsR0FBRyxFQUFFLENBQUMsR0FBRyxDQUFDO1lBQ2hDLHVDQUF1QztZQUN2QyxDQUFDLEdBQUcsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxHQUFHLENBQUMsR0FBRyxHQUFHLENBQUM7WUFDdEMsT0FBTyxDQUFDLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQyxDQUFDO1FBQ3hCLENBQUMsQ0FDRixDQUFDO0lBQ0osQ0FBQztJQUVEOzs7OztPQUtHO0lBQ0ksWUFBWSxDQUFDLFFBQWdCO1FBQ2xDLE9BQU8sSUFBSSxPQUFPLENBQU8sQ0FBQyxPQUFPLEVBQUUsRUFBRTtZQUNuQyxVQUFVLENBQUMsR0FBRyxFQUFFO2dCQUNkLE9BQU8sRUFBRSxDQUFDO1lBQ1osQ0FBQyxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBQ2YsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQ7Ozs7O09BS0c7SUFDSSxhQUFhLENBQUMsU0FBaUI7UUFDcEMsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRUQ7Ozs7O09BS0c7SUFDSSxZQUFZLENBQUMsVUFBa0IsRUFBRSxHQUFHLE9BQWM7UUFDdkQsSUFBSSxPQUFPLElBQUksSUFBSSxJQUFJLE9BQU8sQ0FBQyxNQUFNLEtBQUssQ0FBQyxJQUFJLE9BQU8sQ0FBQyxDQUFDLENBQUMsSUFBSSxJQUFJLEVBQUU7WUFDakUsT0FBTztnQkFDTCxPQUFPLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztZQUMxQixDQUFDLENBQUM7U0FDSDtRQUNELElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDakQsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLElBQUksRUFBRSxFQUFFO1lBQ3ZCLElBQUksSUFBSSxJQUFJLElBQUksRUFBRTtnQkFDaEIsWUFBWSxHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUMsWUFBWSxFQUFFLElBQUksQ0FBQyxDQUFDO2FBQ2xEO1FBQ0gsQ0FBQyxDQUFDLENBQUM7UUFDSCxPQUFPO1lBQ0wsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDMUIsQ0FBQyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQztRQUNyQix5RUFBeUU7SUFDM0UsQ0FBQztJQUVEOzs7OztPQUtHO0lBQ0ssWUFBWSxDQUFDLEdBQUc7UUFDdEIsSUFBSSxLQUFLLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsY0FBYyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7UUFDdEQsSUFBSSxLQUFLLEdBQUcsTUFBTSxDQUFDLG1CQUFtQixDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQzVDLEtBQUssQ0FBQyxPQUFPLENBQUMsVUFBVSxHQUFHO1lBQ3pCLElBQUksSUFBSSxHQUFHLE1BQU0sQ0FBQyx3QkFBd0IsQ0FBQyxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7WUFDckQsTUFBTSxDQUFDLGNBQWMsQ0FBQyxLQUFLLEVBQUUsR0FBRyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzFDLENBQUMsQ0FBQyxDQUFDO1FBQ0gsT0FBTyxLQUFLLENBQUM7SUFDZixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksUUFBUSxDQUNiLElBQVMsRUFDVCxPQUFlLElBQUksQ0FBQyxtQkFBbUIsRUFDdkMsWUFBcUIsS0FBSztRQUUxQixJQUFJLE9BQVksQ0FBQztRQUVqQixPQUFPLFVBQVUsT0FBWSxJQUFJO1lBQy9CLE1BQU0sT0FBTyxHQUFHLElBQUksQ0FBQztZQUVyQixNQUFNLEtBQUssR0FBRztnQkFDWixPQUFPLEdBQUcsSUFBSSxDQUFDO2dCQUNmLElBQUksQ0FBQyxTQUFTLEVBQUU7b0JBQ2QsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxFQUFFO3dCQUN2QixJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsQ0FBQztxQkFDM0I7eUJBQU07d0JBQ0wsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLENBQUM7cUJBQzFCO2lCQUNGO1lBQ0gsQ0FBQyxDQUFDO1lBRUYsTUFBTSxPQUFPLEdBQUcsU0FBUyxJQUFJLENBQUMsT0FBTyxDQUFDO1lBRXRDLFlBQVksQ0FBQyxPQUFPLENBQUMsQ0FBQztZQUV0QixPQUFPLEdBQUcsVUFBVSxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsQ0FBQztZQUVsQyxJQUFJLE9BQU8sRUFBRTtnQkFDWCxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEVBQUU7b0JBQ3ZCLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxDQUFDO2lCQUMzQjtxQkFBTTtvQkFDTCxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsQ0FBQztpQkFDMUI7YUFDRjtRQUNILENBQUMsQ0FBQztJQUNKLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQkFBa0IsQ0FDdkIsV0FBbUIsRUFDbkIsc0JBQThCLElBQUk7UUFFbEMsTUFBTSxpQkFBaUIsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBRWxELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsSUFBSSxtQkFBbUIsRUFBRTtZQUNqRSxpQkFBaUIsQ0FBQyxtQkFBbUIsR0FBRyxtQkFBbUIsQ0FBQztTQUM3RDtRQUVELE1BQU0sVUFBVSxHQUFHLGlCQUFpQixDQUFDLFlBQVksQ0FBQyxDQUFDO1FBQ25ELElBQUksVUFBVSxFQUFFO1lBQ2QsaUJBQWlCLENBQUMsWUFBWSxDQUFDLEdBQUcsRUFBRSxDQUFDO1lBQ3JDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxTQUFTLEVBQUUsRUFBRTtnQkFDL0IsaUJBQWlCLENBQUMsWUFBWSxDQUFDLENBQUMsSUFBSSxDQUNsQyxJQUFJLENBQUMsWUFBWSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUMsSUFBSSxFQUFFLEVBQUUsYUFBYSxDQUFDLENBQzdELENBQUM7WUFDSixDQUFDLENBQUMsQ0FBQztTQUNKO1FBQ0QsT0FBTyxpQkFBaUIsQ0FBQztJQUMzQixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCLENBQ3ZCLFlBQXNCLEVBQ3RCLFNBQWlCO1FBRWpCLDJDQUEyQztRQUMzQyxNQUFNLGVBQWUsR0FBYSxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxDQUM5RCxLQUFLLENBQUMsSUFBSSxDQUFDLElBQUksR0FBRyxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQ2xDLENBQUM7UUFFRixvQ0FBb0M7UUFDcEMsTUFBTSxxQkFBcUIsR0FBRyxlQUFlLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQzFELENBQUMsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQ25CLENBQUM7UUFFRiw0Q0FBNEM7UUFDNUMsTUFBTSxjQUFjLEdBQUcscUJBQXFCLENBQUMsR0FBRyxDQUFDLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FDekQsS0FBSyxDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUMsQ0FDdkIsQ0FBQztRQUVGLHVEQUF1RDtRQUN2RCxNQUFNLFVBQVUsR0FBRyxjQUFjLENBQUMsTUFBTSxDQUN0QyxDQUFDLGFBQWEsRUFBRSxZQUFZLEVBQUUsRUFBRSxDQUM5QixhQUFhLEdBQUcsWUFBWSxDQUFDLE1BQU07WUFDakMsQ0FBQyxDQUFDLGFBQWE7WUFDZixDQUFDLENBQUMsWUFBWSxDQUFDLE1BQU0sRUFDekIsQ0FBQyxDQUFDLGdCQUFnQjtTQUNuQixDQUFDO1FBRUYsMEJBQTBCO1FBQzFCLE1BQU0sSUFBSSxHQUFlLEVBQUUsQ0FBQztRQUM1QixNQUFNLE1BQU0sR0FBVSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQzdCLElBQUksUUFBUSxHQUFhLEVBQUUsQ0FBQztRQUM1QixxQkFBcUIsQ0FBQyxPQUFPLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRTtZQUNyQyxJQUFJLGFBQWEsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQ3BDLGFBQWEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLEVBQUU7Z0JBQ3JDLElBQUksUUFBUSxDQUFDLEtBQUssQ0FBQyxLQUFLLEtBQUs7b0JBQUUsT0FBTztnQkFDdEMsSUFBSSxVQUFVLEdBQWEsRUFBRSxDQUFDO2dCQUM5QixhQUFhLENBQUMsR0FBRyxDQUFDLENBQUMsSUFBSSxFQUFFLFFBQVEsRUFBRSxFQUFFO29CQUNuQyxJQUFJLEtBQUssSUFBSSxRQUFRLEVBQUU7d0JBQ3JCLFVBQVUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7cUJBQ3ZCO2dCQUNILENBQUMsQ0FBQyxDQUFDO2dCQUNILElBQUksS0FBSyxHQUFHLFVBQVUsR0FBRyxDQUFDLEVBQUU7b0JBQzFCLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxJQUFJLENBQUM7d0JBQ2pCLEtBQUs7d0JBQ0wsUUFBUSxFQUFFLElBQUk7d0JBQ2QsR0FBRyxFQUFFLFVBQVUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDO3dCQUMvQixRQUFRLEVBQUUsQ0FBQyxNQUFNLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQyxHQUFHLEVBQUUsQ0FBQzt3QkFDbEMsVUFBVSxFQUFFLEtBQUssS0FBSyxhQUFhLENBQUMsTUFBTSxHQUFHLENBQUM7cUJBQy9DLENBQUMsQ0FBQztpQkFDSjtxQkFBTTtvQkFDTCxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsSUFBSSxDQUFDO3dCQUNqQixLQUFLO3dCQUNMLEdBQUcsRUFBRSxVQUFVLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQzt3QkFDL0IsVUFBVSxFQUFFLElBQUk7cUJBQ2pCLENBQUMsQ0FBQztpQkFDSjtZQUNILENBQUMsQ0FBQyxDQUFDO1lBQ0gsUUFBUSxHQUFHLGFBQWEsQ0FBQztRQUMzQixDQUFDLENBQUMsQ0FBQztRQUNILE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7OztPQUtHO0lBQ0ksa0JBQWtCLENBQUMsR0FBRyxFQUFFLFdBQVc7UUFDeEMsS0FBSyxJQUFJLENBQUMsR0FBRyxFQUFFLEtBQUssQ0FBQyxJQUFJLEdBQUcsQ0FBQyxPQUFPLEVBQUUsRUFBRTtZQUN0QyxJQUFJLEtBQUssS0FBSyxXQUFXO2dCQUFFLE9BQU8sR0FBRyxDQUFDO1NBQ3ZDO0lBQ0gsQ0FBQzs7MkdBNVBVLGNBQWM7K0dBQWQsY0FBYyxjQU5iLE1BQU07MkZBTVAsY0FBYztrQkFQMUIsVUFBVTttQkFBQztvQkFDVixVQUFVLEVBQUUsTUFBTTtpQkFDbkIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJbmplY3RhYmxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XHJcbmltcG9ydCB7IFRyZWVOb2RlIH0gZnJvbSAncHJpbWVuZy9hcGknO1xyXG5pbXBvcnQgeyBQcmdWYWxpZGF0b3JzIH0gZnJvbSAnLi4vLi4vbW9kZWxzL3ZhbGlkYXRvcnMnO1xyXG5pbXBvcnQgeyBBcnJheVV0aWxpdHlTZXJ2aWNlIH0gZnJvbSAnLi9hcnJheS11dGlsaXR5LnNlcnZpY2UnO1xyXG5pbXBvcnQgeyBPYmplY3RzVXRpbGl0eVNlcnZpY2UgfSBmcm9tICcuL29iamVjdHMtdXRpbGl0eS5zZXJ2aWNlJztcclxuXHJcbi8qKlxyXG4gKiBJbmplY3RhYmxlXHJcbiAqL1xyXG5ASW5qZWN0YWJsZSh7XHJcbiAgcHJvdmlkZWRJbjogJ3Jvb3QnLFxyXG59KVxyXG5cclxuLyoqXHJcbiAqIFV0aWxpdHlTZXJ2aWNlXHJcbiAqL1xyXG5leHBvcnQgY2xhc3MgVXRpbGl0eVNlcnZpY2Uge1xyXG4gIC8qKlxyXG4gICAqIENvbnN0cnVjdG9yXHJcbiAgICogQHBhcmFtIHtBcnJheVV0aWxpdHlTZXJ2aWNlfSBhcnJheVV0aWxpdHlTZXJ2aWNlXHJcbiAgICogQHBhcmFtIHtPYmplY3RzVXRpbGl0eVNlcnZpY2V9IG9iamVjdHNVdGlsaXR5U2VydmljZVxyXG4gICAqL1xyXG4gIGNvbnN0cnVjdG9yKFxyXG4gICAgcHJpdmF0ZSBhcnJheVV0aWxpdHlTZXJ2aWNlOiBBcnJheVV0aWxpdHlTZXJ2aWNlLFxyXG4gICAgcHJpdmF0ZSBvYmplY3RzVXRpbGl0eVNlcnZpY2U6IE9iamVjdHNVdGlsaXR5U2VydmljZVxyXG4gICkge31cclxuXHJcbiAgLyoqXHJcbiAgICogdGhlIGRlZmF1bHQgZGVib3VuY2UgdGltZVxyXG4gICAqIEB0eXBlIHtudW1iZXJ9XHJcbiAgICogQHByaXZhdGVcclxuICAgKi9cclxuICBwcml2YXRlIGRlZmF1bHREZWJvdW5jZVRpbWU6IG51bWJlciA9IDE1MDA7XHJcblxyXG4gIC8qKlxyXG4gICAqIHRoaXMgZnVuY3Rpb24gZ2VuZXJhdGUgYSBzdHJpbmdcclxuICAgKiBAcmV0dXJucyBzdHJpbmdcclxuICAgKi9cclxuICBwdWJsaWMgbmV3R3VpZCgpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuICd4eHh4eHh4eC14eHh4LTR4eHgteXh4eC14eHh4eHh4eHh4eHgnLnJlcGxhY2UoXHJcbiAgICAgIC9beHldL2csXHJcbiAgICAgIGZ1bmN0aW9uIChjKSB7XHJcbiAgICAgICAgLy8gdHNsaW50OmRpc2FibGUtbmV4dC1saW5lOiBuby1iaXR3aXNlXHJcbiAgICAgICAgY29uc3QgciA9IChNYXRoLnJhbmRvbSgpICogMTYpIHwgMCxcclxuICAgICAgICAgIC8vIHRzbGludDpkaXNhYmxlLW5leHQtbGluZTogbm8tYml0d2lzZVxyXG4gICAgICAgICAgdiA9IGMgPT09ICd4JyA/IHIgOiAociAmIDB4MykgfCAweDg7XHJcbiAgICAgICAgcmV0dXJuIHYudG9TdHJpbmcoMTYpO1xyXG4gICAgICB9XHJcbiAgICApO1xyXG4gIH1cclxuXHJcbiAgLyoqXHJcbiAgICogdGhpcyBmdW5jdGlvbiBtYWtlIGEgdGltZW91dFxyXG4gICAqXHJcbiAgICogQHBhcmFtIHRpbWVJbk1zXHJcbiAgICogQHJldHVybnMgUHJvbWlzZTx2b2lkPlxyXG4gICAqL1xyXG4gIHB1YmxpYyBzbGVlcE1zQXN5bmModGltZUluTXM6IG51bWJlcik6IFByb21pc2U8dm9pZD4ge1xyXG4gICAgcmV0dXJuIG5ldyBQcm9taXNlPHZvaWQ+KChyZXNvbHZlKSA9PiB7XHJcbiAgICAgIHNldFRpbWVvdXQoKCkgPT4ge1xyXG4gICAgICAgIHJlc29sdmUoKTtcclxuICAgICAgfSwgdGltZUluTXMpO1xyXG4gICAgfSk7XHJcbiAgfVxyXG5cclxuICAvKipcclxuICAgKiB0aGlzIGZ1bmN0aW9uIG1ha2UgYSB0aW1lb3V0XHJcbiAgICpcclxuICAgKiBAcGFyYW0gdGltZUluU2VjXHJcbiAgICogQHJldHVybnMgUHJvbWlzZTx2b2lkPlxyXG4gICAqL1xyXG4gIHB1YmxpYyBzbGVlcFNlY0FzeW5jKHRpbWVJblNlYzogbnVtYmVyKTogUHJvbWlzZTx2b2lkPiB7XHJcbiAgICByZXR1cm4gdGhpcy5zbGVlcE1zQXN5bmModGltZUluU2VjICogMTAwMCk7XHJcbiAgfVxyXG5cclxuICAvKipcclxuICAgKiBNYWtlIGV2YWwgb2YgZXhwcmVzc2lvblxyXG4gICAqIEBwYXJhbSB7c3RyaW5nfSBleHByZXNzaW9uXHJcbiAgICogQHBhcmFtIGNvbnRleHRcclxuICAgKiBAcmV0dXJucyB7YW55fVxyXG4gICAqL1xyXG4gIHB1YmxpYyBldmFsRnVuY3Rpb24oZXhwcmVzc2lvbjogc3RyaW5nLCAuLi5jb250ZXh0OiBhbnlbXSk6IGFueSB7XHJcbiAgICBpZiAoY29udGV4dCA9PSBudWxsIHx8IGNvbnRleHQubGVuZ3RoID09PSAwIHx8IGNvbnRleHRbMF0gPT0gbnVsbCkge1xyXG4gICAgICByZXR1cm4gZnVuY3Rpb24gKCkge1xyXG4gICAgICAgIHJldHVybiBldmFsKGV4cHJlc3Npb24pO1xyXG4gICAgICB9O1xyXG4gICAgfVxyXG4gICAgbGV0IG1lcmdlQ29udGV4dCA9IHRoaXMuc2hhbGxvd0Nsb25lKGNvbnRleHRbMF0pO1xyXG4gICAgY29udGV4dC5mb3JFYWNoKChjb250KSA9PiB7XHJcbiAgICAgIGlmIChjb250ICE9IG51bGwpIHtcclxuICAgICAgICBtZXJnZUNvbnRleHQgPSBPYmplY3QuYXNzaWduKG1lcmdlQ29udGV4dCwgY29udCk7XHJcbiAgICAgIH1cclxuICAgIH0pO1xyXG4gICAgcmV0dXJuIGZ1bmN0aW9uICgpIHtcclxuICAgICAgcmV0dXJuIGV2YWwoZXhwcmVzc2lvbik7XHJcbiAgICB9LmNhbGwobWVyZ2VDb250ZXh0KTtcclxuICAgIC8vIHJldHVybiBldmFsKGV4cHJlc3Npb24ucmVwbGFjZShuZXcgUmVnRXhwKCd0aGlzLicsICdnJyksICdjb250ZXh0LicpKTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIEFuIGF1eGlsaWFyeSBmdW5jdGlvbiB0byBtYWtlIGEgZGVlcGVyIGNvcHkgb2YgdGhlIG9iamVjdFxyXG4gICAqIEBwYXJhbSBvYmpcclxuICAgKiBAcmV0dXJucyB7YW55fVxyXG4gICAqIEBwcml2YXRlXHJcbiAgICovXHJcbiAgcHJpdmF0ZSBzaGFsbG93Q2xvbmUob2JqKSB7XHJcbiAgICB2YXIgY2xvbmUgPSBPYmplY3QuY3JlYXRlKE9iamVjdC5nZXRQcm90b3R5cGVPZihvYmopKTtcclxuICAgIHZhciBwcm9wcyA9IE9iamVjdC5nZXRPd25Qcm9wZXJ0eU5hbWVzKG9iaik7XHJcbiAgICBwcm9wcy5mb3JFYWNoKGZ1bmN0aW9uIChrZXkpIHtcclxuICAgICAgdmFyIGRlc2MgPSBPYmplY3QuZ2V0T3duUHJvcGVydHlEZXNjcmlwdG9yKG9iaiwga2V5KTtcclxuICAgICAgT2JqZWN0LmRlZmluZVByb3BlcnR5KGNsb25lLCBrZXksIGRlc2MpO1xyXG4gICAgfSk7XHJcbiAgICByZXR1cm4gY2xvbmU7XHJcbiAgfVxyXG5cclxuICAvKipcclxuICAgKiBkZWJvdW5jZSBmdW5jdGlvblxyXG4gICAqIEBwYXJhbSBmdW5jXHJcbiAgICogQHBhcmFtIHdhaXRcclxuICAgKiBAcGFyYW0gaW1tZWRpYXRlXHJcbiAgICogQHJldHVybnNcclxuICAgKi9cclxuICBwdWJsaWMgZGVib3VuY2UoXHJcbiAgICBmdW5jOiBhbnksXHJcbiAgICB3YWl0OiBudW1iZXIgPSB0aGlzLmRlZmF1bHREZWJvdW5jZVRpbWUsXHJcbiAgICBpbW1lZGlhdGU6IGJvb2xlYW4gPSBmYWxzZVxyXG4gICkge1xyXG4gICAgbGV0IHRpbWVvdXQ6IGFueTtcclxuXHJcbiAgICByZXR1cm4gZnVuY3Rpb24gKGFyZ3M6IGFueSA9IG51bGwpIHtcclxuICAgICAgY29uc3QgY29udGV4dCA9IHRoaXM7XHJcblxyXG4gICAgICBjb25zdCBsYXRlciA9IGZ1bmN0aW9uICgpIHtcclxuICAgICAgICB0aW1lb3V0ID0gbnVsbDtcclxuICAgICAgICBpZiAoIWltbWVkaWF0ZSkge1xyXG4gICAgICAgICAgaWYgKEFycmF5LmlzQXJyYXkoYXJncykpIHtcclxuICAgICAgICAgICAgZnVuYy5hcHBseShjb250ZXh0LCBhcmdzKTtcclxuICAgICAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgICAgIGZ1bmMuY2FsbChjb250ZXh0LCBhcmdzKTtcclxuICAgICAgICAgIH1cclxuICAgICAgICB9XHJcbiAgICAgIH07XHJcblxyXG4gICAgICBjb25zdCBjYWxsTm93ID0gaW1tZWRpYXRlICYmICF0aW1lb3V0O1xyXG5cclxuICAgICAgY2xlYXJUaW1lb3V0KHRpbWVvdXQpO1xyXG5cclxuICAgICAgdGltZW91dCA9IHNldFRpbWVvdXQobGF0ZXIsIHdhaXQpO1xyXG5cclxuICAgICAgaWYgKGNhbGxOb3cpIHtcclxuICAgICAgICBpZiAoQXJyYXkuaXNBcnJheShhcmdzKSkge1xyXG4gICAgICAgICAgZnVuYy5hcHBseShjb250ZXh0LCBhcmdzKTtcclxuICAgICAgICB9IGVsc2Uge1xyXG4gICAgICAgICAgZnVuYy5jYWxsKGNvbnRleHQsIGFyZ3MpO1xyXG4gICAgICAgIH1cclxuICAgICAgfVxyXG4gICAgfTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIHRoaXMgZnVuY3Rpb24gdHJhbnNmb3JtcyB0aGUgZ3VpU2V0dGluZ3MgaW50byBhbiBvYmplY3QsXHJcbiAgICogZXZlbiBtYW5hZ2luZyB0aGUgdmFsaWRhdG9ycyBpZiB0aGV5IGV4aXN0XHJcbiAgICogQHBhcmFtIGd1aVNldHRpbmdzXHJcbiAgICogQHBhcmFtIGJhc2VQYXRoVHJhbnNsYXRpb25cclxuICAgKiBAcmV0dXJuc1xyXG4gICAqL1xyXG4gIHB1YmxpYyBndWlTZXR0aW5nVG9PYmplY3QoXHJcbiAgICBndWlTZXR0aW5nczogc3RyaW5nLFxyXG4gICAgYmFzZVBhdGhUcmFuc2xhdGlvbjogc3RyaW5nID0gbnVsbFxyXG4gICk6IGFueSB7XHJcbiAgICBjb25zdCBndWlTZXR0aW5nc09iamVjdCA9IEpTT04ucGFyc2UoZ3VpU2V0dGluZ3MpO1xyXG5cclxuICAgIGlmICghZ3VpU2V0dGluZ3NPYmplY3QuYmFzZVBhdGhUcmFuc2xhdGlvbiAmJiBiYXNlUGF0aFRyYW5zbGF0aW9uKSB7XHJcbiAgICAgIGd1aVNldHRpbmdzT2JqZWN0LmJhc2VQYXRoVHJhbnNsYXRpb24gPSBiYXNlUGF0aFRyYW5zbGF0aW9uO1xyXG4gICAgfVxyXG5cclxuICAgIGNvbnN0IHZhbGlkYXRvcnMgPSBndWlTZXR0aW5nc09iamVjdFsndmFsaWRhdG9ycyddO1xyXG4gICAgaWYgKHZhbGlkYXRvcnMpIHtcclxuICAgICAgZ3VpU2V0dGluZ3NPYmplY3RbJ3ZhbGlkYXRvcnMnXSA9IFtdO1xyXG4gICAgICB2YWxpZGF0b3JzLmZvckVhY2goKHZhbGlkYXRvcikgPT4ge1xyXG4gICAgICAgIGd1aVNldHRpbmdzT2JqZWN0Wyd2YWxpZGF0b3JzJ10ucHVzaChcclxuICAgICAgICAgIHRoaXMuZXZhbEZ1bmN0aW9uKCd0aGlzLicgKyB2YWxpZGF0b3IudHJpbSgpLCBQcmdWYWxpZGF0b3JzKVxyXG4gICAgICAgICk7XHJcbiAgICAgIH0pO1xyXG4gICAgfVxyXG4gICAgcmV0dXJuIGd1aVNldHRpbmdzT2JqZWN0O1xyXG4gIH1cclxuXHJcbiAgLyoqXHJcbiAgICogVGhpcyBmdW5jdGlvbiBidWlsZCBhIHRyZWUgc3RydWN0dXJlIHRvIGJlIHVzZWQgb24gcHJpbWVuZyBmcm9tIGEgbGlzdCBvZiBwYXRocyAoYXJyYXkgb2Ygc3RyaW5ncykgdGhhdFxyXG4gICAqIGFyZSBqb2luZWQgd2l0aCBhIHNlcGFyYXRvciBleDogXCJbQ29uZmlnczpVc2VyUHJlZmVyZW5jZXM6RGVmYXVsdHMsQ29uZmlnczpVc2VyUHJlZmVyZW5jZXM6VXNlci4uLl1cIlxyXG4gICAqIEBwYXJhbSB7c3RyaW5nW119IGFycmF5T2ZQYXRoc1xyXG4gICAqIEBwYXJhbSB7c3RyaW5nfSBzZXBhcmF0b3JcclxuICAgKiBAcmV0dXJucyB7VHJlZU5vZGVbXX1cclxuICAgKi9cclxuICBwdWJsaWMgYXJyYXlPZlBhdGhzVG9UcmVlKFxyXG4gICAgYXJyYXlPZlBhdGhzOiBzdHJpbmdbXSxcclxuICAgIHNlcGFyYXRvcjogc3RyaW5nXHJcbiAgKTogVHJlZU5vZGVbXSB7XHJcbiAgICAvL1JlbW92ZSBkdXBsaWNhdGVzIGZyb20gdGhlIGFycmF5IG9mIHBhdGhzXHJcbiAgICBjb25zdCBpdGVtc1VuaXF1ZVBhdGg6IHN0cmluZ1tdID0gdGhpcy5hcnJheVV0aWxpdHlTZXJ2aWNlLmNsb25lKFxyXG4gICAgICBBcnJheS5mcm9tKG5ldyBTZXQoYXJyYXlPZlBhdGhzKSlcclxuICAgICk7XHJcblxyXG4gICAgLy9Tb3J0IGFycmF5IG9mIHBhdGhzIGFscGhhYmV0aWNhbGx5XHJcbiAgICBjb25zdCBpdGVtc1VuaXF1ZVBhdGhTb3J0ZWQgPSBpdGVtc1VuaXF1ZVBhdGguc29ydCgoYSwgYikgPT5cclxuICAgICAgYS5sb2NhbGVDb21wYXJlKGIpXHJcbiAgICApO1xyXG5cclxuICAgIC8vc3BsaXQgdGhlIHBhdGggaW4gc3ViQXJyYXlzIHdpdGggc2VwYXJhdG9yXHJcbiAgICBjb25zdCBpdGVtc1NwbGl0UGF0aCA9IGl0ZW1zVW5pcXVlUGF0aFNvcnRlZC5tYXAoKHZhbHVlKSA9PlxyXG4gICAgICB2YWx1ZS5zcGxpdChzZXBhcmF0b3IpXHJcbiAgICApO1xyXG5cclxuICAgIC8vRmluZCBvdXQgdGhlIG51bWJlciBvZiBsZXZlbHMgdGhhdCB3aWxsIGhhdmUgdGhlIG1lbnVcclxuICAgIGNvbnN0IG1lbnVMZXZlbHMgPSBpdGVtc1NwbGl0UGF0aC5yZWR1Y2UoXHJcbiAgICAgIChwcmV2aW91c1ZhbHVlLCBjdXJyZW50VmFsdWUpID0+XHJcbiAgICAgICAgcHJldmlvdXNWYWx1ZSA+IGN1cnJlbnRWYWx1ZS5sZW5ndGhcclxuICAgICAgICAgID8gcHJldmlvdXNWYWx1ZVxyXG4gICAgICAgICAgOiBjdXJyZW50VmFsdWUubGVuZ3RoLFxyXG4gICAgICAwIC8vIGluaXRpYWwgdmFsdWVcclxuICAgICk7XHJcblxyXG4gICAgLy8gVHJlZSB0YWJsZSBjb25zdHJ1Y3Rpb25cclxuICAgIGNvbnN0IHRyZWU6IFRyZWVOb2RlW10gPSBbXTtcclxuICAgIGNvbnN0IGxldmVsczogYW55W10gPSBbdHJlZV07XHJcbiAgICBsZXQgbGFzdFBhdGg6IHN0cmluZ1tdID0gW107XHJcbiAgICBpdGVtc1VuaXF1ZVBhdGhTb3J0ZWQuZm9yRWFjaCgocGF0aCkgPT4ge1xyXG4gICAgICBsZXQgc3BsaXRQYXRoVGVtcCA9IHBhdGguc3BsaXQoJzonKTtcclxuICAgICAgc3BsaXRQYXRoVGVtcC5mb3JFYWNoKChsYWJlbCwgaW5kZXgpID0+IHtcclxuICAgICAgICBpZiAobGFzdFBhdGhbaW5kZXhdID09PSBsYWJlbCkgcmV0dXJuO1xyXG4gICAgICAgIGxldCBwYXJlbnRQYXRoOiBzdHJpbmdbXSA9IFtdO1xyXG4gICAgICAgIHNwbGl0UGF0aFRlbXAubWFwKChwYXRoLCBzdWJJbmRleCkgPT4ge1xyXG4gICAgICAgICAgaWYgKGluZGV4ID49IHN1YkluZGV4KSB7XHJcbiAgICAgICAgICAgIHBhcmVudFBhdGgucHVzaChwYXRoKTtcclxuICAgICAgICAgIH1cclxuICAgICAgICB9KTtcclxuICAgICAgICBpZiAoaW5kZXggPCBtZW51TGV2ZWxzIC0gMSkge1xyXG4gICAgICAgICAgbGV2ZWxzW2luZGV4XS5wdXNoKHtcclxuICAgICAgICAgICAgbGFiZWwsXHJcbiAgICAgICAgICAgIGV4cGFuZGVkOiB0cnVlLFxyXG4gICAgICAgICAgICBrZXk6IHBhcmVudFBhdGguam9pbihzZXBhcmF0b3IpLFxyXG4gICAgICAgICAgICBjaGlsZHJlbjogKGxldmVsc1tpbmRleCArIDFdID0gW10pLFxyXG4gICAgICAgICAgICBzZWxlY3RhYmxlOiBpbmRleCA9PT0gc3BsaXRQYXRoVGVtcC5sZW5ndGggLSAxLFxyXG4gICAgICAgICAgfSk7XHJcbiAgICAgICAgfSBlbHNlIHtcclxuICAgICAgICAgIGxldmVsc1tpbmRleF0ucHVzaCh7XHJcbiAgICAgICAgICAgIGxhYmVsLFxyXG4gICAgICAgICAgICBrZXk6IHBhcmVudFBhdGguam9pbihzZXBhcmF0b3IpLFxyXG4gICAgICAgICAgICBzZWxlY3RhYmxlOiB0cnVlLFxyXG4gICAgICAgICAgfSk7XHJcbiAgICAgICAgfVxyXG4gICAgICB9KTtcclxuICAgICAgbGFzdFBhdGggPSBzcGxpdFBhdGhUZW1wO1xyXG4gICAgfSk7XHJcbiAgICByZXR1cm4gdHJlZTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIFRoaXMgZnVuY3Rpb24gaXMgcmVzcG9uc2libGUgdG8gc2VhcmNoIGZvciBhIGtleSBpbiBtYXAgYnkgYSBnaXZlbiB2YWx1ZVxyXG4gICAqIEBwYXJhbSBtYXBcclxuICAgKiBAcGFyYW0gc2VhcmNoVmFsdWVcclxuICAgKiBAcmV0dXJucyB7YW55fVxyXG4gICAqL1xyXG4gIHB1YmxpYyBnZXRLZXlCeVZhbHVlT25NYXAobWFwLCBzZWFyY2hWYWx1ZSk6IGFueSB7XHJcbiAgICBmb3IgKGxldCBba2V5LCB2YWx1ZV0gb2YgbWFwLmVudHJpZXMoKSkge1xyXG4gICAgICBpZiAodmFsdWUgPT09IHNlYXJjaFZhbHVlKSByZXR1cm4ga2V5O1xyXG4gICAgfVxyXG4gIH1cclxufVxyXG4iXX0=