import { Injectable } from '@angular/core';
import { Filter, FilterExpressions, FilterGroup, MapPrimeNgExpressionsToFilterExpressions, MapPrimeNgFilterOperationsToFilterOperations, Order, PrimeNgSortToOrderTypeMap, } from '../../models/filters';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
/**
 * PrimengUtilityService
 */
export class PrimengUtilityService {
    /**
     * this function is to calculate the index of the page we need to request
     * @param event
     * @returns
     */
    calcPageIndex(event) {
        let pageIndex = 0;
        if (event.first != 0) {
            pageIndex = event.first / event.rows;
        }
        return pageIndex;
    }
    /**
     * this function processes the filters coming from
     * the event thrown by primeng and returns
     *  a working filter array to our api
     * @param filters
     * @param globalFilterFields
     * @param globalFilterExpression
     * @returns Filter[]
     */
    filtersProcessing(filters, globalFilterFields, globalFilterExpression) {
        let filtersArray = [];
        const filtersKeys = Object.keys(filters);
        if (filtersKeys.includes('global')) {
            globalFilterFields.forEach((globalFilterField) => {
                filtersArray.push(this.generateFilter(filters['global'].value, globalFilterField, globalFilterExpression, MapPrimeNgFilterOperationsToFilterOperations.get(filters['global'].matchMode)));
            });
        }
        else {
            filtersKeys.forEach((key) => {
                Object.keys(filters[key]).forEach((keySubFilter) => {
                    let eventFilter = filters[key][keySubFilter];
                    if (eventFilter.value) {
                        filtersArray.push(this.generateFilter(eventFilter.value, key, MapPrimeNgExpressionsToFilterExpressions.get(eventFilter.operator), MapPrimeNgFilterOperationsToFilterOperations.get(eventFilter.matchMode)));
                    }
                });
            });
        }
        return filtersArray;
    }
    /**
     * this function creates a filter with the received parameters
     * @param filterValue
     * @param propertyName
     * @param filterExpression
     * @param filterOperation
     * @returns
     */
    generateFilter(filterValue, propertyName, filterExpression, filterOperation) {
        let filter = new Filter();
        filter.value = filterValue;
        filter.propertyName = propertyName;
        filter.filterExpression = filterExpression;
        filter.filterOperation = filterOperation;
        return filter;
    }
    /**
     * this function processes the sort from the primeng
     * event and returns a functional order array to our api
     *
     * @param multiSortMeta
     * @param sortField
     * @param sortOrder
     * @returns Order[]
     */
    sortProcessing(multiSortMeta, sortField, sortOrder) {
        let filterOrders = [];
        if (multiSortMeta) {
            multiSortMeta.forEach((sortElement) => {
                filterOrders.push(new Order({
                    propertyName: sortElement.field,
                    orderType: PrimeNgSortToOrderTypeMap.get(sortElement.order),
                }));
            });
        }
        else {
            filterOrders.push(new Order({
                propertyName: sortField,
                orderType: PrimeNgSortToOrderTypeMap.get(sortOrder),
            }));
        }
        return filterOrders;
    }
    /**
     * this function receives the event from primeng and returns
     * the filtergroup with all the necessary information to be used by our api
     * @param event
     * @param globalFilterFields
     * @param globalFilterExpression
     * @returns FilterGroup
     */
    getFilterGroupByLazyLoadEvent(event, globalFilterFields = [], globalFilterExpression = FilterExpressions.Or) {
        let filterGroup = new FilterGroup();
        filterGroup.pageIndex = this.calcPageIndex(event);
        filterGroup.pageSize = event.rows;
        if (event.sortField || event.multiSortMeta) {
            filterGroup.orderCollection = this.sortProcessing(event.multiSortMeta, event.sortField, event.sortOrder);
        }
        if (event.filters != null && Object.keys(event.filters).length) {
            filterGroup.filterCollections = this.filtersProcessing(event.filters, globalFilterFields, globalFilterExpression);
        }
        return filterGroup;
    }
}
PrimengUtilityService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrimengUtilityService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
PrimengUtilityService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrimengUtilityService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrimengUtilityService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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