import { Injectable } from '@angular/core';
import clone from 'just-clone';
import * as i0 from "@angular/core";
/**
 * injectable
 */
export class ObjectsUtilityService {
    /**
     * Constructor
     */
    constructor() { }
    /**
     * this function return an cloned object
     * @param objectToClone
     * @returns any
     */
    cloneObject(objectToClone) {
        // TODO: search a better way to clone object
        return clone(objectToClone);
    }
    /**
     * This function is responsible to transform a nested object into a flat object
     * @param object
     * @param {string} separator
     * @returns {{}}
     */
    flattenObj(object, separator) {
        // The object which contains the
        // final result
        let result = {};
        // loop through the object "ob"
        for (const i in object) {
            // We check the type of the i using
            // typeof() function and recursively
            // call the function again
            if (typeof object[i] === 'object' && !Array.isArray(object[i])) {
                const temp = this.flattenObj(object[i], separator);
                for (const j in temp) {
                    // Store temp in result
                    result[i + '.' + j] = temp[j];
                }
            }
            // Else store ob[i] in result directly
            else {
                result[i] = object[i];
            }
        }
        return result;
    }
    /**
     * This function is responsible a flat object into a nested object
     *
     * Nested object are define by a separator on properties ex :'.'
     * @param {object} object
     * @param {string} separator
     * @returns {object}
     */
    unFlattenObj(object, separator) {
        const result = {};
        let temp, substrings, property, i;
        for (property in object) {
            substrings = property.split(separator);
            temp = result;
            for (i = 0; i < substrings.length - 1; i++) {
                if (!(substrings[i] in temp)) {
                    if (isFinite(substrings[i + 1])) {
                        temp[substrings[i]] = [];
                    }
                    else {
                        temp[substrings[i]] = {};
                    }
                }
                temp = temp[substrings[i]];
            }
            temp[substrings[substrings.length - 1]] = object[property];
        }
        return result;
    }
}
ObjectsUtilityService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ObjectsUtilityService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
ObjectsUtilityService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ObjectsUtilityService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ObjectsUtilityService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return []; } });
//# sourceMappingURL=data:application/json;base64,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