import { Injectable } from '@angular/core';
import clone from 'just-clone';
import * as i0 from "@angular/core";
/**
 * injectable
 */
export class ArrayUtilityService {
    /**
     * this function  compare two arrays
     * @param array1
     * @param array2
     * @returns boolean
     */
    compareTwoArray(array1, array2) {
        const arr1 = array1.slice().sort();
        return (arr1.length === array2.length &&
            array2
                .slice()
                .sort()
                .every(function (value, index) {
                return value === arr1[index];
            }));
    }
    /**
     * this service creates a treeNode grouped by a certain property
     * @param array
     * @param field
     * @returns TreeNode[]
     */
    groupByField(array, field) {
        let organisedByGroup = new Map();
        let organizedTreeNode = [];
        if (!array || !array.length) {
            return organizedTreeNode;
        }
        array.forEach((element) => {
            if (organisedByGroup.has(element[field])) {
                organisedByGroup.get(element[field]).push({ data: element });
            }
            else {
                organisedByGroup.set(element[field], [{ data: element }]);
            }
        });
        organisedByGroup.forEach((value, key) => {
            let treeNodeAux = {};
            let dataAux = { name: key };
            treeNodeAux.data = dataAux;
            treeNodeAux.children = value;
            treeNodeAux.expanded = true;
            organizedTreeNode.push(treeNodeAux);
        });
        return organizedTreeNode;
    }
    /**clone array
     *
     * @param arrayToClone
     * @returns cloned array
     */
    clone(arrayToClone) {
        return clone(arrayToClone);
    }
    /**
     *sortByProperty
  
     * @param arrayToSort
     * @param property
     * @returns
     */
    sortByProperty(arrayToSort, property, isAsc = true) {
        return this.clone(arrayToSort.sort((a, b) => {
            return this.compare(a[property], b[property], isAsc);
        }));
    }
    /**
     * aux function to sort items when it is static mode
     * @param a
     * @param b
     * @param isAsc
     * @returns
     */
    compare(a, b, isAsc) {
        return (a < b ? -1 : 1) * (isAsc ? 1 : -1);
    }
}
ArrayUtilityService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ArrayUtilityService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
ArrayUtilityService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ArrayUtilityService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ArrayUtilityService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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