import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "primeng/api";
import * as i2 from "@ngx-translate/core";
/**
 * Injectable
 */
export class NotificationsService {
    /**
     * constructor
     *
     * @param messageService
     */
    constructor(messageService, confirmationService, translateService) {
        this.messageService = messageService;
        this.confirmationService = confirmationService;
        this.translateService = translateService;
    }
    /**
     * this function fire an error toast
     * @param error
     */
    errorNotification(error) {
        this.messageService.add({
            key: 'message',
            severity: 'error',
            summary: error.titleKey,
            detail: error.detailKey,
            life: error.life,
        });
    }
    /**
     * this function fire an success toast
     * @param success
     */
    successNotification(success) {
        this.messageService.add({
            key: 'message',
            severity: 'success',
            summary: success.titleKey,
            detail: success.detailKey,
            life: success.life,
        });
    }
    async prgConfirmationService(translationPath, entityNameTranslationParameter = null, throwOnCancel = false) {
        return new Promise(async (resolve, reject) => {
            const confirmationServiceTranslations = await this.translateService
                .get([
                translationPath + '.message',
                translationPath + '.header',
                translationPath + '.icon',
                translationPath + '.reject-label',
                translationPath + '.accept-label',
            ], entityNameTranslationParameter != null
                ? {
                    entityName: entityNameTranslationParameter,
                }
                : null)
                .toPromise();
            this.confirmationService.confirm({
                key: 'confirmationDialog',
                message: confirmationServiceTranslations[translationPath + '.message'],
                header: confirmationServiceTranslations[translationPath + '.header'],
                icon: confirmationServiceTranslations[translationPath + '.icon'],
                rejectLabel: confirmationServiceTranslations[translationPath + '.reject-label'],
                acceptLabel: confirmationServiceTranslations[translationPath + '.accept-label'],
                accept: () => {
                    resolve(true);
                },
                reject: () => {
                    if (throwOnCancel) {
                        reject();
                    }
                    else {
                        resolve(false);
                    }
                },
            });
        });
    }
}
NotificationsService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: NotificationsService, deps: [{ token: i1.MessageService }, { token: i1.ConfirmationService }, { token: i2.TranslateService }], target: i0.ɵɵFactoryTarget.Injectable });
NotificationsService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: NotificationsService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: NotificationsService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: i1.MessageService }, { type: i1.ConfirmationService }, { type: i2.TranslateService }]; } });
//# sourceMappingURL=data:application/json;base64,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