import { Injectable } from '@angular/core';
import { FormControl, FormGroup } from '@angular/forms';
import * as i0 from "@angular/core";
/**
 * injectable
 */
export class FormGroupService {
    /**constructor */
    constructor() { }
    /**
     * this function is responsible for creating a formGroup[]
     * with the respective values and validations for each field of the object
     * @param objects
     * @param columnsData
     * @returns
     */
    toFormGroupMultipleObjects(objects, columnsData) {
        const objectProperties = Object.getOwnPropertyNames(objects[0]);
        let formGroupArray = [];
        objects.forEach((object) => {
            const formGroupAux = new FormGroup(this.getFormGroup(objectProperties, columnsData));
            formGroupAux.setValue(object);
            formGroupArray.push(formGroupAux);
        });
        return formGroupArray;
    }
    /**
     * this function is responsible for creating a formGroup
     * with the respective values and validations for a given object
     *
     * @param object
     * @param columnsData
     * @returns
     */
    toFormGroupOneObject(object, columnsData) {
        const objectProperties = Object.getOwnPropertyNames(object);
        const formGroup = new FormGroup(this.getFormGroup(objectProperties, columnsData));
        formGroup.setValue(object);
        return formGroup;
    }
    /**
     * this function returns an object with the
     * required fields with its formControl
     *
     * @param objectProperties
     * @param columnsData
     * @returns any
     */
    getFormGroup(objectProperties, columnsData) {
        let objectWithValidators = {};
        objectProperties.forEach((property) => {
            const column = columnsData.find((column) => column.key === property);
            let validators = null;
            if (column) {
                validators = column.validators;
            }
            objectWithValidators[property] = new FormControl(null, validators);
        });
        return objectWithValidators;
    }
    /**
     * this function recive fields and transform it in a form group
     * @param fields
     * @returns FormGroup
     */
    toFormGroup(fields) {
        const group = {};
        fields.forEach((field) => {
            group[field.key] = new FormControl(field.value, field.validators);
        });
        return new FormGroup(group);
    }
}
FormGroupService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: FormGroupService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
FormGroupService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: FormGroupService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: FormGroupService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return []; } });
//# sourceMappingURL=data:application/json;base64,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