import { Injectable } from "@angular/core";
import { AbstractConfigurationItemsService } from "./abstract-configuration-items.service";
import { MockDatabase } from "../../models/database.mock";
import * as i0 from "@angular/core";
/**
 * Injectable
 */
/**
 * MOCK ConfigurationItemsService implementation
 */
export class MockConfigurationItemsService extends AbstractConfigurationItemsService {
    /**
     * constructor
     */
    constructor() {
        super();
    }
    /**
     * Gets the mock configuration items from
     * <br />the mock database and sets them
     * <br />on the configurationItemsSubject
     *
     * @returns Boolean promise, true when successful
     */
    getConfigurationItemsAsync() {
        return new Promise((resolve) => {
            const items = MockDatabase.ConfigurationItems;
            if (items != null && items.length) {
                this.setConfigurationItems(items);
                resolve(true);
            }
            else {
                resolve(false);
            }
        });
    }
}
MockConfigurationItemsService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockConfigurationItemsService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
MockConfigurationItemsService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockConfigurationItemsService, providedIn: "root" });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockConfigurationItemsService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: "root",
                }]
        }], ctorParameters: function () { return []; } });
//# sourceMappingURL=data:application/json;base64,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