import { BehaviorSubject } from "rxjs";
/**
 * AbstractConfigurationItemsService class that defines an
 * <br />abstract configuration items service to
 * <br />be extended by the mock and real
 * <br />authentication services
 */
export class AbstractConfigurationItemsService {
    constructor() {
        /**
         * Current configurationItems
         */
        this.configurationItemsSubject = new BehaviorSubject(null);
    }
    /**
     * Setter for configurationItemsSubject
     *
     * @param {ConfigurationItem[]} value The ConfigurationItems array
     */
    setConfigurationItems(value) {
        this.configurationItemsSubject.next(value);
    }
    /**
     * Getter for configurationItemsSubject
     *
     * @returns The configurationItemsSubject as an observable
     */
    getConfigurationItemsObservable() {
        return this.configurationItemsSubject.asObservable();
    }
    /**
     * Getter for configurationItemsSubject
     *
     * @returns The configurationItemsSubject current value
     */
    getConfigurationItemsValue() {
        return this.configurationItemsSubject.getValue();
    }
}
//# sourceMappingURL=data:application/json;base64,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