import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
/**
 * BaseCacheService
 */
export class BaseCacheService {
    constructor() {
        /**
         * map with a BehaviorSubject for each element
         */
        this.cacheMapSubject = new Map();
        /**
         * BehaviorSubject of a list of elements
         */
        this.cacheListSubject = new BehaviorSubject(null);
        /**
         * cache expiration time
         */
        this.cacheTimeMs = 15000;
        /**
         * saves the date the cache was updated
         */
        this.entityTypeGetDate = null;
    }
    /**
     *
     * @param values
     * @param key
     */
    setToCache(values, key = 'id') {
        this.setToCacheMap(values, key);
        this.setToCacheList(values);
    }
    /**
     * this function is responsible for managing the cache of each element
     * @param values
     * @param key
     */
    setToCacheMap(values, key = 'id') {
        if (this.cacheMapSubject == null) {
            this.cacheMapSubject = new Map();
        }
        if (!Array.isArray(values)) {
            values = [values];
        }
        if (Array.isArray(values)) {
            values.forEach((value) => {
                if (value[key]) {
                    if (this.cacheMapSubject.has(value[key])) {
                        this.cacheMapSubject.get(value[key]).next(value);
                    }
                    else {
                        this.cacheMapSubject.set(value[key], new BehaviorSubject(value));
                    }
                }
            });
        }
        this.entityTypeGetDate = new Date();
    }
    /**
     * this function is responsible for managing the cache of a list of elements
     * @param values
     */
    setToCacheList(values) {
        if (this.cacheListSubject.getValue() == null) {
            this.cacheListSubject.next([]);
        }
        if (!Array.isArray(values)) {
            values = [values];
        }
        values.forEach((value) => {
            if (value['id'] != null) {
                const element = this.cacheListSubject
                    .getValue()
                    .find((el) => el['id'] === value['id']);
                if (element != null) {
                    Object.assign(element, value);
                    return;
                }
            }
            this.cacheListSubject.getValue().push(value);
        });
        this.cacheListSubject.next(this.cacheListSubject.getValue());
    }
    /**
     * Getter for cache map element by key
     *
     * @returns The elmement as an observable
     */
    getElementObservableByKey(key) {
        return this.cacheMapSubject.get(key);
    }
    /**
     * Getter for element value by key
     *
     * @returns Element current value
     */
    getElementByKey(key) {
        const subjectByKey = this.cacheMapSubject.get(key);
        return subjectByKey ? subjectByKey.getValue() : null;
    }
    /**
     * returns the observale of the list
     * @returns
     */
    getElementsListObservable() {
        return this.cacheListSubject.asObservable();
    }
    /**
     * returns the elements of the list
     * @returns
     */
    getElementsList() {
        return this.cacheListSubject.getValue();
    }
    /**
     * return if cache is valid
     * @returns boolean
     */
    isCacheValid() {
        if (!this.entityTypeGetDate ||
            new Date().getTime() - this.entityTypeGetDate.getTime() >=
                this.cacheTimeMs) {
            return false;
        }
        else {
            return true;
        }
    }
}
BaseCacheService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: BaseCacheService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
BaseCacheService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: BaseCacheService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: BaseCacheService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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