import { NgModule } from '@angular/core';
import { PrgLayoutsModule } from '../layouts/prg-layouts.module';
import { PrgCoreDynamicFormModule } from './components/dynamic-form/prg-core-dynamic-form.module';
import { PrgDynamicFormComponent } from './components/dynamic-form/prg-dynamic-form.component';
import { AbstractConfigurationItemsService } from './services/configuration-items/abstract-configuration-items.service';
import { ConfigurationItemsService } from './services/configuration-items/configuration-items.service';
import { MockConfigurationItemsService } from './services/configuration-items/configuration-items.service.mock';
import { PRG_CORE_CONFIG } from './services/prg-core-configuration/prg-core-configuration.service';
import * as i0 from "@angular/core";
/**
 * Lib Core (main) module, must provide the correct
 * implementation of its services, as well as the lib
 * configurations object
 */
export class PrgCoreModule {
    constructor(injector) {
        this.injector = injector;
        appInjector = this.injector;
    }
    static forRoot(prgCoreConfig) {
        coreConfig = prgCoreConfig;
        return {
            ngModule: PrgCoreModule,
            providers: [
                {
                    provide: PRG_CORE_CONFIG,
                    useValue: prgCoreConfig,
                },
                {
                    provide: AbstractConfigurationItemsService,
                    useClass: prgCoreConfig.useMockServices
                        ? MockConfigurationItemsService
                        : ConfigurationItemsService,
                },
            ],
        };
    }
}
PrgCoreModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCoreModule, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.NgModule });
PrgCoreModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgCoreModule, imports: [PrgLayoutsModule, PrgCoreDynamicFormModule], exports: [PrgLayoutsModule, PrgDynamicFormComponent] });
PrgCoreModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCoreModule, imports: [PrgLayoutsModule, PrgCoreDynamicFormModule, PrgLayoutsModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCoreModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [],
                    imports: [PrgLayoutsModule, PrgCoreDynamicFormModule],
                    exports: [PrgLayoutsModule, PrgDynamicFormComponent],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
/**
 * This variable allows you to access all the injectors on the entire app
 */
export let appInjector;
/**
 * Exports the PrgCoreConfig object
 */
export let coreConfig;
//# sourceMappingURL=data:application/json;base64,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