import { FilterExpressions, FilterOperations } from './filters';
import { Pagination } from './pagination';
/**
 * TableConfigs
 */
export class TableConfigs {
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init) {
        /**
         * defines the type of pagination we want and all the pagination settings
         */
        this.pagination = new Pagination();
        /**
         * default columns to show
         */
        this.defaultColumns = [];
        /**
         * columns in which the global filter is searched
         */
        this.globalFilterFields = [];
        /**
         * global filter oprarion out value
         */
        this.globalFilterOperation = FilterOperations.Contains;
        /**
         * global filter expression
         */
        this.globalFilterExpression = FilterExpressions.Or;
        /**
         * filter delay
         */
        this.filterDelay = 1000;
        /**
         * multi sorte meta
         */
        this.multiSortMeta = [];
        Object.assign(this, init);
    }
}
//# sourceMappingURL=data:application/json;base64,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