/**
 * Class Pagination
 */
export class Pagination {
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init) {
        /**
         * set the pagination type
         *
         * pages - the data is presented page by page
         *
         * infiniteLoading - the data is presented with scroll
         */
        this.type = PaginationType.pages;
        /**
         * number of items per page
         */
        this.totalRows = 3;
        /**
         * options for choosing items per page(by pages)
         */
        this.rowsPerPageOptions = [2, 3, 5, 10, 100];
        Object.assign(this, init);
    }
}
export var PaginationType;
(function (PaginationType) {
    // eslint-disable-next-line no-unused-vars
    PaginationType["infiniteLoading"] = "infiniteLoading";
    // eslint-disable-next-line no-unused-vars
    PaginationType["pages"] = "pages";
})(PaginationType || (PaginationType = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFnaW5hdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL1ByZ0ZyYW1ld29yay5GRS5Db3JlTGliL3NyYy9saWIvbW9kdWxlcy9jb3JlL21vZGVscy9wYWdpbmF0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOztHQUVHO0FBQ0gsTUFBTSxPQUFPLFVBQVU7SUFvQnJCOzs7OztPQUtHO0lBQ0gsWUFBWSxJQUEwQjtRQXpCdEM7Ozs7OztXQU1HO1FBQ0gsU0FBSSxHQUFtQixjQUFjLENBQUMsS0FBSyxDQUFDO1FBRTVDOztXQUVHO1FBQ0gsY0FBUyxHQUFXLENBQUMsQ0FBQztRQUV0Qjs7V0FFRztRQUNILHVCQUFrQixHQUFhLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBU2hELE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO0lBQzVCLENBQUM7Q0FDRjtBQUVELE1BQU0sQ0FBTixJQUFZLGNBS1g7QUFMRCxXQUFZLGNBQWM7SUFDeEIsMENBQTBDO0lBQzFDLHFEQUFtQyxDQUFBO0lBQ25DLDBDQUEwQztJQUMxQyxpQ0FBZSxDQUFBO0FBQ2pCLENBQUMsRUFMVyxjQUFjLEtBQWQsY0FBYyxRQUt6QiIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxyXG4gKiBDbGFzcyBQYWdpbmF0aW9uXHJcbiAqL1xyXG5leHBvcnQgY2xhc3MgUGFnaW5hdGlvbiB7XHJcbiAgLyoqXHJcbiAgICogc2V0IHRoZSBwYWdpbmF0aW9uIHR5cGVcclxuICAgKlxyXG4gICAqIHBhZ2VzIC0gdGhlIGRhdGEgaXMgcHJlc2VudGVkIHBhZ2UgYnkgcGFnZVxyXG4gICAqXHJcbiAgICogaW5maW5pdGVMb2FkaW5nIC0gdGhlIGRhdGEgaXMgcHJlc2VudGVkIHdpdGggc2Nyb2xsXHJcbiAgICovXHJcbiAgdHlwZTogUGFnaW5hdGlvblR5cGUgPSBQYWdpbmF0aW9uVHlwZS5wYWdlcztcclxuXHJcbiAgLyoqXHJcbiAgICogbnVtYmVyIG9mIGl0ZW1zIHBlciBwYWdlXHJcbiAgICovXHJcbiAgdG90YWxSb3dzOiBudW1iZXIgPSAzO1xyXG5cclxuICAvKipcclxuICAgKiBvcHRpb25zIGZvciBjaG9vc2luZyBpdGVtcyBwZXIgcGFnZShieSBwYWdlcylcclxuICAgKi9cclxuICByb3dzUGVyUGFnZU9wdGlvbnM6IG51bWJlcltdID0gWzIsIDMsIDUsIDEwLCAxMDBdO1xyXG5cclxuICAvKipcclxuICAgKiBDb25zdHJ1Y3RvclxyXG4gICAqIHRoaXMgY29uc3RydWN0b3IgcmVjZWl2ZXMgdGhlIGZpZWxkcyBzZW50IGJ5IHRoZSBhcHAsXHJcbiAgICogYW5kIGNyZWF0ZXMgYW4gb2JqZWN0IHdpdGggdGhlIGZpZWxkcyBzZW50IGFuZCB0aGUgdmFsdWVzIHBlciBkZWZhdWx0XHJcbiAgICogQHBhcmFtIGluaXRcclxuICAgKi9cclxuICBjb25zdHJ1Y3Rvcihpbml0PzogUGFydGlhbDxQYWdpbmF0aW9uPikge1xyXG4gICAgT2JqZWN0LmFzc2lnbih0aGlzLCBpbml0KTtcclxuICB9XHJcbn1cclxuXHJcbmV4cG9ydCBlbnVtIFBhZ2luYXRpb25UeXBlIHtcclxuICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tdW51c2VkLXZhcnNcclxuICBpbmZpbml0ZUxvYWRpbmcgPSAnaW5maW5pdGVMb2FkaW5nJyxcclxuICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tdW51c2VkLXZhcnNcclxuICBwYWdlcyA9ICdwYWdlcycsXHJcbn1cclxuIl19