import { FilterMatchMode } from 'primeng/api';
export var FilterExpressions;
(function (FilterExpressions) {
    FilterExpressions[FilterExpressions["And"] = 0] = "And";
    FilterExpressions[FilterExpressions["Or"] = 1] = "Or";
})(FilterExpressions || (FilterExpressions = {}));
/**
 * Map primeng expressions to out expressions
 */
export const MapPrimeNgExpressionsToFilterExpressions = new Map([
    ['and', FilterExpressions.And],
    ['or', FilterExpressions.Or],
]);
export var FilterOperations;
(function (FilterOperations) {
    FilterOperations[FilterOperations["EqualTo"] = 0] = "EqualTo";
    FilterOperations[FilterOperations["NotEqualTo"] = 1] = "NotEqualTo";
    FilterOperations[FilterOperations["GreaterThan"] = 2] = "GreaterThan";
    FilterOperations[FilterOperations["GreaterThanOrEqualTo"] = 3] = "GreaterThanOrEqualTo";
    FilterOperations[FilterOperations["LessThan"] = 4] = "LessThan";
    FilterOperations[FilterOperations["LessThanOrEqualTo"] = 5] = "LessThanOrEqualTo";
    FilterOperations[FilterOperations["Between"] = 6] = "Between";
    FilterOperations[FilterOperations["Contains"] = 7] = "Contains";
    FilterOperations[FilterOperations["DoesNotContain"] = 8] = "DoesNotContain";
    FilterOperations[FilterOperations["EndsWith"] = 9] = "EndsWith";
    FilterOperations[FilterOperations["In"] = 10] = "In";
    FilterOperations[FilterOperations["IsEmpty"] = 11] = "IsEmpty";
    FilterOperations[FilterOperations["IsNotEmpty"] = 12] = "IsNotEmpty";
    FilterOperations[FilterOperations["IsNotNull"] = 13] = "IsNotNull";
    FilterOperations[FilterOperations["IsNotNullNorWhiteSpace"] = 14] = "IsNotNullNorWhiteSpace";
    FilterOperations[FilterOperations["IsNull"] = 15] = "IsNull";
    FilterOperations[FilterOperations["IsNullOrWhiteSpace"] = 16] = "IsNullOrWhiteSpace";
    FilterOperations[FilterOperations["StartsWith"] = 17] = "StartsWith";
    FilterOperations[FilterOperations["NotIn"] = 18] = "NotIn";
})(FilterOperations || (FilterOperations = {}));
/**
 * Map primeng operations to out filter operations
 */
export const MapPrimeNgFilterOperationsToFilterOperations = new Map([
    [FilterMatchMode.STARTS_WITH, FilterOperations.StartsWith],
    [FilterMatchMode.CONTAINS, FilterOperations.Contains],
    [FilterMatchMode.NOT_CONTAINS, FilterOperations.DoesNotContain],
    [FilterMatchMode.ENDS_WITH, FilterOperations.EndsWith],
    [FilterMatchMode.EQUALS, FilterOperations.EqualTo],
    [FilterMatchMode.NOT_EQUALS, FilterOperations.NotEqualTo],
    [FilterMatchMode.IN, FilterOperations.In],
    [FilterMatchMode.LESS_THAN, FilterOperations.LessThan],
    [FilterMatchMode.LESS_THAN_OR_EQUAL_TO, FilterOperations.LessThanOrEqualTo],
    [FilterMatchMode.GREATER_THAN, FilterOperations.GreaterThan],
    [
        FilterMatchMode.GREATER_THAN_OR_EQUAL_TO,
        FilterOperations.GreaterThanOrEqualTo,
    ],
    [FilterMatchMode.BETWEEN, FilterOperations.Between],
    [FilterMatchMode.IS, FilterOperations.EqualTo],
    [FilterMatchMode.IS_NOT, FilterOperations.NotEqualTo],
    [FilterMatchMode.BEFORE, FilterOperations.LessThan],
    [FilterMatchMode.AFTER, FilterOperations.GreaterThan],
    [FilterMatchMode.DATE_IS, FilterOperations.EqualTo],
    [FilterMatchMode.DATE_IS_NOT, FilterOperations.NotEqualTo],
    [FilterMatchMode.DATE_BEFORE, FilterOperations.LessThan],
    [FilterMatchMode.DATE_AFTER, FilterOperations.GreaterThan],
]);
/**
 * enum to convert our datatypes to those supported by primeng
 */
export var PrimeNgTypeToOurTypes;
(function (PrimeNgTypeToOurTypes) {
    PrimeNgTypeToOurTypes["dataType.string"] = "text";
    PrimeNgTypeToOurTypes["dataType.number"] = "numeric";
    PrimeNgTypeToOurTypes["dataType.date"] = "date";
})(PrimeNgTypeToOurTypes || (PrimeNgTypeToOurTypes = {}));
/**
 * Filter operations in string format
 */
export var FilterOperationsString;
(function (FilterOperationsString) {
    FilterOperationsString[FilterOperationsString["EqualTo"] = 0] = "EqualTo";
    FilterOperationsString[FilterOperationsString["NotEqualTo"] = 1] = "NotEqualTo";
    FilterOperationsString[FilterOperationsString["GreaterThan"] = 2] = "GreaterThan";
    FilterOperationsString[FilterOperationsString["GreaterThanOrEqualTo"] = 3] = "GreaterThanOrEqualTo";
    FilterOperationsString[FilterOperationsString["LessThan"] = 4] = "LessThan";
    FilterOperationsString[FilterOperationsString["LessThanOrEqualTo"] = 5] = "LessThanOrEqualTo";
    FilterOperationsString[FilterOperationsString["Between"] = 6] = "Between";
    FilterOperationsString[FilterOperationsString["Contains"] = 7] = "Contains";
    FilterOperationsString[FilterOperationsString["DoesNotContain"] = 8] = "DoesNotContain";
    FilterOperationsString[FilterOperationsString["EndsWith"] = 9] = "EndsWith";
    FilterOperationsString[FilterOperationsString["In"] = 10] = "In";
    FilterOperationsString[FilterOperationsString["IsEmpty"] = 11] = "IsEmpty";
    FilterOperationsString[FilterOperationsString["IsNotEmpty"] = 12] = "IsNotEmpty";
    FilterOperationsString[FilterOperationsString["IsNotNull"] = 13] = "IsNotNull";
    FilterOperationsString[FilterOperationsString["IsNotNullNorWhiteSpace"] = 14] = "IsNotNullNorWhiteSpace";
    FilterOperationsString[FilterOperationsString["IsNull"] = 15] = "IsNull";
    FilterOperationsString[FilterOperationsString["IsNullOrWhiteSpace"] = 16] = "IsNullOrWhiteSpace";
    FilterOperationsString[FilterOperationsString["StartsWith"] = 17] = "StartsWith";
    FilterOperationsString[FilterOperationsString["NotIn"] = 18] = "NotIn";
})(FilterOperationsString || (FilterOperationsString = {}));
export var OrderTypes;
(function (OrderTypes) {
    OrderTypes[OrderTypes["Ascending"] = 0] = "Ascending";
    OrderTypes[OrderTypes["Descending"] = 1] = "Descending";
})(OrderTypes || (OrderTypes = {}));
/**
 * Map primeng sort order to ou orderTypes
 */
export const PrimeNgSortToOrderTypeMap = new Map([
    [-1, OrderTypes.Descending],
    [1, OrderTypes.Ascending],
]);
export class Filter {
    constructor() {
        this.filterOperation = FilterOperations.Contains;
        this.filterExpression = FilterExpressions.And;
    }
}
export class Order {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        Object.assign(this, init);
    }
}
export class FilterGroup {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        Object.assign(this, init);
    }
}
export class FilterCollection {
}
export class GenericFilter {
    constructor() {
        this.filterOperation = FilterOperations.Contains;
        this.filterExpression = FilterExpressions.And;
        this.isStartGroup = false;
        this.visible = true;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmlsdGVycy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL1ByZ0ZyYW1ld29yay5GRS5Db3JlTGliL3NyYy9saWIvbW9kdWxlcy9jb3JlL21vZGVscy9maWx0ZXJzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxlQUFlLEVBQUUsTUFBTSxhQUFhLENBQUM7QUFFOUMsTUFBTSxDQUFOLElBQVksaUJBR1g7QUFIRCxXQUFZLGlCQUFpQjtJQUMzQix1REFBRyxDQUFBO0lBQ0gscURBQUUsQ0FBQTtBQUNKLENBQUMsRUFIVyxpQkFBaUIsS0FBakIsaUJBQWlCLFFBRzVCO0FBRUQ7O0dBRUc7QUFDSCxNQUFNLENBQUMsTUFBTSx3Q0FBd0MsR0FHakQsSUFBSSxHQUFHLENBQTRCO0lBQ3JDLENBQUMsS0FBSyxFQUFFLGlCQUFpQixDQUFDLEdBQUcsQ0FBQztJQUM5QixDQUFDLElBQUksRUFBRSxpQkFBaUIsQ0FBQyxFQUFFLENBQUM7Q0FDN0IsQ0FBQyxDQUFDO0FBRUgsTUFBTSxDQUFOLElBQVksZ0JBb0JYO0FBcEJELFdBQVksZ0JBQWdCO0lBQzFCLDZEQUFPLENBQUE7SUFDUCxtRUFBVSxDQUFBO0lBQ1YscUVBQVcsQ0FBQTtJQUNYLHVGQUFvQixDQUFBO0lBQ3BCLCtEQUFRLENBQUE7SUFDUixpRkFBaUIsQ0FBQTtJQUNqQiw2REFBTyxDQUFBO0lBQ1AsK0RBQVEsQ0FBQTtJQUNSLDJFQUFjLENBQUE7SUFDZCwrREFBUSxDQUFBO0lBQ1Isb0RBQUUsQ0FBQTtJQUNGLDhEQUFPLENBQUE7SUFDUCxvRUFBVSxDQUFBO0lBQ1Ysa0VBQVMsQ0FBQTtJQUNULDRGQUFzQixDQUFBO0lBQ3RCLDREQUFNLENBQUE7SUFDTixvRkFBa0IsQ0FBQTtJQUNsQixvRUFBVSxDQUFBO0lBQ1YsMERBQUssQ0FBQTtBQUNQLENBQUMsRUFwQlcsZ0JBQWdCLEtBQWhCLGdCQUFnQixRQW9CM0I7QUFFRDs7R0FFRztBQUNILE1BQU0sQ0FBQyxNQUFNLDRDQUE0QyxHQUdyRCxJQUFJLEdBQUcsQ0FBb0M7SUFDN0MsQ0FBQyxlQUFlLENBQUMsV0FBVyxFQUFFLGdCQUFnQixDQUFDLFVBQVUsQ0FBQztJQUMxRCxDQUFDLGVBQWUsQ0FBQyxRQUFRLEVBQUUsZ0JBQWdCLENBQUMsUUFBUSxDQUFDO0lBQ3JELENBQUMsZUFBZSxDQUFDLFlBQVksRUFBRSxnQkFBZ0IsQ0FBQyxjQUFjLENBQUM7SUFDL0QsQ0FBQyxlQUFlLENBQUMsU0FBUyxFQUFFLGdCQUFnQixDQUFDLFFBQVEsQ0FBQztJQUN0RCxDQUFDLGVBQWUsQ0FBQyxNQUFNLEVBQUUsZ0JBQWdCLENBQUMsT0FBTyxDQUFDO0lBQ2xELENBQUMsZUFBZSxDQUFDLFVBQVUsRUFBRSxnQkFBZ0IsQ0FBQyxVQUFVLENBQUM7SUFDekQsQ0FBQyxlQUFlLENBQUMsRUFBRSxFQUFFLGdCQUFnQixDQUFDLEVBQUUsQ0FBQztJQUN6QyxDQUFDLGVBQWUsQ0FBQyxTQUFTLEVBQUUsZ0JBQWdCLENBQUMsUUFBUSxDQUFDO0lBQ3RELENBQUMsZUFBZSxDQUFDLHFCQUFxQixFQUFFLGdCQUFnQixDQUFDLGlCQUFpQixDQUFDO0lBQzNFLENBQUMsZUFBZSxDQUFDLFlBQVksRUFBRSxnQkFBZ0IsQ0FBQyxXQUFXLENBQUM7SUFDNUQ7UUFDRSxlQUFlLENBQUMsd0JBQXdCO1FBQ3hDLGdCQUFnQixDQUFDLG9CQUFvQjtLQUN0QztJQUNELENBQUMsZUFBZSxDQUFDLE9BQU8sRUFBRSxnQkFBZ0IsQ0FBQyxPQUFPLENBQUM7SUFDbkQsQ0FBQyxlQUFlLENBQUMsRUFBRSxFQUFFLGdCQUFnQixDQUFDLE9BQU8sQ0FBQztJQUM5QyxDQUFDLGVBQWUsQ0FBQyxNQUFNLEVBQUUsZ0JBQWdCLENBQUMsVUFBVSxDQUFDO0lBQ3JELENBQUMsZUFBZSxDQUFDLE1BQU0sRUFBRSxnQkFBZ0IsQ0FBQyxRQUFRLENBQUM7SUFDbkQsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLGdCQUFnQixDQUFDLFdBQVcsQ0FBQztJQUNyRCxDQUFDLGVBQWUsQ0FBQyxPQUFPLEVBQUUsZ0JBQWdCLENBQUMsT0FBTyxDQUFDO0lBQ25ELENBQUMsZUFBZSxDQUFDLFdBQVcsRUFBRSxnQkFBZ0IsQ0FBQyxVQUFVLENBQUM7SUFDMUQsQ0FBQyxlQUFlLENBQUMsV0FBVyxFQUFFLGdCQUFnQixDQUFDLFFBQVEsQ0FBQztJQUN4RCxDQUFDLGVBQWUsQ0FBQyxVQUFVLEVBQUUsZ0JBQWdCLENBQUMsV0FBVyxDQUFDO0NBQzNELENBQUMsQ0FBQztBQUVIOztHQUVHO0FBQ0gsTUFBTSxDQUFOLElBQVkscUJBSVg7QUFKRCxXQUFZLHFCQUFxQjtJQUMvQixpREFBMEIsQ0FBQTtJQUMxQixvREFBNkIsQ0FBQTtJQUM3QiwrQ0FBd0IsQ0FBQTtBQUMxQixDQUFDLEVBSlcscUJBQXFCLEtBQXJCLHFCQUFxQixRQUloQztBQUVEOztHQUVHO0FBQ0gsTUFBTSxDQUFOLElBQVksc0JBb0JYO0FBcEJELFdBQVksc0JBQXNCO0lBQ2hDLHlFQUFvQyxDQUFBO0lBQ3BDLCtFQUEwQyxDQUFBO0lBQzFDLGlGQUE0QyxDQUFBO0lBQzVDLG1HQUE4RCxDQUFBO0lBQzlELDJFQUFzQyxDQUFBO0lBQ3RDLDZGQUF3RCxDQUFBO0lBQ3hELHlFQUFvQyxDQUFBO0lBQ3BDLDJFQUFzQyxDQUFBO0lBQ3RDLHVGQUFrRCxDQUFBO0lBQ2xELDJFQUFzQyxDQUFBO0lBQ3RDLGdFQUEwQixDQUFBO0lBQzFCLDBFQUFvQyxDQUFBO0lBQ3BDLGdGQUEwQyxDQUFBO0lBQzFDLDhFQUF3QyxDQUFBO0lBQ3hDLHdHQUFrRSxDQUFBO0lBQ2xFLHdFQUFrQyxDQUFBO0lBQ2xDLGdHQUEwRCxDQUFBO0lBQzFELGdGQUEwQyxDQUFBO0lBQzFDLHNFQUFnQyxDQUFBO0FBQ2xDLENBQUMsRUFwQlcsc0JBQXNCLEtBQXRCLHNCQUFzQixRQW9CakM7QUFFRCxNQUFNLENBQU4sSUFBWSxVQUdYO0FBSEQsV0FBWSxVQUFVO0lBQ3BCLHFEQUFTLENBQUE7SUFDVCx1REFBVSxDQUFBO0FBQ1osQ0FBQyxFQUhXLFVBQVUsS0FBVixVQUFVLFFBR3JCO0FBRUQ7O0dBRUc7QUFDSCxNQUFNLENBQUMsTUFBTSx5QkFBeUIsR0FBNEIsSUFBSSxHQUFHLENBR3ZFO0lBQ0EsQ0FBQyxDQUFDLENBQUMsRUFBRSxVQUFVLENBQUMsVUFBVSxDQUFDO0lBQzNCLENBQUMsQ0FBQyxFQUFFLFVBQVUsQ0FBQyxTQUFTLENBQUM7Q0FDMUIsQ0FBQyxDQUFDO0FBRUgsTUFBTSxPQUFPLE1BQU07SUFBbkI7UUFJUyxvQkFBZSxHQUFxQixnQkFBZ0IsQ0FBQyxRQUFRLENBQUM7UUFDOUQscUJBQWdCLEdBQXNCLGlCQUFpQixDQUFDLEdBQUcsQ0FBQztJQUVyRSxDQUFDO0NBQUE7QUFDRCxNQUFNLE9BQU8sS0FBSztJQUloQjs7O09BR0c7SUFDSCxZQUFZLElBQXFCO1FBQy9CLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO0lBQzVCLENBQUM7Q0FDRjtBQUVELE1BQU0sT0FBTyxXQUFXO0lBTXRCOzs7T0FHRztJQUNILFlBQVksSUFBMkI7UUFDckMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7SUFDNUIsQ0FBQztDQUNGO0FBQ0QsTUFBTSxPQUFPLGdCQUFnQjtDQUc1QjtBQUNELE1BQU0sT0FBTyxhQUFhO0lBQTFCO1FBU1Msb0JBQWUsR0FBcUIsZ0JBQWdCLENBQUMsUUFBUSxDQUFDO1FBQzlELHFCQUFnQixHQUFzQixpQkFBaUIsQ0FBQyxHQUFHLENBQUM7UUFFNUQsaUJBQVksR0FBRyxLQUFLLENBQUM7UUFDckIsWUFBTyxHQUFJLElBQUksQ0FBQztJQUN6QixDQUFDO0NBQUEiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBGaWx0ZXJNYXRjaE1vZGUgfSBmcm9tICdwcmltZW5nL2FwaSc7XHJcblxyXG5leHBvcnQgZW51bSBGaWx0ZXJFeHByZXNzaW9ucyB7XHJcbiAgQW5kLFxyXG4gIE9yLFxyXG59XHJcblxyXG4vKipcclxuICogTWFwIHByaW1lbmcgZXhwcmVzc2lvbnMgdG8gb3V0IGV4cHJlc3Npb25zXHJcbiAqL1xyXG5leHBvcnQgY29uc3QgTWFwUHJpbWVOZ0V4cHJlc3Npb25zVG9GaWx0ZXJFeHByZXNzaW9uczogTWFwPFxyXG4gIHN0cmluZyxcclxuICBGaWx0ZXJFeHByZXNzaW9uc1xyXG4+ID0gbmV3IE1hcDxzdHJpbmcsIEZpbHRlckV4cHJlc3Npb25zPihbXHJcbiAgWydhbmQnLCBGaWx0ZXJFeHByZXNzaW9ucy5BbmRdLFxyXG4gIFsnb3InLCBGaWx0ZXJFeHByZXNzaW9ucy5Pcl0sXHJcbl0pO1xyXG5cclxuZXhwb3J0IGVudW0gRmlsdGVyT3BlcmF0aW9ucyB7XHJcbiAgRXF1YWxUbyxcclxuICBOb3RFcXVhbFRvLFxyXG4gIEdyZWF0ZXJUaGFuLFxyXG4gIEdyZWF0ZXJUaGFuT3JFcXVhbFRvLFxyXG4gIExlc3NUaGFuLFxyXG4gIExlc3NUaGFuT3JFcXVhbFRvLFxyXG4gIEJldHdlZW4sXHJcbiAgQ29udGFpbnMsXHJcbiAgRG9lc05vdENvbnRhaW4sXHJcbiAgRW5kc1dpdGgsXHJcbiAgSW4sXHJcbiAgSXNFbXB0eSxcclxuICBJc05vdEVtcHR5LFxyXG4gIElzTm90TnVsbCxcclxuICBJc05vdE51bGxOb3JXaGl0ZVNwYWNlLFxyXG4gIElzTnVsbCxcclxuICBJc051bGxPcldoaXRlU3BhY2UsXHJcbiAgU3RhcnRzV2l0aCxcclxuICBOb3RJbixcclxufVxyXG5cclxuLyoqXHJcbiAqIE1hcCBwcmltZW5nIG9wZXJhdGlvbnMgdG8gb3V0IGZpbHRlciBvcGVyYXRpb25zXHJcbiAqL1xyXG5leHBvcnQgY29uc3QgTWFwUHJpbWVOZ0ZpbHRlck9wZXJhdGlvbnNUb0ZpbHRlck9wZXJhdGlvbnM6IE1hcDxcclxuICBGaWx0ZXJNYXRjaE1vZGUsXHJcbiAgRmlsdGVyT3BlcmF0aW9uc1xyXG4+ID0gbmV3IE1hcDxGaWx0ZXJNYXRjaE1vZGUsIEZpbHRlck9wZXJhdGlvbnM+KFtcclxuICBbRmlsdGVyTWF0Y2hNb2RlLlNUQVJUU19XSVRILCBGaWx0ZXJPcGVyYXRpb25zLlN0YXJ0c1dpdGhdLFxyXG4gIFtGaWx0ZXJNYXRjaE1vZGUuQ09OVEFJTlMsIEZpbHRlck9wZXJhdGlvbnMuQ29udGFpbnNdLFxyXG4gIFtGaWx0ZXJNYXRjaE1vZGUuTk9UX0NPTlRBSU5TLCBGaWx0ZXJPcGVyYXRpb25zLkRvZXNOb3RDb250YWluXSxcclxuICBbRmlsdGVyTWF0Y2hNb2RlLkVORFNfV0lUSCwgRmlsdGVyT3BlcmF0aW9ucy5FbmRzV2l0aF0sXHJcbiAgW0ZpbHRlck1hdGNoTW9kZS5FUVVBTFMsIEZpbHRlck9wZXJhdGlvbnMuRXF1YWxUb10sXHJcbiAgW0ZpbHRlck1hdGNoTW9kZS5OT1RfRVFVQUxTLCBGaWx0ZXJPcGVyYXRpb25zLk5vdEVxdWFsVG9dLFxyXG4gIFtGaWx0ZXJNYXRjaE1vZGUuSU4sIEZpbHRlck9wZXJhdGlvbnMuSW5dLFxyXG4gIFtGaWx0ZXJNYXRjaE1vZGUuTEVTU19USEFOLCBGaWx0ZXJPcGVyYXRpb25zLkxlc3NUaGFuXSxcclxuICBbRmlsdGVyTWF0Y2hNb2RlLkxFU1NfVEhBTl9PUl9FUVVBTF9UTywgRmlsdGVyT3BlcmF0aW9ucy5MZXNzVGhhbk9yRXF1YWxUb10sXHJcbiAgW0ZpbHRlck1hdGNoTW9kZS5HUkVBVEVSX1RIQU4sIEZpbHRlck9wZXJhdGlvbnMuR3JlYXRlclRoYW5dLFxyXG4gIFtcclxuICAgIEZpbHRlck1hdGNoTW9kZS5HUkVBVEVSX1RIQU5fT1JfRVFVQUxfVE8sXHJcbiAgICBGaWx0ZXJPcGVyYXRpb25zLkdyZWF0ZXJUaGFuT3JFcXVhbFRvLFxyXG4gIF0sXHJcbiAgW0ZpbHRlck1hdGNoTW9kZS5CRVRXRUVOLCBGaWx0ZXJPcGVyYXRpb25zLkJldHdlZW5dLFxyXG4gIFtGaWx0ZXJNYXRjaE1vZGUuSVMsIEZpbHRlck9wZXJhdGlvbnMuRXF1YWxUb10sXHJcbiAgW0ZpbHRlck1hdGNoTW9kZS5JU19OT1QsIEZpbHRlck9wZXJhdGlvbnMuTm90RXF1YWxUb10sXHJcbiAgW0ZpbHRlck1hdGNoTW9kZS5CRUZPUkUsIEZpbHRlck9wZXJhdGlvbnMuTGVzc1RoYW5dLFxyXG4gIFtGaWx0ZXJNYXRjaE1vZGUuQUZURVIsIEZpbHRlck9wZXJhdGlvbnMuR3JlYXRlclRoYW5dLFxyXG4gIFtGaWx0ZXJNYXRjaE1vZGUuREFURV9JUywgRmlsdGVyT3BlcmF0aW9ucy5FcXVhbFRvXSxcclxuICBbRmlsdGVyTWF0Y2hNb2RlLkRBVEVfSVNfTk9ULCBGaWx0ZXJPcGVyYXRpb25zLk5vdEVxdWFsVG9dLFxyXG4gIFtGaWx0ZXJNYXRjaE1vZGUuREFURV9CRUZPUkUsIEZpbHRlck9wZXJhdGlvbnMuTGVzc1RoYW5dLFxyXG4gIFtGaWx0ZXJNYXRjaE1vZGUuREFURV9BRlRFUiwgRmlsdGVyT3BlcmF0aW9ucy5HcmVhdGVyVGhhbl0sXHJcbl0pO1xyXG5cclxuLyoqXHJcbiAqIGVudW0gdG8gY29udmVydCBvdXIgZGF0YXR5cGVzIHRvIHRob3NlIHN1cHBvcnRlZCBieSBwcmltZW5nXHJcbiAqL1xyXG5leHBvcnQgZW51bSBQcmltZU5nVHlwZVRvT3VyVHlwZXMge1xyXG4gICdkYXRhVHlwZS5zdHJpbmcnID0gJ3RleHQnLFxyXG4gICdkYXRhVHlwZS5udW1iZXInID0gJ251bWVyaWMnLFxyXG4gICdkYXRhVHlwZS5kYXRlJyA9ICdkYXRlJyxcclxufVxyXG5cclxuLyoqXHJcbiAqIEZpbHRlciBvcGVyYXRpb25zIGluIHN0cmluZyBmb3JtYXRcclxuICovXHJcbmV4cG9ydCBlbnVtIEZpbHRlck9wZXJhdGlvbnNTdHJpbmcge1xyXG4gICdFcXVhbFRvJyA9IEZpbHRlck9wZXJhdGlvbnMuRXF1YWxUbyxcclxuICAnTm90RXF1YWxUbycgPSBGaWx0ZXJPcGVyYXRpb25zLk5vdEVxdWFsVG8sXHJcbiAgJ0dyZWF0ZXJUaGFuJyA9IEZpbHRlck9wZXJhdGlvbnMuR3JlYXRlclRoYW4sXHJcbiAgJ0dyZWF0ZXJUaGFuT3JFcXVhbFRvJyA9IEZpbHRlck9wZXJhdGlvbnMuR3JlYXRlclRoYW5PckVxdWFsVG8sXHJcbiAgJ0xlc3NUaGFuJyA9IEZpbHRlck9wZXJhdGlvbnMuTGVzc1RoYW4sXHJcbiAgJ0xlc3NUaGFuT3JFcXVhbFRvJyA9IEZpbHRlck9wZXJhdGlvbnMuTGVzc1RoYW5PckVxdWFsVG8sXHJcbiAgJ0JldHdlZW4nID0gRmlsdGVyT3BlcmF0aW9ucy5CZXR3ZWVuLFxyXG4gICdDb250YWlucycgPSBGaWx0ZXJPcGVyYXRpb25zLkNvbnRhaW5zLFxyXG4gICdEb2VzTm90Q29udGFpbicgPSBGaWx0ZXJPcGVyYXRpb25zLkRvZXNOb3RDb250YWluLFxyXG4gICdFbmRzV2l0aCcgPSBGaWx0ZXJPcGVyYXRpb25zLkVuZHNXaXRoLFxyXG4gICdJbicgPSBGaWx0ZXJPcGVyYXRpb25zLkluLFxyXG4gICdJc0VtcHR5JyA9IEZpbHRlck9wZXJhdGlvbnMuSXNFbXB0eSxcclxuICAnSXNOb3RFbXB0eScgPSBGaWx0ZXJPcGVyYXRpb25zLklzTm90RW1wdHksXHJcbiAgJ0lzTm90TnVsbCcgPSBGaWx0ZXJPcGVyYXRpb25zLklzTm90TnVsbCxcclxuICAnSXNOb3ROdWxsTm9yV2hpdGVTcGFjZScgPSBGaWx0ZXJPcGVyYXRpb25zLklzTm90TnVsbE5vcldoaXRlU3BhY2UsXHJcbiAgJ0lzTnVsbCcgPSBGaWx0ZXJPcGVyYXRpb25zLklzTnVsbCxcclxuICAnSXNOdWxsT3JXaGl0ZVNwYWNlJyA9IEZpbHRlck9wZXJhdGlvbnMuSXNOdWxsT3JXaGl0ZVNwYWNlLFxyXG4gICdTdGFydHNXaXRoJyA9IEZpbHRlck9wZXJhdGlvbnMuU3RhcnRzV2l0aCxcclxuICAnTm90SW4nID0gRmlsdGVyT3BlcmF0aW9ucy5Ob3RJbixcclxufVxyXG5cclxuZXhwb3J0IGVudW0gT3JkZXJUeXBlcyB7XHJcbiAgQXNjZW5kaW5nLFxyXG4gIERlc2NlbmRpbmcsXHJcbn1cclxuXHJcbi8qKlxyXG4gKiBNYXAgcHJpbWVuZyBzb3J0IG9yZGVyIHRvIG91IG9yZGVyVHlwZXNcclxuICovXHJcbmV4cG9ydCBjb25zdCBQcmltZU5nU29ydFRvT3JkZXJUeXBlTWFwOiBNYXA8bnVtYmVyLCBPcmRlclR5cGVzPiA9IG5ldyBNYXA8XHJcbiAgbnVtYmVyLFxyXG4gIE9yZGVyVHlwZXNcclxuPihbXHJcbiAgWy0xLCBPcmRlclR5cGVzLkRlc2NlbmRpbmddLFxyXG4gIFsxLCBPcmRlclR5cGVzLkFzY2VuZGluZ10sXHJcbl0pO1xyXG5cclxuZXhwb3J0IGNsYXNzIEZpbHRlciB7XHJcbiAgcHVibGljIHByb3BlcnR5TmFtZTogc3RyaW5nO1xyXG4gIHB1YmxpYyB2YWx1ZTogYW55O1xyXG4gIHB1YmxpYyB2YWx1ZTI6IHN0cmluZztcclxuICBwdWJsaWMgZmlsdGVyT3BlcmF0aW9uOiBGaWx0ZXJPcGVyYXRpb25zID0gRmlsdGVyT3BlcmF0aW9ucy5Db250YWlucztcclxuICBwdWJsaWMgZmlsdGVyRXhwcmVzc2lvbjogRmlsdGVyRXhwcmVzc2lvbnMgPSBGaWx0ZXJFeHByZXNzaW9ucy5BbmQ7XHJcbiAgcHVibGljIHN0YXJ0R3JvdXA6IGJvb2xlYW47XHJcbn1cclxuZXhwb3J0IGNsYXNzIE9yZGVyIHtcclxuICBwdWJsaWMgcHJvcGVydHlOYW1lOiBzdHJpbmc7XHJcbiAgcHVibGljIG9yZGVyVHlwZTogT3JkZXJUeXBlcztcclxuXHJcbiAgLyoqXHJcbiAgICogY29uc3RydWN0b3JcclxuICAgKiBAcGFyYW0gaW5pdFxyXG4gICAqL1xyXG4gIGNvbnN0cnVjdG9yKGluaXQ/OiBQYXJ0aWFsPE9yZGVyPikge1xyXG4gICAgT2JqZWN0LmFzc2lnbih0aGlzLCBpbml0KTtcclxuICB9XHJcbn1cclxuXHJcbmV4cG9ydCBjbGFzcyBGaWx0ZXJHcm91cCB7XHJcbiAgcHVibGljIGZpbHRlckNvbGxlY3Rpb25zOiBGaWx0ZXJbXTtcclxuICBwdWJsaWMgb3JkZXJDb2xsZWN0aW9uOiBPcmRlcltdO1xyXG4gIHB1YmxpYyBwYWdlU2l6ZTogbnVtYmVyIHwgdW5kZWZpbmVkO1xyXG4gIHB1YmxpYyBwYWdlSW5kZXg6IG51bWJlciB8IHVuZGVmaW5lZDtcclxuXHJcbiAgLyoqXHJcbiAgICogY29uc3RydWN0b3JcclxuICAgKiBAcGFyYW0gaW5pdFxyXG4gICAqL1xyXG4gIGNvbnN0cnVjdG9yKGluaXQ/OiBQYXJ0aWFsPEZpbHRlckdyb3VwPikge1xyXG4gICAgT2JqZWN0LmFzc2lnbih0aGlzLCBpbml0KTtcclxuICB9XHJcbn1cclxuZXhwb3J0IGNsYXNzIEZpbHRlckNvbGxlY3Rpb24ge1xyXG4gIHB1YmxpYyBvcmRlcjogbnVtYmVyO1xyXG4gIHB1YmxpYyBmaWx0ZXI6IEZpbHRlcltdO1xyXG59XHJcbmV4cG9ydCBjbGFzcyBHZW5lcmljRmlsdGVyIHtcclxuICBwdWJsaWMgb3JkZXI6IG51bWJlcjtcclxuICBwdWJsaWMgcHJvcGVydHlOYW1lOiBzdHJpbmc7XHJcbiAgcHVibGljIHBsYWNlaG9sZGVyOiBzdHJpbmc7XHJcbiAgcHVibGljIHByb3BlcnR5VHlwZTogc3RyaW5nO1xyXG4gIHB1YmxpYyBwcm9wZXJ0eVRyYW5zbGF0aW9uPzogc3RyaW5nO1xyXG4gIHB1YmxpYyBkZWZhdWx0VmFsdWU/OiBhbnk7XHJcbiAgcHVibGljIHBvc3NpYmxlVmFsdWVzPzogYW55W107XHJcbiAgcHVibGljIHByb3BlcnR5VmFsdWU/OiBhbnk7XHJcbiAgcHVibGljIGZpbHRlck9wZXJhdGlvbjogRmlsdGVyT3BlcmF0aW9ucyA9IEZpbHRlck9wZXJhdGlvbnMuQ29udGFpbnM7XHJcbiAgcHVibGljIGZpbHRlckV4cHJlc3Npb246IEZpbHRlckV4cHJlc3Npb25zID0gRmlsdGVyRXhwcmVzc2lvbnMuQW5kO1xyXG4gIHB1YmxpYyBsb29rdXBUYWJsZU5hbWU/OiBzdHJpbmc7XHJcbiAgcHVibGljIGlzU3RhcnRHcm91cCA9IGZhbHNlO1xyXG4gIHB1YmxpYyB2aXNpYmxlPyA9IHRydWU7XHJcbn1cclxuIl19