// GCR: por cada módulo criar uma pasta mock onde tem uma bd desse módulo apenas, ou seja,
// cada módulo ter a sua mock database para podermos, no futuro,
// separar os modulos em packages sem alterar código
// GCR: todos os ficheiros mock deve estar na pasta mock com a mesma estrutura dos reais
/**
 * MockDatabase object to be used while developing
 * <br /> and/or testing the front-end
 */
export const MockDatabase = {
    /*  EntityTypes: [
      {
        id: '1',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'Customer',
        createdBy: null,
        modifiedBy: null,
        label: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        guiSettings: '',
        group: 'System',
        properties: null /!*definidas inicialmente e nunca mais alteradas*!/,
        attributes: null /!*são atributos que podem adicionados/editados*!/,
        operations: [
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            label:null,
            name: 'view',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'create',
            createdBy: null,
            label:null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
  
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'update',
            createdBy: null,
            modifiedBy: null,
            label:null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'delete',
            createdBy: null,
            label:null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
        ],
      },
      {
        id: '2',
        label: null,
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'User',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        guiSettings: '',
        group: 'System',
        properties: null,
        attributes: null,
        operations: [
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'view',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'create',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'update',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
        ],
      },
      {
        id: '3',
        label: null,
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'Product',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        guiSettings: '',
        group: 'Store',
        properties: null,
        attributes: null,
        operations: [
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'view',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'create',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
        ],
      },
      {
        id: '4',
        label: null,
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'Orders',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        guiSettings: '',
        group: 'Store',
        properties: null,
        attributes: null,
        operations: [
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'create',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'viewUserOrder',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'updateUserOrder',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
        ],
      },
    ],
  
    EntityTypesOperations: [
      {
        id: '1',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'getCustomer',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '3',
        guiSettings: 'string',
        override: false,
        imports: null,
        sourceCode: 'string',
        httpVerb: HttpVerb.Get,
        order: 0,
      },
    ],
    EntityTypesProperties: [
      {
        id: '1',
        label: null,
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'customer name',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '1',
        guiSettings: 'customer name',
        dataTypeId: 'dataType.string',
        order: 1,
        reference: 'customer name',
      },
      {
        id: '2',
        universalStateId: '1',
        transactionId: null,
        label: null,
        operationId: null,
        name: 'customer Id',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '1',
        guiSettings: 'customer Id',
        dataTypeId: 'dataType.number',
        order: 1,
        reference: 'customer Id',
      },
      {
        id: '3',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'date of birth',
        createdBy: null,
        modifiedBy: null,
        label: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '1',
        guiSettings: 'date of birth',
        dataTypeId: 'dataType.date',
        order: 1,
        reference: 'date of birth',
      },
  
      {
        id: '4',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'user name',
        label: null,
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '2',
        guiSettings: 'user name',
        dataTypeId: 'dataType.string',
        order: 1,
        reference: 'user name',
      },
      {
        id: '5',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'user Id',
        label: null,
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '2',
        guiSettings: 'user Id',
        dataTypeId: 'dataType.number',
        order: 1,
        reference: 'user Id',
      },
      {
        id: '6',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'RegisterDate',
        createdBy: null,
        modifiedBy: null,
        label: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '2',
        guiSettings: 'RegisterDate',
        dataTypeId: 'dataType.date',
        order: 1,
        reference: 'RegisterDate',
      },
    ],
    EntityTypesAttributes: [
      {
        id: '1',
        universalStateId: '1',
        transactionId: null,
        label: null,
        operationId: null,
        name: 'customer address',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '1',
        guiSettings: 'customer address',
        dataTypeId: 'dataType.string',
        order: 1,
        reference: 'customer address',
      },
      {
        id: '2',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        label: null,
        name: 'VAT',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '1',
        guiSettings: 'VAT',
        dataTypeId: 'dataType.number',
        order: 1,
        reference: 'VAT',
      },
      {
        id: '3',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'city',
        createdBy: null,
        label: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '1',
        guiSettings: 'city',
        dataTypeId: 'dataType.string',
        order: 1,
        reference: 'city',
      },
      {
        id: '4',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        label: null,
        name: 'user address',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '2',
        guiSettings: 'user address',
        dataTypeId: 'dataType.string',
        order: 1,
        reference: 'user address',
      },
      {
        id: '5',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        label: null,
        name: 'user date of birth',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '2',
        guiSettings: 'user date of birth',
        dataTypeId: 'dataType.date',
        order: 1,
        reference: 'user date of birth',
      },
      {
        id: '6',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'email',
        createdBy: null,
        label: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '2',
        guiSettings: 'email',
        dataTypeId: 'dataType.string',
        order: 1,
        reference: 'email',
      },
    ],*/
    /* TODO: MAP IDENTITY CONFIG TO CONFIGURATION ITEMS
      "Identity": {
        "DefaultEnabledUser": true, // user will be enabled on register
        "AllowSelfRegister": true,
        "LockoutEnabled": true,
        "CreateWorkspaceOnUserRegister": true,
        "SignIn": {
          "RequireEnabledUser": false,
          "RequireConfirmedAdmin": false,
          "RequireConfirmedEmail": true,
          "RequireConfirmedPhoneNumber": false
        },
        "Lockout": {
          "LockoutTimeSpan": "1.00:00:00" //lock out for 1 day
        },
        "Password": {
          "RequireDigit": true,
          "RequiredLength": 7,
          "RequireLowercase": true,
          "RequiredUniqueChars": 1,
          "RequireUppercase": true,
          "RequireNonAlphanumeric": true
        },
        "Callbacks": {
          "BaseUrl": "http://localhost:8100",
          "LoginUrl": "/auth/login",
          "ConfirmedAccountUrl": "/auth/confirm",
          "ResetPasswordUrl": "/auth/reset",
          "UnsubscribeUrl": "/auth/unsubscribe"
        },
        "Token": {
          "Audience": "Prg.Framework.Api.Audience",
          "Issuer": "Prg.Framework.Api.Issuer",
          "Seconds": 86400, // 24 hours
          "RefreshDuration": 24 // 24 hours
        }
      }
    */
    ConfigurationItems: [],
};
//# sourceMappingURL=data:application/json;base64,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