import { BaseEntity } from './base-entity.model';
/**
 * ConfigurationItem class that defines generic configurations
 */
export class ConfigurationItem extends BaseEntity {
    /**
     * Constructor
     * @param {Partial<ConfigurationItem>} init
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/*

import { BaseEntity } from "./base-entity.model";

/!**
 * ConfigurationItem class that defines generic configurations
 *!/
export class ConfigurationItem extends BaseEntity {
  /!**
   * Path that leads to the item (excluding itself)
   * <br />e.g. "Identity\SignIn"
   * <br />the node name is on the name property from BaseEntity
   *!/
  path: string;
  /!**
   * Item value
   *!/
  value: string;
  /!**
   * Item value type
   *!/
  type: string;
  /!**
   * If type is lookup table, item
   * <br /> lookup table name
   *!/
  lookupTableName: string;
  /!**
   * MaxValue validation property
   * <br /> for numeric types
   *!/
  maxValue: number;
  /!**
   * MinValue validation property
   * <br /> for numeric types
   *!/
  minValue: number;
  /!**
   * MaxLength validation property
   * <br /> for string type
   *!/
  maxLength: number;
  /!**
   * MinLength validation property
   * <br /> for string type
   *!/
  minLength: number;
  /!**
   * Item value is required
   *!/
  required: boolean;
  /!**
   * Value validation property by regex
   *!/
  pattern: string;
  /!**
   * Item is system
   *!/
  isSystem: boolean;
}*/
//# sourceMappingURL=data:application/json;base64,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