import { Component, EventEmitter, Inject, Input, Output, } from '@angular/core';
import { PRG_ENTITY_TYPES_CONFIG } from '../../../entity-types/services/entity-types-configuration/prg-entity-types-configuration.service';
import { ViewMode } from '../../models/constants/view-mode.enum';
import { DynamicFormActionOutput, DynamicFormFieldChangeOutput, } from './models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "../../../core/services/utility/objects-utility.service";
import * as i2 from "../../../core/services/utility/array-utility.service";
import * as i3 from "../../services/form-group/form-group.service";
import * as i4 from "../../services/utility/utility.service";
import * as i5 from "@angular/common";
import * as i6 from "primeng/tabmenu";
import * as i7 from "primeng/toolbar";
import * as i8 from "@angular/forms";
import * as i9 from "./dynamic-form-fields/prg-dynamic-form-field.component";
import * as i10 from "./dynamic-form-actions/prg-dynamic-form-action.component";
/**
 * Dynamic form component
 */
export class PrgDynamicFormComponent {
    /**
     * constructor
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {FormGroupService} formGroupService
     * @param {UtilityService} utilityService
     * @param {PrgEntityTypesConfig} entityConfigs
     */
    constructor(objectsUtilityService, arrayUtilityService, formGroupService, utilityService, entityConfigs) {
        this.objectsUtilityService = objectsUtilityService;
        this.arrayUtilityService = arrayUtilityService;
        this.formGroupService = formGroupService;
        this.utilityService = utilityService;
        this.entityConfigs = entityConfigs;
        /**
         * Tab menu items
         * @type {PrgMenuItem[]}
         */
        this.tabMenuItemsDynamicForm = [];
        /**
         * Context of class where dynamic form component is used
         * @type {any}
         */
        this.context = null;
        /**
         * fields aux
         */
        this._fields = [];
        /**
         * fields aux
         */
        this._originalFields = [];
        /**
         * actions aux
         */
        this._actions = [];
        /**
         * action output
         */
        this.actionOutput = new EventEmitter();
        /**
         * Field output onChange
         * @type {EventEmitter<DynamicFormFieldChangeOutput>}
         */
        this.fieldChangeOutput = new EventEmitter();
        /**
         * left actions
         */
        this.leftActions = [];
        /**
         * middle actions
         */
        this.middleActions = [];
        /**
         * right actions
         */
        this.rightActions = [];
    }
    /**
     *array with the fields
     */
    set fields(fields) {
        this._fields = this.arrayUtilityService.clone(fields);
        this._originalFields = this.arrayUtilityService.clone(fields);
        this.form = this.formGroupService.toFormGroup(fields);
    }
    /**
     * get fields
     */
    get fields() {
        return this._fields;
    }
    /**
     *array with the actions
     */
    set actions(actions) {
        this._actions = actions;
        this.createActionsArray();
    }
    /**
     * get actions
     */
    get actions() {
        return this._actions;
    }
    /**
     * input entity
     */
    set entity(entity) {
        if (entity) {
            this._entity = this.objectsUtilityService.cloneObject(entity);
            this._entityTemp = this.objectsUtilityService.cloneObject(entity);
            this.mapValueToFields(entity);
        }
    }
    /**
     * get entity
     */
    get entity() {
        return this._entity;
    }
    /**
     * getter entity temp
     * @returns {any}
     */
    get entityTemp() {
        return this._entityTemp;
    }
    /**
     * input view mode
     */
    set viewMode(viewMode) {
        this._viewMode = viewMode;
        this.fields.forEach((field) => {
            field.readonly = viewMode !== ViewMode.Edit;
            field.disabled = viewMode !== ViewMode.Edit;
        });
        this.fields = this.arrayUtilityService.clone(this.fields);
    }
    /**
     * get View Mode
     */
    get viewMode() {
        return this._viewMode;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        if (this.formGroupType === 'tab') {
            this.createTabMenu();
        }
    }
    /**
     * this function divides the actions by their respective positions
     */
    createActionsArray() {
        if (this._actions) {
            this._actions = this.arrayUtilityService.sortByProperty(this._actions, 'order');
            this.leftActions = this._actions.reduce((prev, curr) => {
                if (curr.toolbarSlot == 'left') {
                    prev.push(curr);
                }
                return prev;
            }, []);
            this.middleActions = this._actions.reduce((prev, curr) => {
                if (curr.toolbarSlot == 'middle') {
                    prev.push(curr);
                }
                return prev;
            }, []);
            this.rightActions = this._actions.reduce((prev, curr) => {
                if (curr.toolbarSlot == 'right') {
                    prev.push(curr);
                }
                return prev;
            }, []);
        }
    }
    /**
     * this function fire the output
     * @param action
     */
    onActionClicked(action) {
        if (this.viewMode !== ViewMode.Add) {
            this.mapFieldsToValue();
        }
        this.actionOutput.emit(new DynamicFormActionOutput({
            action: action.action,
            value: action.value,
            group: action.group,
            formEntity: this.entity,
            formStatus: this.form.status.toLowerCase(),
            isChanged: !this.form.pristine,
        }));
    }
    /**
     * this function maps the new values in the entity
     */
    mapFieldsToValue(data = null) {
        if (data == null) {
            data = this.entity;
        }
        Object.keys(this.form.getRawValue()).forEach((key) => {
            data[key] = this.form.controls[key].getRawValue();
        });
    }
    /**
     * this function maps the entity values in the fields
     * @param entity
     */
    mapValueToFields(entity) {
        this._fields = this.arrayUtilityService.clone(this._originalFields);
        this.fieldsReadonly();
        this._fields.forEach((field) => {
            if (entity[field.key]) {
                field.value = entity[field.key];
            }
        });
        this.form = this.formGroupService.toFormGroup(this.fields);
    }
    /**
     * this function depending on the view mode changes the read only and disabled value
     */
    fieldsReadonly() {
        this._fields.forEach((field) => {
            field.readonly = this.viewMode !== ViewMode.Edit;
            field.disabled = this.viewMode !== ViewMode.Edit;
        });
    }
    /**
     * this function calls the service that does the expression eval for fields
     * @param {string} expression
     * @param {boolean} defaultValue
     * @param {string | null} formFieldGroup
     * @returns {boolean}
     */
    evalExpression(expression, defaultValue = false, formFieldGroup = null) {
        if (this.formGroupType &&
            formFieldGroup != null &&
            formFieldGroup !== this.activeTabMenuItemsDynamicForm.id) {
            return false;
        }
        if (!expression)
            return defaultValue;
        return this.utilityService.evalFunction(expression, this, this.context != null ? this.context : {});
    }
    /**
     * this function fire the output for the fields
     * @param {FieldChangeOutput} field
     */
    onFieldChanged(field) {
        // Set Fields to Value before emit, to reflect changes instantly
        let data = {};
        if (this.viewMode !== ViewMode.Add) {
            this.mapFieldsToValue(data);
        }
        this._entityTemp = { ...this._entityTemp, ...data };
        this.fieldChangeOutput.emit(new DynamicFormFieldChangeOutput({
            field: field.field,
            value: field.value,
            event: field.event,
            formEntity: this.entityTemp, //need this field to access all fields values of the form whenever there is a change in fields
        }));
    }
    /**
     * This function is responsible to change the active tab property of the class whenever a tab is change on form
     * @param event
     * @private
     */
    onChangeTab(event) {
        this.activeTabMenuItemsDynamicForm = event?.item;
    }
    /**
     * This function construct the tab menu base on property groupFieldsId of the fields
     * @private
     */
    createTabMenu() {
        const tabGroups = this.fields.map((field) => {
            return field.groupFieldsId;
        });
        const tabGroupsUnique = this.arrayUtilityService.clone(Array.from(new Set(tabGroups)));
        tabGroupsUnique.map((value) => {
            this.tabMenuItemsDynamicForm.push({
                label: value,
                id: value,
                command: (event) => this.onChangeTab(event),
            });
        });
        this.activeTabMenuItemsDynamicForm = this.tabMenuItemsDynamicForm[0];
    }
}
PrgDynamicFormComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDynamicFormComponent, deps: [{ token: i1.ObjectsUtilityService }, { token: i2.ArrayUtilityService }, { token: i3.FormGroupService }, { token: i4.UtilityService }, { token: PRG_ENTITY_TYPES_CONFIG }], target: i0.ɵɵFactoryTarget.Component });
PrgDynamicFormComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgDynamicFormComponent, selector: "prg-dynamic-form", inputs: { context: "context", fields: "fields", actions: "actions", entity: "entity", viewMode: "viewMode", formGroupType: "formGroupType" }, outputs: { actionOutput: "actionOutput", fieldChangeOutput: "fieldChangeOutput" }, ngImport: i0, template: "\r\n<div class=\"dynamic-form\">\r\n  <p-tabMenu *ngIf=\"formGroupType==='tab'&&tabMenuItemsDynamicForm.length>0\" [model]=\"tabMenuItemsDynamicForm\" [activeItem]=\"activeTabMenuItemsDynamicForm\">\r\n\r\n  </p-tabMenu>\r\n\r\n\r\n  <form [formGroup]=\"form\">\r\n    <div class=\"form-row\" *ngIf=\"actions!=null&&actions.length>0\">\r\n      <p-toolbar >\r\n        <div class=\"p-toolbar-group-left\">\r\n          <ng-container *ngFor=\"let action of leftActions\">\r\n            <prg-dynamic-form-action\r\n              *ngIf=\"evalExpression(action.visibleExpression,true)\"\r\n              [action]=\"action\"\r\n              [form]=\"form\"\r\n              (actionClick)=\"onActionClicked($event)\"\r\n            >\r\n            </prg-dynamic-form-action>\r\n          </ng-container>\r\n        </div>\r\n        <div>\r\n          <ng-container *ngFor=\"let action of middleActions\">\r\n            <prg-dynamic-form-action\r\n              *ngIf=\"evalExpression(action.visibleExpression, true)\"\r\n              [action]=\"action\"\r\n              [form]=\"form\"\r\n              (actionClick)=\"onActionClicked($event)\"\r\n            >\r\n            </prg-dynamic-form-action>\r\n          </ng-container>\r\n        </div>\r\n        <div class=\"p-toolbar-group-right\">\r\n          <ng-container *ngFor=\"let action of rightActions\">\r\n            <prg-dynamic-form-action\r\n              *ngIf=\"evalExpression(action.visibleExpression, true)\"\r\n              [action]=\"action\"\r\n              [form]=\"form\"\r\n              (actionClick)=\"onActionClicked($event)\"\r\n            >\r\n            </prg-dynamic-form-action>\r\n          </ng-container>\r\n        </div>\r\n      </p-toolbar>\r\n    </div>\r\n    <ng-container *ngIf=\"viewMode !== 'add' && form != null\">\r\n      <div *ngFor=\"let field of fields\" class=\"form-row dynamic-form-fields\">\r\n\r\n        <prg-dynamic-form-field\r\n          *ngIf=\"evalExpression(field.visibleExpression, true,field.groupFieldsId)\"\r\n          [field]=\"field\"\r\n          [form]=\"form\"\r\n          (onChange)=\"onFieldChanged($event)\"\r\n        ></prg-dynamic-form-field>\r\n      </div>\r\n    </ng-container>\r\n  </form>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.TabMenu, selector: "p-tabMenu", inputs: ["model", "activeItem", "scrollable", "popup", "style", "styleClass"] }, { kind: "component", type: i7.Toolbar, selector: "p-toolbar", inputs: ["style", "styleClass"] }, { kind: "directive", type: i8.ɵNgNoValidate, selector: "form:not([ngNoForm]):not([ngNativeValidate])" }, { kind: "directive", type: i8.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i8.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "component", type: i9.PrgDynamicFormFieldComponent, selector: "prg-dynamic-form-field", inputs: ["field", "form"], outputs: ["onChange"] }, { kind: "component", type: i10.PrgDynamicFormActionComponent, selector: "prg-dynamic-form-action", inputs: ["action", "form"], outputs: ["actionClick"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDynamicFormComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-dynamic-form', template: "\r\n<div class=\"dynamic-form\">\r\n  <p-tabMenu *ngIf=\"formGroupType==='tab'&&tabMenuItemsDynamicForm.length>0\" [model]=\"tabMenuItemsDynamicForm\" [activeItem]=\"activeTabMenuItemsDynamicForm\">\r\n\r\n  </p-tabMenu>\r\n\r\n\r\n  <form [formGroup]=\"form\">\r\n    <div class=\"form-row\" *ngIf=\"actions!=null&&actions.length>0\">\r\n      <p-toolbar >\r\n        <div class=\"p-toolbar-group-left\">\r\n          <ng-container *ngFor=\"let action of leftActions\">\r\n            <prg-dynamic-form-action\r\n              *ngIf=\"evalExpression(action.visibleExpression,true)\"\r\n              [action]=\"action\"\r\n              [form]=\"form\"\r\n              (actionClick)=\"onActionClicked($event)\"\r\n            >\r\n            </prg-dynamic-form-action>\r\n          </ng-container>\r\n        </div>\r\n        <div>\r\n          <ng-container *ngFor=\"let action of middleActions\">\r\n            <prg-dynamic-form-action\r\n              *ngIf=\"evalExpression(action.visibleExpression, true)\"\r\n              [action]=\"action\"\r\n              [form]=\"form\"\r\n              (actionClick)=\"onActionClicked($event)\"\r\n            >\r\n            </prg-dynamic-form-action>\r\n          </ng-container>\r\n        </div>\r\n        <div class=\"p-toolbar-group-right\">\r\n          <ng-container *ngFor=\"let action of rightActions\">\r\n            <prg-dynamic-form-action\r\n              *ngIf=\"evalExpression(action.visibleExpression, true)\"\r\n              [action]=\"action\"\r\n              [form]=\"form\"\r\n              (actionClick)=\"onActionClicked($event)\"\r\n            >\r\n            </prg-dynamic-form-action>\r\n          </ng-container>\r\n        </div>\r\n      </p-toolbar>\r\n    </div>\r\n    <ng-container *ngIf=\"viewMode !== 'add' && form != null\">\r\n      <div *ngFor=\"let field of fields\" class=\"form-row dynamic-form-fields\">\r\n\r\n        <prg-dynamic-form-field\r\n          *ngIf=\"evalExpression(field.visibleExpression, true,field.groupFieldsId)\"\r\n          [field]=\"field\"\r\n          [form]=\"form\"\r\n          (onChange)=\"onFieldChanged($event)\"\r\n        ></prg-dynamic-form-field>\r\n      </div>\r\n    </ng-container>\r\n  </form>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.ObjectsUtilityService }, { type: i2.ArrayUtilityService }, { type: i3.FormGroupService }, { type: i4.UtilityService }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_ENTITY_TYPES_CONFIG]
                }] }]; }, propDecorators: { context: [{
                type: Input
            }], fields: [{
                type: Input,
                args: ['fields']
            }], actions: [{
                type: Input,
                args: ['actions']
            }], entity: [{
                type: Input,
                args: ['entity']
            }], viewMode: [{
                type: Input,
                args: ['viewMode']
            }], formGroupType: [{
                type: Input
            }], actionOutput: [{
                type: Output
            }], fieldChangeOutput: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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