import { ActionName } from './constants/action-names';
/**
 * class action
 */
export class BaseAction {
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init) {
        /**
         * defines the element to be used
         * default is button
         */
        this.controlName = ActionName.Button;
        /**
         * with {@link #isDisabled} set to true we use this
         * field to enable or disable the button depending
         * on the validation state of the form
         */
        this.disableWhenFormInvalid = false;
        /**
         * translation base path
         */
        this.translationBasePath = 'buttons';
        /**
         * this property is only relevant for actions that go into a
         * toolbar, it indicates the slot (position) in which the
         * action should be inserted
         *
         * options: end, start
         */
        this.toolbarSlot = 'left';
        /**
         * order
         */
        this.order = 0;
        Object.assign(this, init);
    }
}
/**
 * Action output
 */
export class ActionOutput {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        Object.assign(this, init);
    }
}
/**
 * Field output
 */
export class FieldChangeOutput {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        Object.assign(this, init);
    }
}
/**
 * Dynamic Form Action output
 */
export class DynamicFormActionOutput extends ActionOutput {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/**
 * Dynamic Form Field Change output
 */
export class DynamicFormFieldChangeOutput extends FieldChangeOutput {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/**
 * Actions input type
 */
export var ActionInputType;
(function (ActionInputType) {
    ActionInputType["Submit"] = "submit";
    ActionInputType["Cancel"] = "cancel";
    ActionInputType["Reset"] = "reset";
    ActionInputType["Delete"] = "delete";
    ActionInputType["Linear"] = "linear";
})(ActionInputType || (ActionInputType = {}));
/**
 * form status
 */
export var FormStatus;
(function (FormStatus) {
    FormStatus["Valid"] = "valid";
    FormStatus["Invalid"] = "invalid";
    FormStatus["Disabled"] = "disabled";
})(FormStatus || (FormStatus = {}));
/**
 * base actions keys
 */
export var BaseActionKey;
(function (BaseActionKey) {
    BaseActionKey["Edit"] = "edit";
    BaseActionKey["Add"] = "add";
    BaseActionKey["Reset"] = "reset";
    BaseActionKey["Delete"] = "delete";
    BaseActionKey["Save"] = "save";
    BaseActionKey["Cancel"] = "cancel";
})(BaseActionKey || (BaseActionKey = {}));
//# sourceMappingURL=data:application/json;base64,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