import { Component, EventEmitter, Input, Output } from '@angular/core';
import { ControlName } from '../models/constants/control-names';
import { ControlTypes } from '../models/constants/control-types';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "ng-dynamic-component";
/**
 * Dynamic form field component
 */
export class PrgDynamicFormFieldComponent {
    constructor() {
        /**
         * Emit a new FieldChangeOutput whenever a field value changes
         */
        this.onChange = new EventEmitter();
        /**
         * output to dynamic component
         */
        this.outputs = {
            onValueChange: (fieldChangeOutput) => {
                this.onChange.emit(fieldChangeOutput);
            },
        };
        /**
         * fields type
         * @type {{inputNumber: PrgInputNumberComponent, inputTextArea: PrgInputTextAreaComponent, checkbox: PrgCheckboxComponent, inputText: PrgInputTextComponent, inputDateTime: PrgDateTimeComponent, inputPassword: PrgPasswordComponent, dropdown: PrgSelectComponent, multiSelect: PrgMultiSelectComponent}}
         */
        this.fieldTypes = ControlTypes;
    }
    /**
     * @returns boolean if question is valid or not
     */
    get isValid() {
        return this.form.controls[this.field.key].valid;
    }
    /**
     * @returns string with error
     */
    get errors() {
        return this.form.controls[this.field.key].errors;
    }
    /**
     * get control
     * @returns control
     */
    get formControl() {
        return this.form.controls[this.field.key];
    }
    /**
     * get control name
     * @return controlname
     */
    get controlNames() {
        return ControlName;
    }
}
PrgDynamicFormFieldComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDynamicFormFieldComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgDynamicFormFieldComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgDynamicFormFieldComponent, selector: "prg-dynamic-form-field", inputs: { field: "field", form: "form" }, outputs: { onChange: "onChange" }, ngImport: i0, template: "<div [formGroup]=\"form\" class=\"field\">\r\n      <ndc-dynamic  [ndcDynamicComponent]=\"fieldTypes[field.controlName]\"\r\n       [ndcDynamicInputs]=\"{configs: field, form: form}\"\r\n                   [ndcDynamicOutputs]=\"outputs\">\r\n      </ndc-dynamic>\r\n</div>\r\n", styles: [".p-float-label{margin:40px 0 40px 30px}.field{margin:30px}\n"], dependencies: [{ kind: "directive", type: i1.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i1.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "component", type: i2.DynamicComponent, selector: "ndc-dynamic", inputs: ["ndcDynamicComponent", "ndcDynamicInjector", "ndcDynamicProviders", "ndcDynamicContent"], outputs: ["ndcDynamicCreated"] }, { kind: "directive", type: i2.DynamicIoDirective, selector: "[ndcDynamicInputs],[ndcDynamicOutputs]", inputs: ["ndcDynamicInputs", "ndcDynamicOutputs"], exportAs: ["ndcDynamicIo"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDynamicFormFieldComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-dynamic-form-field', template: "<div [formGroup]=\"form\" class=\"field\">\r\n      <ndc-dynamic  [ndcDynamicComponent]=\"fieldTypes[field.controlName]\"\r\n       [ndcDynamicInputs]=\"{configs: field, form: form}\"\r\n                   [ndcDynamicOutputs]=\"outputs\">\r\n      </ndc-dynamic>\r\n</div>\r\n", styles: [".p-float-label{margin:40px 0 40px 30px}.field{margin:30px}\n"] }]
        }], propDecorators: { field: [{
                type: Input
            }], form: [{
                type: Input
            }], onChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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