import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/tristatecheckbox";
/**
 * Class TriState Checkbox
 */
export class TriStateCheckboxConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.triStateCheckbox;
        /**
         *Name of the component.
         */
        this.name = null;
        /**
         *Label of the checkbox.
         */
        this.label = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Specifies the icon for checkbox true value.
         */
        this.checkboxTrueIcon = 'pi pi-check';
        /**
         *Specifies the icon for checkbox false value.
         */
        this.checkboxFalseIcon = 'pi pi-times';
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetTriStateCheckboxConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Tri State Checkbox configs and assign configs to element
     */
    set setTriStateCheckboxConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetTriStateCheckboxConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetTriStateCheckboxConfigsDirective, deps: [{ token: i1.TriStateCheckbox }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetTriStateCheckboxConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetTriStateCheckboxConfigsDirective, selector: "[setTriStateCheckboxConfigs]", inputs: { setTriStateCheckboxConfigs: "setTriStateCheckboxConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetTriStateCheckboxConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setTriStateCheckboxConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.TriStateCheckbox }]; }, propDecorators: { setTriStateCheckboxConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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