import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/tristatecheckbox";
import * as i3 from "@angular/forms";
import * as i4 from "./tri-state-checkbox.model";
import * as i5 from "@ngx-translate/core";
/**
 * component tri state checkbox
 */
export class PrgTriStateCheckboxComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                event: event,
                value: event.value,
            }));
        }
    }
}
PrgTriStateCheckboxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTriStateCheckboxComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgTriStateCheckboxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgTriStateCheckboxComponent, selector: "prg-tri-state-checkbox-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div class=\"field-tri-state-checkbox\" *ngIf=\"form\" [formGroup]=\"form\">\r\n\r\n<p-triStateCheckbox (onChange)=\"onChanged($event)\"\r\n                    [setTriStateCheckboxConfigs]=\"configs\"\r\n                    [formControlName]=\"configs.key\"\r\n                    [inputId]=\"configs.key\"\r\n                    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n                    [name]=\"configs.key + '.name' | translate\">\r\n</p-triStateCheckbox>\r\n  <label for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i2.TriStateCheckbox, selector: "p-triStateCheckbox", inputs: ["disabled", "name", "ariaLabelledBy", "tabindex", "inputId", "style", "styleClass", "label", "readonly", "checkboxTrueIcon", "checkboxFalseIcon"], outputs: ["onChange"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.PrgSetTriStateCheckboxConfigsDirective, selector: "[setTriStateCheckboxConfigs]", inputs: ["setTriStateCheckboxConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTriStateCheckboxComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-tri-state-checkbox-field', template: "<div class=\"field-tri-state-checkbox\" *ngIf=\"form\" [formGroup]=\"form\">\r\n\r\n<p-triStateCheckbox (onChange)=\"onChanged($event)\"\r\n                    [setTriStateCheckboxConfigs]=\"configs\"\r\n                    [formControlName]=\"configs.key\"\r\n                    [inputId]=\"configs.key\"\r\n                    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n                    [name]=\"configs.key + '.name' | translate\">\r\n</p-triStateCheckbox>\r\n  <label for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJpLXN0YXRlLWNoZWNrYm94LmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL1ByZ0ZyYW1ld29yay5GRS5Db3JlTGliL3NyYy9saWIvbW9kdWxlcy9jb3JlL2NvbXBvbmVudHMvZHluYW1pYy1mb3JtL2R5bmFtaWMtZm9ybS1maWVsZHMvZmllbGRzL3RyaS1zdGF0ZS1jaGVja2JveC90cmktc3RhdGUtY2hlY2tib3guY29tcG9uZW50LnRzIiwiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvUHJnRnJhbWV3b3JrLkZFLkNvcmVMaWIvc3JjL2xpYi9tb2R1bGVzL2NvcmUvY29tcG9uZW50cy9keW5hbWljLWZvcm0vZHluYW1pYy1mb3JtLWZpZWxkcy9maWVsZHMvdHJpLXN0YXRlLWNoZWNrYm94L3RyaS1zdGF0ZS1jaGVja2JveC5jb21wb25lbnQuaHRtbCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLFlBQVksRUFBRSxLQUFLLEVBQUUsTUFBTSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBRXZFLE9BQU8sRUFBRSxpQkFBaUIsRUFBRSxNQUFNLDZCQUE2QixDQUFDOzs7Ozs7O0FBR2hFOztHQUVHO0FBS0gsTUFBTSxPQUFPLDRCQUE0QjtJQUp6QztRQWNFOztXQUVHO1FBQ08sa0JBQWEsR0FBRyxJQUFJLFlBQVksRUFBcUIsQ0FBQztLQWdCakU7SUFkQzs7T0FFRztJQUNJLFNBQVMsQ0FBQyxLQUFVO1FBQ3pCLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLG1CQUFtQixFQUFFO1lBQ3JDLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUNyQixJQUFJLGlCQUFpQixDQUFDO2dCQUNwQixLQUFLLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHO2dCQUN2QixLQUFLLEVBQUUsS0FBSztnQkFDWixLQUFLLEVBQUUsS0FBSyxDQUFDLEtBQUs7YUFDbkIsQ0FBQyxDQUNILENBQUM7U0FDSDtJQUNILENBQUM7O3lIQTVCVSw0QkFBNEI7NkdBQTVCLDRCQUE0QiwrSkNaekMsc25CQVdBOzJGRENhLDRCQUE0QjtrQkFKeEMsU0FBUzsrQkFDRSw4QkFBOEI7OEJBTy9CLE9BQU87c0JBQWYsS0FBSztnQkFJRyxJQUFJO3NCQUFaLEtBQUs7Z0JBS0ksYUFBYTtzQkFBdEIsTUFBTSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgRXZlbnRFbWl0dGVyLCBJbnB1dCwgT3V0cHV0IH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XHJcbmltcG9ydCB7IEZvcm1Hcm91cCB9IGZyb20gJ0Bhbmd1bGFyL2Zvcm1zJztcclxuaW1wb3J0IHsgRmllbGRDaGFuZ2VPdXRwdXQgfSBmcm9tICcuLi8uLi8uLi9tb2RlbHMvYmFzZS1hY3Rpb24nO1xyXG5pbXBvcnQgeyBUcmlTdGF0ZUNoZWNrYm94Q29uZmlndXJhdGlvbiB9IGZyb20gJy4vdHJpLXN0YXRlLWNoZWNrYm94Lm1vZGVsJztcclxuXHJcbi8qKlxyXG4gKiBjb21wb25lbnQgdHJpIHN0YXRlIGNoZWNrYm94XHJcbiAqL1xyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogJ3ByZy10cmktc3RhdGUtY2hlY2tib3gtZmllbGQnLFxyXG4gIHRlbXBsYXRlVXJsOiAnLi90cmktc3RhdGUtY2hlY2tib3guY29tcG9uZW50Lmh0bWwnLFxyXG59KVxyXG5leHBvcnQgY2xhc3MgUHJnVHJpU3RhdGVDaGVja2JveENvbXBvbmVudCB7XHJcbiAgLyoqXHJcbiAgICogVHJpIFN0YXRlIENoZWNrYm94IENvbmZpZ3NcclxuICAgKi9cclxuICBASW5wdXQoKSBjb25maWdzOiBUcmlTdGF0ZUNoZWNrYm94Q29uZmlndXJhdGlvbjtcclxuICAvKipcclxuICAgKiBmb3JtXHJcbiAgICovXHJcbiAgQElucHV0KCkgZm9ybTogRm9ybUdyb3VwO1xyXG5cclxuICAvKipcclxuICAgKiBvdXRwdXRcclxuICAgKi9cclxuICBAT3V0cHV0KCkgb25WYWx1ZUNoYW5nZSA9IG5ldyBFdmVudEVtaXR0ZXI8RmllbGRDaGFuZ2VPdXRwdXQ+KCk7XHJcblxyXG4gIC8qKlxyXG4gICAqIGZ1bmN0aW9uIHRoYXQgdHJpZ2dlcnMgdGhlIG91dHB1dFxyXG4gICAqL1xyXG4gIHB1YmxpYyBvbkNoYW5nZWQoZXZlbnQ6IGFueSk6IHZvaWQge1xyXG4gICAgaWYgKCF0aGlzLmNvbmZpZ3MuZGlzYWJsZWRPdXRwdXRFdmVudCkge1xyXG4gICAgICB0aGlzLm9uVmFsdWVDaGFuZ2UuZW1pdChcclxuICAgICAgICBuZXcgRmllbGRDaGFuZ2VPdXRwdXQoe1xyXG4gICAgICAgICAgZmllbGQ6IHRoaXMuY29uZmlncy5rZXksXHJcbiAgICAgICAgICBldmVudDogZXZlbnQsXHJcbiAgICAgICAgICB2YWx1ZTogZXZlbnQudmFsdWUsXHJcbiAgICAgICAgfSlcclxuICAgICAgKTtcclxuICAgIH1cclxuICB9XHJcbn1cclxuIiwiPGRpdiBjbGFzcz1cImZpZWxkLXRyaS1zdGF0ZS1jaGVja2JveFwiICpuZ0lmPVwiZm9ybVwiIFtmb3JtR3JvdXBdPVwiZm9ybVwiPlxyXG5cclxuPHAtdHJpU3RhdGVDaGVja2JveCAob25DaGFuZ2UpPVwib25DaGFuZ2VkKCRldmVudClcIlxyXG4gICAgICAgICAgICAgICAgICAgIFtzZXRUcmlTdGF0ZUNoZWNrYm94Q29uZmlnc109XCJjb25maWdzXCJcclxuICAgICAgICAgICAgICAgICAgICBbZm9ybUNvbnRyb2xOYW1lXT1cImNvbmZpZ3Mua2V5XCJcclxuICAgICAgICAgICAgICAgICAgICBbaW5wdXRJZF09XCJjb25maWdzLmtleVwiXHJcbiAgICAgICAgICAgICAgICAgICAgW25nQ2xhc3NdPVwieyAncC1maWxsZWQnOiBmb3JtLmNvbnRyb2xzW2NvbmZpZ3M/LmtleV0/LnZhbHVlICE9PSAnJyB9XCJcclxuICAgICAgICAgICAgICAgICAgICBbbmFtZV09XCJjb25maWdzLmtleSArICcubmFtZScgfCB0cmFuc2xhdGVcIj5cclxuPC9wLXRyaVN0YXRlQ2hlY2tib3g+XHJcbiAgPGxhYmVsIGZvcj1cInt7Y29uZmlncy5rZXl9fVwiPnt7Y29uZmlncy5iYXNlUGF0aFRyYW5zbGF0aW9uICsgJy4nICsgY29uZmlncy5rZXkgKyAnLmxhYmVsJyB8IHRyYW5zbGF0ZX19PC9sYWJlbD5cclxuPC9kaXY+XHJcbiJdfQ==