import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/togglebutton";
/**
 * Class ToggleButton
 */
export class ToggleButtonConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.toggleButton;
        /**
         *Enable inline label of the toggle button.
         */
        this.hasLabel = false;
        /**
         *Label for the on state.
         */
        this.onLabel = null;
        /**
         *Label for the off state.
         */
        this.offLabel = null;
        /**
         *Icon for the on state.
         */
        this.onIcon = 'pi pi-check';
        /**
         *Icon for the off state.
         */
        this.offIcon = 'pi pi-times';
        /**
         *Position of the icon, valid values are "left" and "right".
         */
        this.iconPos = 'left';
        /**
         *Inline style of the element.
         */
        this.style = null;
        /**
         *Style class of the element.
         */
        this.styleClass = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetToggleButtonConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input ToggleButton configs and assign configs to element
     */
    set setToggleButtonConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetToggleButtonConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetToggleButtonConfigsDirective, deps: [{ token: i1.ToggleButton }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetToggleButtonConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetToggleButtonConfigsDirective, selector: "[setToggleButtonConfigs]", inputs: { setToggleButtonConfigs: "setToggleButtonConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetToggleButtonConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setToggleButtonConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.ToggleButton }]; }, propDecorators: { setToggleButtonConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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