import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/forms";
import * as i3 from "primeng/togglebutton";
import * as i4 from "./toggle-button.model";
import * as i5 from "@ngx-translate/core";
/**
 * Toggle button component
 */
export class PrgToggleButtonComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.checked,
                event: event,
            }));
        }
    }
}
PrgToggleButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgToggleButtonComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgToggleButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgToggleButtonComponent, selector: "prg-toggle-button-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n    <p-toggleButton\r\n      (onChange)=\"onChanged($event)\"\r\n      [setToggleButtonConfigs]=\"configs\"\r\n      [formControlName]=\"configs.key\"\r\n      [inputId]=\"configs.key\"\r\n      [onLabel]=\"configs.hasLabel?(configs.basePathTranslation + '.' + configs.key + '.onLabel' | translate):''\"\r\n      [offLabel]=\"configs.hasLabel?(configs.basePathTranslation + '.' + configs.key + '.offLabel' | translate):''\"\r\n      ></p-toggleButton>\r\n</div>\r\n\r\n\r\n", dependencies: [{ kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i2.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i2.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i2.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i2.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "component", type: i3.ToggleButton, selector: "p-toggleButton", inputs: ["onLabel", "offLabel", "onIcon", "offIcon", "ariaLabelledBy", "disabled", "style", "styleClass", "inputId", "tabindex", "iconPos"], outputs: ["onChange"] }, { kind: "directive", type: i4.PrgSetToggleButtonConfigsDirective, selector: "[setToggleButtonConfigs]", inputs: ["setToggleButtonConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgToggleButtonComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-toggle-button-field', template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n    <p-toggleButton\r\n      (onChange)=\"onChanged($event)\"\r\n      [setToggleButtonConfigs]=\"configs\"\r\n      [formControlName]=\"configs.key\"\r\n      [inputId]=\"configs.key\"\r\n      [onLabel]=\"configs.hasLabel?(configs.basePathTranslation + '.' + configs.key + '.onLabel' | translate):''\"\r\n      [offLabel]=\"configs.hasLabel?(configs.basePathTranslation + '.' + configs.key + '.offLabel' | translate):''\"\r\n      ></p-toggleButton>\r\n</div>\r\n\r\n\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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