import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/slider";
/**
 * Class Slider
 */
export class SliderConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.slider;
        /**
         *When enabled, displays an animation on click of the slider bar.
         */
        this.animate = false;
        /**
         *Mininum boundary value.
         */
        this.min = 0;
        /**
         *Maximum boundary value.
         */
        this.max = 100;
        /**
         *Orientation of the slider, valid values are horizontal and vertical.
         */
        this.orientation = 'horizontal';
        /**
         *Step factor to increment/decrement the value.
         */
        this.step = 1;
        /**
         *When specified, allows two boundary values to be picked.
         */
        this.range = false;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = 0;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetSliderConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input slider configs and assign configs to element
     */
    set setSliderConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetSliderConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSliderConfigsDirective, deps: [{ token: i1.Slider }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetSliderConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetSliderConfigsDirective, selector: "[setSliderConfigs]", inputs: { setSliderConfigs: "setSliderConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSliderConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setSliderConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.Slider }]; }, propDecorators: { setSliderConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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