import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/slider";
import * as i3 from "@angular/forms";
import * as i4 from "./slider.model";
import * as i5 from "@ngx-translate/core";
/**
 * Component Slider
 */
export class PrgSliderComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.value,
                event: event,
            }));
        }
    }
}
PrgSliderComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSliderComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgSliderComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSliderComponent, selector: "prg-slider-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate) + ': '}}{{value?value:''}}</p>\r\n  <p-slider\r\n    [setSliderConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    (onChange)=\"onChanged($event)\"\r\n    [(ngModel)]=\"value\"\r\n  ></p-slider>\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i2.Slider, selector: "p-slider", inputs: ["animate", "disabled", "min", "max", "orientation", "step", "range", "style", "styleClass", "ariaLabelledBy", "tabindex"], outputs: ["onChange", "onSlideEnd"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.PrgSetSliderConfigsDirective, selector: "[setSliderConfigs]", inputs: ["setSliderConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSliderComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-slider-field', template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate) + ': '}}{{value?value:''}}</p>\r\n  <p-slider\r\n    [setSliderConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    (onChange)=\"onChanged($event)\"\r\n    [(ngModel)]=\"value\"\r\n  ></p-slider>\r\n</div>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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