import { Directive, Input } from '@angular/core';
import { FormControl, FormGroup } from '@angular/forms';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import { ReferenceType } from '../../../models/constants/reference-type';
import * as i0 from "@angular/core";
import * as i1 from "primeng/dropdown";
import * as i2 from "../../../../../../lookup-table/services/lookup-table/abstract-lookup-table.service";
import * as i3 from "../../../../../../entity-types/services/entity-types/abstract-entity-type.service";
import * as i4 from "../../../../../services/utility/array-utility.service";
import * as i5 from "../../../../../services/utility/objects-utility.service";
/**
 * Class Select
 */
export class SelectConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.dropdown;
        /**
         * Reference type
         */
        this.referenceType = null;
        /**
         * Reference name -> shoud be a lookup table name
         */
        this.referenceName = null;
        /**
         *An array of objects to display as the available options.
         */
        this.options = null;
        /**
         *Name of the label field of an option.
         */
        this.optionLabel = 'label';
        /**
         *Name of the value field of an option.
         */
        this.optionValue = 'value';
        /**
         *Name of the disabled field of an option.
         */
        this.optionDisabled = 'disabled';
        /**
         *Name of the label field of an option group.
         */
        this.optionGroupLabel = 'label';
        /**
         *Name of the options field of an option group.
         */
        this.optionGroupChildren = 'items';
        /**
         *Name of the input element.
         */
        this.name = null;
        /**
         *Height of the viewport in pixels, a scrollbar is defined if height of list exceeds this value.
         */
        this.scrollHeight = '200px';
        /**
         *Inline style of the element.
         */
        this.style = null;
        /**
         *Inline style of the overlay panel element.
         */
        this.panelStyle = null;
        /**
         *Style class of the element.
         */
        this.styleClass = null;
        /**
         *Style class of the overlay panel element.
         */
        this.panelStyleClass = null;
        /**
         *When specified, displays an input field to filter the items on keyup.
         */
        this.filter = false;
        /**
         *When specified, filter displays with this value.
         */
        this.filterValue = null;
        /**
         *When filtering is enabled, filterBy decides which field or fields (comma separated) to search against.
         */
        this.filterBy = null;
        /**
         *Defines how the items are filtered, valid values are contains (default) startsWith, endsWith, equals, notEquals, in, lt, lte, gt and gte.
         */
        this.filterMatchMode = 'contains';
        /**
         *Placeholder text to show when filter input is empty.
         */
        this.filterPlaceholder = null;
        /**
         *Locale to use in filtering. The default locale is the host environment's current locale.
         */
        this.filterLocale = 'undefined';
        /**
         *When present, it specifies that an input field must be filled out before submitting the form.
         */
        this.required = false;
        /*
        /!**
         *When present, it specifies that the component should be disabled.
         *!/
        public disabled: boolean = false;*/ //Property already on Base Field
        /*  /!**
         *When present, it specifies that the component cannot be edited.
         *!/
        public readonly: boolean = false;*/ //Property already on Base Field
        /**
         *Text to display when there is no data. Defaults to global value in i18n translation configuration.
         */
        this.emptyMessage = 'No records found.';
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *When present, custom value instead of predefined options can be entered using the editable input field.
         */
        this.editable = false;
        /**
         *Maximum number of character allows in the editable input field.
         */
        this.maxlength = null;
        /**
         *Target element to attach the overlay, valid values are body or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]=mydiv for a div element having #mydiv as variable name).
         */
        this.appendTo = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Default text to display when no option is selected.
         */
        this.placeholder = null;
        /**
         *Identifier of the accessible input element.
         */
        this.inputId = null;
        /**
         *A property to uniquely identify a value in options.
         */
        this.dataKey = null;
        /**
         *When present, it specifies that the component should automatically get focus on load.
         */
        this.autofocus = false;
        /**
         *Applies focus to the filter element when the overlay is shown.
         */
        this.autofocusFilter = false;
        /**
         *Clears the filter value when hiding the dropdown.
         */
        this.resetFilterOnHide = false;
        /**
         *Icon class of the dropdown icon.
         */
        this.dropdownIcon = 'pi pi-chevron-down';
        /**
         *Text to display when filtering does not return any results.
         */
        this.emptyFilterMessage = 'No results found';
        /**
         *Whether to display the first item as the label if no placeholder is defined and value is null.
         */
        this.autoDisplayFirst = true;
        /**
         *Whether to display options as grouped when nested options are provided.
         */
        this.group = false;
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        /**
         *Base zIndex value to use in layering.
         */
        this.baseZIndex = 0;
        /**
         *Whether to automatically manage layering.
         */
        this.autoZIndex = true;
        /**
         *Transition options of the show animation.
         */
        this.showTransitionOptions = '.12s cubic-bezier(0, 0, 0.2, 1)';
        /**
         *Transition options of the hide animation.
         */
        this.hideTransitionOptions = '.1s linear';
        /**
         *Defines a string that labels the filter input.
         */
        this.ariaFilterLabel = null;
        /**
         *Used to define a string that autocomplete attribute the current element.
         */
        this.ariaLabel = null;
        /**
         *Advisory information to display in a tooltip on hover.
         */
        this.tooltip = null;
        /**
         *Style class of the tooltip.
         */
        this.tooltipStyleClass = null;
        /**
         *Position of the tooltip, valid values are right, left, top and bottom.
         */
        this.tooltipPosition = 'top';
        /**
         *Type of CSS position.
         */
        this.tooltipPositionStyle = 'absolute';
        /**
         *Whether the data should be loaded on demand during scroll.
         */
        this.virtualScroll = false;
        /**
         *Height of an item in the list for VirtualScrolling.
         */
        this.virtualScrollItemSize = null;
        /**
         *Whether to use the scroller feature. The properties of scroller component can be used like an object in it.
         */
        this.virtualScrollOptions = null;
        /**
         *Defines if data is loaded and interacted with in lazy manner.
         */
        this.lazy = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetSelectConfigsDirective {
    /**
     * constructor
     * @param {Dropdown} element
     * @param {AbstractLookupTableService} lookupTableService
     * @param {AbstractEntityTypeService} entityTypeService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(element, lookupTableService, entityTypeService, cd, arrayUtilityService, objectsUtilityService) {
        this.element = element;
        this.lookupTableService = lookupTableService;
        this.entityTypeService = entityTypeService;
        this.cd = cd;
        this.arrayUtilityService = arrayUtilityService;
        this.objectsUtilityService = objectsUtilityService;
    }
    /**
     * get options from lookup table or entity type list
     * and assign configs to element
     */
    set setSelectConfigs(configs) {
        switch (configs.referenceType) {
            case ReferenceType.LookupTable:
                if (configs.referenceName !== null && configs.referenceName.length) {
                    this.lookupTableService
                        .getLookupTableItemsByLookupTableNameAsync(configs.referenceName)
                        .then((options) => {
                        configs.options = this.objectsUtilityService.cloneObject(options);
                        Object.assign(this.element, configs);
                        /**
                         * we need to set the value of the control
                         * again because for some reason it stays null
                         * and doesn't map the value selected by default,
                         * we've already had to analyse this
                         * and for now we can't understand why this behaviour
                         */
                        if (!this.form) {
                            this.form = new FormGroup({
                                [configs.key]: new FormControl(),
                            });
                        }
                        if (configs.value != null) {
                            this.form.get(configs.key).setValue(configs.value);
                            this.cd.detectChanges();
                        }
                    });
                    this.cd.detectChanges();
                }
                else {
                    this.lookupTableService.getAllLookupTableAsync().then((options) => {
                        configs.options = this.objectsUtilityService.cloneObject(options);
                        Object.assign(this.element, configs);
                        /**
                         * we need to set the value of the control
                         * again because for some reason it stays null
                         * and doesn't map the value selected by default,
                         * we've already had to analyse this
                         * and for now we can't understand why this behaviour
                         */
                        if (configs.value) {
                            this.form.get(configs.key).setValue(configs.value);
                        }
                    });
                }
                break;
            case ReferenceType.EntityType:
                this.entityTypeService.getEntityTypeListAsync().then((value) => {
                    configs.options = value;
                    Object.assign(this.element, configs);
                    if (configs.value) {
                        this.form.get(configs.key).setValue(configs.value);
                    }
                });
                this.cd.detectChanges();
                break;
            case ReferenceType.EntityTypeAllData:
                this.entityTypeService.getEntityTypeListAsync().then((value) => {
                    let entities = this.arrayUtilityService.clone(value);
                    entities.map(async (entityType, index) => {
                        let entityTypeAllData = this.objectsUtilityService.cloneObject(await this.entityTypeService.getAllEntityTypeDataByName(entityType.name));
                        entities[index].properties = this.objectsUtilityService.cloneObject(entityTypeAllData.properties);
                        entities[index].attributes = this.objectsUtilityService.cloneObject(entityTypeAllData.attributes);
                        entities[index].operations = this.objectsUtilityService.cloneObject(entityTypeAllData.operations);
                        /* entities[index]['data'] = [];
                        entities[index]['data'].push({
                          subData: this.arrayUtilityService.clone(
                            entityTypeAllData.operations
                          ),
                          label: 'operations',
                        });
            
                        entities[index]['data'].push({
                          subData: this.arrayUtilityService.clone(
                            entityTypeAllData.properties
                          ),
                          label: 'properties',
                        });
                        entities[index]['data'].push({
                          subData: this.arrayUtilityService.clone(
                            entityTypeAllData.attributes
                          ),
                          label: 'attributes',
                        });*/
                    });
                    configs.options = entities;
                    Object.assign(this.element, configs);
                    if (configs.value) {
                        this.form.get(configs.key).setValue(configs.value);
                    }
                });
                break;
            default:
                Object.assign(this.element, configs);
                break;
        }
    }
}
PrgSetSelectConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSelectConfigsDirective, deps: [{ token: i1.Dropdown }, { token: i2.AbstractLookupTableService }, { token: i3.AbstractEntityTypeService }, { token: i0.ChangeDetectorRef }, { token: i4.ArrayUtilityService }, { token: i5.ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetSelectConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetSelectConfigsDirective, selector: "[setSelectConfigs]", inputs: { form: "form", setSelectConfigs: "setSelectConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSelectConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setSelectConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.Dropdown }, { type: i2.AbstractLookupTableService }, { type: i3.AbstractEntityTypeService }, { type: i0.ChangeDetectorRef }, { type: i4.ArrayUtilityService }, { type: i5.ObjectsUtilityService }]; }, propDecorators: { form: [{
                type: Input
            }], setSelectConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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