import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/dropdown";
import * as i3 from "@angular/forms";
import * as i4 from "./select.model";
import * as i5 from "@ngx-translate/core";
/**
 * component dropdown/select
 */
export class PrgSelectComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.value,
                event: event,
            }));
        }
    }
}
PrgSelectComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgSelectComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSelectComponent, selector: "prg-select-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.name' | translate}}</p>\r\n  <p-dropdown\r\n    [form]=\"form\"\r\n    [options]=\"configs.options\"\r\n    [setSelectConfigs]=\"configs\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [placeholder]=\"\r\n      configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n        | translate\r\n    \"\r\n    [name]=\"configs.key + '.name' | translate\"\r\n    (onChange)=\"onChanged($event)\"\r\n  ></p-dropdown>\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i2.Dropdown, selector: "p-dropdown", inputs: ["scrollHeight", "filter", "name", "style", "panelStyle", "styleClass", "panelStyleClass", "readonly", "required", "editable", "appendTo", "tabindex", "placeholder", "filterPlaceholder", "filterLocale", "inputId", "selectId", "dataKey", "filterBy", "autofocus", "resetFilterOnHide", "dropdownIcon", "optionLabel", "optionValue", "optionDisabled", "optionGroupLabel", "optionGroupChildren", "autoDisplayFirst", "group", "showClear", "emptyFilterMessage", "emptyMessage", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "autoZIndex", "baseZIndex", "showTransitionOptions", "hideTransitionOptions", "ariaFilterLabel", "ariaLabel", "ariaLabelledBy", "filterMatchMode", "maxlength", "tooltip", "tooltipPosition", "tooltipPositionStyle", "tooltipStyleClass", "autofocusFilter", "disabled", "itemSize", "options", "filterValue"], outputs: ["onChange", "onFilter", "onFocus", "onBlur", "onClick", "onShow", "onHide", "onClear", "onLazyLoad"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.PrgSetSelectConfigsDirective, selector: "[setSelectConfigs]", inputs: ["form", "setSelectConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-select-field', template: "<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.name' | translate}}</p>\r\n  <p-dropdown\r\n    [form]=\"form\"\r\n    [options]=\"configs.options\"\r\n    [setSelectConfigs]=\"configs\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [placeholder]=\"\r\n      configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n        | translate\r\n    \"\r\n    [name]=\"configs.key + '.name' | translate\"\r\n    (onChange)=\"onChanged($event)\"\r\n  ></p-dropdown>\r\n</div>\r\n" }]
        }], propDecorators: { onValueChange: [{
                type: Output
            }], configs: [{
                type: Input
            }], form: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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