import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/selectbutton";
/**
 * Class Select Button
 */
export class SelectButtonConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.selectButton;
        /**
         *An array of selectitems to display as the available options.
         */
        this.options = null;
        /**
         *Name of the label field of an option.
         */
        this.optionLabel = 'label';
        /**
         *Name of the value field of an option.
         */
        this.optionValue = 'value';
        /**
         *Name of the disabled field of an option.
         */
        this.optionDisabled = 'disabled';
        /**
         *When specified, allows selecting multiple values.
         */
        this.multiple = false;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = 0;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *A property to uniquely identify a value in options.
         */
        this.dataKey = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetSelectButtonConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Select Button configs and assign configs to element
     */
    set setSelectButtonConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetSelectButtonConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSelectButtonConfigsDirective, deps: [{ token: i1.SelectButton }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetSelectButtonConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetSelectButtonConfigsDirective, selector: "[setSelectButtonConfigs]", inputs: { setSelectButtonConfigs: "setSelectButtonConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSelectButtonConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setSelectButtonConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.SelectButton }]; }, propDecorators: { setSelectButtonConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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