import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "primeng/selectbutton";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "./select-button.model";
import * as i5 from "@ngx-translate/core";
/**
 * component select button
 */
export class PrgSelectButtonComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                event: event,
                value: event.value,
            }));
        }
    }
}
PrgSelectButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectButtonComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgSelectButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSelectButtonComponent, selector: "prg-select-button-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div class=\"field-select-button\" *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n<p-selectButton\r\n  (onChange)=\"onChanged($event)\"\r\n  [setSelectButtonConfigs]=\"configs\"\r\n  [formControlName]=\"configs.key\"\r\n  [id]=\"configs.key\"\r\n  [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\">\r\n</p-selectButton>\r\n</div>\r\n", dependencies: [{ kind: "component", type: i1.SelectButton, selector: "p-selectButton", inputs: ["options", "optionLabel", "optionValue", "optionDisabled", "tabindex", "multiple", "style", "styleClass", "ariaLabelledBy", "disabled", "dataKey"], outputs: ["onOptionClick", "onChange"] }, { kind: "directive", type: i2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.PrgSetSelectButtonConfigsDirective, selector: "[setSelectButtonConfigs]", inputs: ["setSelectButtonConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectButtonComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-select-button-field', template: "<div class=\"field-select-button\" *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n<p-selectButton\r\n  (onChange)=\"onChanged($event)\"\r\n  [setSelectButtonConfigs]=\"configs\"\r\n  [formControlName]=\"configs.key\"\r\n  [id]=\"configs.key\"\r\n  [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\">\r\n</p-selectButton>\r\n</div>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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