import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/rating";
/**
 * Class Rating
 */
export class RatingConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.rating;
        /**
         *Number of stars.
         */
        this.stars = 5;
        /**
         *When specified a cancel icon is displayed to allow removing the value.
         */
        this.cancel = true;
        /**
         *Style class of the on icon.
         */
        this.iconOnClass = 'pi pi-star-fill';
        /**
         *Style class of the off icon.
         */
        this.iconOffClass = 'pi pi-star';
        /**
         *Style class of the cancel icon.
         */
        this.iconCancelClass = 'pi pi-ban';
        /**
         *Inline style of the on icon.
         */
        this.iconOnStyle = null;
        /**
         *Inline style of the off icon.
         */
        this.iconOffStyle = null;
        /**
         *Inline style of the cancel icon.
         */
        this.iconCancelStyle = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetRatingConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Rating configs and assign configs to element
     */
    set setRatingConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetRatingConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetRatingConfigsDirective, deps: [{ token: i1.Rating }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetRatingConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetRatingConfigsDirective, selector: "[setRatingConfigs]", inputs: { setRatingConfigs: "setRatingConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetRatingConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setRatingConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.Rating }]; }, propDecorators: { setRatingConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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