import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/rating";
import * as i3 from "@angular/forms";
import * as i4 from "./rating.model";
import * as i5 from "@ngx-translate/core";
/**
 * Component Rating
 */
export class PrgRatingComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.value,
                event: event,
            }));
        }
    }
}
PrgRatingComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRatingComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgRatingComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgRatingComponent, selector: "prg-rating-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate)}}</p>\r\n  <p-rating\r\n    [setRatingConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    (onRate)=\"onChanged($event)\"\r\n\r\n  ></p-rating>\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i2.Rating, selector: "p-rating", inputs: ["disabled", "readonly", "stars", "cancel", "iconOnClass", "iconOnStyle", "iconOffClass", "iconOffStyle", "iconCancelClass", "iconCancelStyle"], outputs: ["onRate", "onCancel"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.PrgSetRatingConfigsDirective, selector: "[setRatingConfigs]", inputs: ["setRatingConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRatingComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-rating-field', template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate)}}</p>\r\n  <p-rating\r\n    [setRatingConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    (onRate)=\"onChanged($event)\"\r\n\r\n  ></p-rating>\r\n</div>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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