import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/radiobutton";
/**
 * Class Radio Button
 */
export class RadioButtonConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.radioButton;
        /**
         *Name of the radiobutton group.
         */
        this.name = null;
        /**
         *Value of the radiobutton.
         */
        this.value = null;
        /**
         *Label of the radiobutton.
         */
        this.label = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Used to define a string that labels the input element.
         */
        this.ariaLabel = null;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Style class of the label.
         */
        this.labelStyleClass = null;
        /**
         *An array of objects to display as dynamic values.Mandatory field.
         */
        this.options = null;
        /**
         *Name of the value field of an option. Default 'value'.
         */
        this.optionValue = 'value';
        /**
         *Name of the key field of an option.Default 'key'.Also used to bring the translation of the field
         */
        this.optionKey = 'key';
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetRadioButtonConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Radio Button configs and assign configs to element
     */
    set setRadioButtonConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetRadioButtonConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetRadioButtonConfigsDirective, deps: [{ token: i1.RadioButton }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetRadioButtonConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetRadioButtonConfigsDirective, selector: "[setRadioButtonConfigs]", inputs: { setRadioButtonConfigs: "setRadioButtonConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetRadioButtonConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setRadioButtonConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.RadioButton }]; }, propDecorators: { setRadioButtonConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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