import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "primeng/radiobutton";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "./radio-button.model";
import * as i5 from "@ngx-translate/core";
/**
 * component Radio button
 */
export class PrgRadioButtonComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                event: event,
                value: event.value,
            }));
        }
    }
}
PrgRadioButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRadioButtonComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgRadioButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgRadioButtonComponent, selector: "prg-radio-button-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div class=\"field-radio-button\" *ngIf=\"form\" [formGroup]=\"form\">\r\n<!--//TODO Colocar title na tradu\u00E7\u00E3o dos radio-button-->\r\n  <label>{{configs.basePathTranslation + '.' + configs.key + '.title' | translate}}</label>\r\n  <ng-container *ngIf=\"configs.options;else singleRadio\"  >\r\n  <div *ngFor=\"let option of configs.options \" [ngClass]=\"['py-1']\">\r\n    <p-radioButton\r\n      [formControlName]=\"configs.key\"\r\n      [setRadioButtonConfigs]=\"configs\"\r\n      (onClick)=\"onChanged($event)\"\r\n      [inputId]=\"option[configs.optionKey]\"\r\n      [value]=\"option[configs.optionValue]\">\r\n    </p-radioButton>\r\n    <label\r\n      for=\"{{option[configs.optionKey]}}\">{{configs.basePathTranslation + '.' + configs.key + '.' + option[configs.optionKey] + '.label' | translate}}</label>\r\n  </div>\r\n  </ng-container>\r\n  <ng-template #singleRadio>\r\n    <p-radioButton\r\n      [formControlName]=\"configs.key\"\r\n      [setRadioButtonConfigs]=\"configs\"\r\n      (onClick)=\"onChanged($event)\"\r\n      [inputId]=\"configs.key\"\r\n      [label]=\"configs.basePathTranslation + '.' + configs.key  + '.label' | translate\">\r\n    </p-radioButton>\r\n\r\n  </ng-template>\r\n</div>\r\n", dependencies: [{ kind: "component", type: i1.RadioButton, selector: "p-radioButton", inputs: ["value", "formControlName", "name", "disabled", "label", "tabindex", "inputId", "ariaLabelledBy", "ariaLabel", "style", "styleClass", "labelStyleClass"], outputs: ["onClick", "onFocus", "onBlur"] }, { kind: "directive", type: i2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.PrgSetRadioButtonConfigsDirective, selector: "[setRadioButtonConfigs]", inputs: ["setRadioButtonConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRadioButtonComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-radio-button-field', template: "<div class=\"field-radio-button\" *ngIf=\"form\" [formGroup]=\"form\">\r\n<!--//TODO Colocar title na tradu\u00E7\u00E3o dos radio-button-->\r\n  <label>{{configs.basePathTranslation + '.' + configs.key + '.title' | translate}}</label>\r\n  <ng-container *ngIf=\"configs.options;else singleRadio\"  >\r\n  <div *ngFor=\"let option of configs.options \" [ngClass]=\"['py-1']\">\r\n    <p-radioButton\r\n      [formControlName]=\"configs.key\"\r\n      [setRadioButtonConfigs]=\"configs\"\r\n      (onClick)=\"onChanged($event)\"\r\n      [inputId]=\"option[configs.optionKey]\"\r\n      [value]=\"option[configs.optionValue]\">\r\n    </p-radioButton>\r\n    <label\r\n      for=\"{{option[configs.optionKey]}}\">{{configs.basePathTranslation + '.' + configs.key + '.' + option[configs.optionKey] + '.label' | translate}}</label>\r\n  </div>\r\n  </ng-container>\r\n  <ng-template #singleRadio>\r\n    <p-radioButton\r\n      [formControlName]=\"configs.key\"\r\n      [setRadioButtonConfigs]=\"configs\"\r\n      (onClick)=\"onChanged($event)\"\r\n      [inputId]=\"configs.key\"\r\n      [label]=\"configs.basePathTranslation + '.' + configs.key  + '.label' | translate\">\r\n    </p-radioButton>\r\n\r\n  </ng-template>\r\n</div>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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