import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/password";
/**
 * Class Input Text
 */
export class InputPasswordConfiguration extends BaseField {
    /**
     * constructor
     * @param init init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.inputPassword;
        /**
         *Text to prompt password entry. Defaults to PrimeNG I18N API configuration.
         */
        this.promptLabel = null;
        /**
         *^(((?=.*[a-z])(?=.*[A-Z]))|((?=.*[a-z])(?=.*[0-9]))|((?=.*[A-Z])(?=.*[0-9])))(?=.{6,}).
         */
        this.mediumRegex = 'Regex for a medium level password.';
        /**
         *^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.{8,})
         */
        this.strongRegex = 'Regex for a strong level password.';
        /**
         *Text for a weak password. Defaults to PrimeNG I18N API configuration.
         */
        this.weakLabel = null;
        /**
         *Text for a medium password. Defaults to PrimeNG I18N API configuration.
         */
        this.mediumLabel = null;
        /**
         *Text for a strong password. Defaults to PrimeNG I18N API configuration.
         */
        this.strongLabel = null;
        /**
         *Whether to show the strength indicator or not.
         */
        this.feedback = true;
        /**
         *Whether to show an icon to display the password as plain text.
         */
        this.toggleMask = false;
        /**
         *Id of the element or body for document where the overlay should be appended to.
         */
        this.appendTo = null;
        /**
         *Inline style of the input field.
         */
        this.inputStyle = null;
        /**
         *Style class of the input field.
         */
        this.inputStyleClass = null;
        /**
         *Identifier of the accessible input element.
         */
        this.inputId = null;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Advisory information to display on input.
         */
        this.placeholder = null;
        /**
         *Label of the input for accessibility.
         */
        this.label = null;
        /**
         *Defines a string that labels the input for accessibility.
         */
        this.ariaLabel = null;
        /**
         *Specifies one or more IDs in the DOM that labels the input field.
         */
        this.ariaLabelledBy = null;
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 * */
export class PrgSetInputPasswordConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input password configs and assign configs to element
     */
    set setInputPasswordConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetInputPasswordConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputPasswordConfigsDirective, deps: [{ token: i1.Password }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetInputPasswordConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetInputPasswordConfigsDirective, selector: "[setInputPasswordConfigs]", inputs: { setInputPasswordConfigs: "setInputPasswordConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputPasswordConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setInputPasswordConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.Password }]; }, propDecorators: { setInputPasswordConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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