import { Directive, Input } from '@angular/core';
import { FormControl, FormGroup } from '@angular/forms';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import { ReferenceType } from '../../../models/constants/reference-type';
import * as i0 from "@angular/core";
import * as i1 from "primeng/multiselect";
import * as i2 from "../../../../../../lookup-table/services/lookup-table/abstract-lookup-table.service";
import * as i3 from "../../../../../../entity-types/services/entity-types/abstract-entity-type.service";
import * as i4 from "../../../../../services/utility/array-utility.service";
import * as i5 from "../../../../../services/utility/objects-utility.service";
/**
 * Class Input Text
 */
export class MultiSelectConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.multiSelect;
        /**
         * Reference type
         */
        this.referenceType = null;
        /**
         * Reference name -> shoud be a lookup table name
         */
        this.referenceName = null;
        /**
         *Target element to attach the overlay, valid values are body or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]=mydiv for a div element having #mydiv as variable name).
         */
        this.appendTo = null;
        /**
         *Defines a string that labels the filter input.
         */
        this.ariaFilterLabel = null;
        /**
         *Label of the input for accessibility.
         */
        this.label = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Applies focus to the filter element when the overlay is shown.
         */
        this.autofocusFilter = false;
        /**
         *Whether to automatically manage layering.
         */
        this.autoZIndex = true;
        /**
         *Base zIndex value to use in layering.
         */
        this.baseZIndex = 0;
        /**
         *Label to display when there are no selections. Deprecated: Use placeholder instead.
         */
        this.defaultLabel = 'Choose';
        /**
         *A property to uniquely identify a value in options.
         */
        this.dataKey = null;
        /*
        /!**
         *When present, it specifies that the element should be disabled.
         *!/
        public disabled: boolean = false;*/ //Property already on Base Field
        /**
         *Whether to show labels of selected item labels or use default label.
         */
        this.displaySelectedLabel = true;
        /**
         *Icon class of the dropdown icon.
         */
        this.dropdownIcon = 'pi pi-chevron-down';
        /**
         *Text to display when filtering does not return any results.
         */
        this.emptyFilterMessage = 'No results found';
        /**
         *When specified, displays an input field to filter the items on keyup.
         */
        this.filter = true;
        /**
         *Defines how the items are filtered, valid values are contains (default) startsWith, endsWith, equals, notEquals, in, lt, lte, gt and gte.
         */
        this.filterMatchMode = 'contains';
        /**
         *When specified, filter displays with this value.
         */
        this.filterValue = null;
        /**
         *Locale to use in filtering. The default locale is the host environment's current locale.
         */
        this.filterLocale = 'undefined';
        /**
         *When filtering is enabled, filterBy decides which field or fields (comma separated) to search against.
         */
        this.filterBy = null;
        /**
         *Defines placeholder of the filter input.
         */
        this.filterPlaceHolder = null;
        /**
         *Transition options of the hide animation.
         */
        this.hideTransitionOptions = '.1s linear';
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Decides how many selected item labels to show at most.
         */
        this.maxSelectedLabels = 3;
        /**
         *Name of the input element.
         */
        this.name = null;
        /**
         *An array of objects to display as the available options.
         */
        this.options = [];
        /**
         *Name of the label field of an option.
         */
        this.optionLabel = 'label';
        /**
         *Name of the value field of an option.
         */
        this.optionValue = 'value';
        /**
         *Name of the disabled field of an option.
         */
        this.optionDisabled = 'disabled';
        /**
         *Name of the label field of an option group.
         */
        this.optionGroupLabel = 'label';
        /**
         *Name of the options field of an option group.
         */
        this.optionGroupChildren = 'items';
        /**
         *Whether to display options as grouped when nested options are provided.
         */
        this.group = false;
        /**
         *Specifies the visibility of the options panel.
         */
        this.overlayVisible = false;
        /**
         *Inline style of the overlay panel.
         */
        this.panelStyle = null;
        /**
         *Label to display when there are no selections.
         */
        this.placeholder = null;
        /**
         *When present, it specifies that the component cannot be edited.
         */
        this.readonly = false;
        /**
         *Text to display when there is no data. Defaults to global value in i18n translation configuration.
         */
        this.emptyMessage = 'No records found.';
        /**
         *Clears the filter value when hiding the dropdown.
         */
        this.resetFilterOnHide = false;
        /**
         *Height of the viewport in pixels, a scrollbar is defined if height of list exceeds this value.
         */
        this.scrollHeight = '200px';
        /**
         *Label to display after exceeding max selected labels e.g. ({0} items selected), defaults ellipsis keyword to indicate a text-overflow.
         */
        this.selectedItemsLabel = 'ellipsis';
        /**
         *Number of maximum options that can be selected.
         */
        this.selectionLimit = null;
        /**
         *Whether to show the header.
         */
        this.showHeader = true;
        /**
         *Transition options of the show animation.
         */
        this.showTransitionOptions = '.12s cubic-bezier(0, 0, 0.2, 1)';
        /**
         *Whether to show the checkbox at header to toggle all items at once.
         */
        this.showToggleAll = true;
        /**
         *Inline style of the element.
         */
        this.style = null;
        /**
         *Style class of the element.
         */
        this.styleClass = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Advisory information to display in a tooltip on hover.
         */
        this.tooltip = null;
        /**
         *Style class of the tooltip.
         */
        this.tooltipStyleClass = null;
        /**
         *Position of the tooltip, valid values are right, left, top and bottom.
         */
        this.tooltipPosition = 'top';
        /**
         *Type of CSS position.
         */
        this.tooltipPositionStyle = 'absolute';
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        /**
         *Whether the data should be loaded on demand during scroll.
         */
        this.virtualScroll = false;
        /**
         *Height of an item in the list for VirtualScrolling.
         */
        this.virtualScrollItemSize = null;
        /**
         *Whether to use the scroller feature. The properties of scroller component can be used like an object in it.
         */
        this.virtualScrollOptions = null;
        /**
         *Defines if data is loaded and interacted with in lazy manner.
         */
        this.lazy = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetMultiselectConfigsDirective {
    /**
     * constructor
     * @param {MultiSelect} element
     * @param {AbstractLookupTableService} lookupTableService
     * @param {AbstractEntityTypeService} entityTypeService
     * @param {ChangeDetectorRef} cd
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(element, lookupTableService, entityTypeService, cd, arrayUtilityService, objectsUtilityService) {
        this.element = element;
        this.lookupTableService = lookupTableService;
        this.entityTypeService = entityTypeService;
        this.cd = cd;
        this.arrayUtilityService = arrayUtilityService;
        this.objectsUtilityService = objectsUtilityService;
    }
    /**
     * input multi select configs and assign configs to element
     */
    set setMultiSelectConfigs(configs) {
        switch (configs.referenceType) {
            case ReferenceType.LookupTable:
                if (configs.referenceName !== null && configs.referenceName.length) {
                    this.lookupTableService
                        .getLookupTableItemsByLookupTableNameAsync(configs.referenceName)
                        .then((options) => {
                        configs.options = this.objectsUtilityService.cloneObject(options);
                        Object.assign(this.element, configs);
                        /**
                         * we need to set the value of the control
                         * again because for some reason it stays null
                         * and doesn't map the value selected by default,
                         * we've already had to analyse this
                         * and for now we can't understand why this behaviour
                         */
                        if (!this.form) {
                            this.form = new FormGroup({
                                [configs.key]: new FormControl(),
                            });
                        }
                        if (configs.value != null) {
                            this.form.get(configs.key).setValue(configs.value);
                            this.cd.detectChanges();
                        }
                    });
                    this.cd.detectChanges();
                }
                else {
                    this.lookupTableService.getAllLookupTableAsync().then((options) => {
                        configs.options = this.objectsUtilityService.cloneObject(options);
                        Object.assign(this.element, configs);
                        /**
                         * we need to set the value of the control
                         * again because for some reason it stays null
                         * and doesn't map the value selected by default,
                         * we've already had to analyse this
                         * and for now we can't understand why this behaviour
                         */
                        if (configs.value) {
                            this.form.get(configs.key).setValue(configs.value);
                        }
                    });
                }
                break;
            case ReferenceType.EntityType:
                this.entityTypeService.getEntityTypeListAsync().then((value) => {
                    configs.options = value;
                    Object.assign(this.element, configs);
                    if (configs.value) {
                        this.form.get(configs.key).setValue(configs.value);
                    }
                });
                this.cd.detectChanges();
                break;
            case ReferenceType.EntityTypeAllData:
                this.entityTypeService.getEntityTypeListAsync().then((value) => {
                    let entities = this.arrayUtilityService.clone(value);
                    entities.map(async (entityType, index) => {
                        let entityTypeAllData = this.objectsUtilityService.cloneObject(await this.entityTypeService.getAllEntityTypeDataByName(entityType.name));
                        entities[index].properties = this.objectsUtilityService.cloneObject(entityTypeAllData.properties);
                        entities[index].attributes = this.objectsUtilityService.cloneObject(entityTypeAllData.attributes);
                        entities[index].operations = this.objectsUtilityService.cloneObject(entityTypeAllData.operations);
                        /* entities[index]['data'] = [];
                        entities[index]['data'].push({
                          subData: this.arrayUtilityService.clone(
                            entityTypeAllData.operations
                          ),
                          label: 'operations',
                        });
            
                        entities[index]['data'].push({
                          subData: this.arrayUtilityService.clone(
                            entityTypeAllData.properties
                          ),
                          label: 'properties',
                        });
                        entities[index]['data'].push({
                          subData: this.arrayUtilityService.clone(
                            entityTypeAllData.attributes
                          ),
                          label: 'attributes',
                        });*/
                    });
                    configs.options = entities;
                    Object.assign(this.element, configs);
                    if (configs.value) {
                        this.form.get(configs.key).setValue(configs.value);
                    }
                });
                break;
            default:
                Object.assign(this.element, configs);
                break;
        }
    }
}
PrgSetMultiselectConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetMultiselectConfigsDirective, deps: [{ token: i1.MultiSelect }, { token: i2.AbstractLookupTableService }, { token: i3.AbstractEntityTypeService }, { token: i0.ChangeDetectorRef }, { token: i4.ArrayUtilityService }, { token: i5.ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetMultiselectConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetMultiselectConfigsDirective, selector: "[setMultiSelectConfigs]", inputs: { form: "form", setMultiSelectConfigs: "setMultiSelectConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetMultiselectConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setMultiSelectConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.MultiSelect }, { type: i2.AbstractLookupTableService }, { type: i3.AbstractEntityTypeService }, { type: i0.ChangeDetectorRef }, { type: i4.ArrayUtilityService }, { type: i5.ObjectsUtilityService }]; }, propDecorators: { form: [{
                type: Input
            }], setMultiSelectConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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