import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/multiselect";
import * as i3 from "@angular/forms";
import * as i4 from "./multi-select.model";
import * as i5 from "@ngx-translate/core";
/**
 * component multi select
 */
export class PrgMultiSelectComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.value,
                event: event,
            }));
        }
    }
}
PrgMultiSelectComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgMultiSelectComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgMultiSelectComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgMultiSelectComponent, selector: "prg-multi-select-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.name' | translate}}</p>\r\n  <p-multiSelect\r\n    display=\"chip\"\r\n    [form]=\"form\"\r\n    (onChange)=\"onChanged($event)\"\r\n    [options]=\"configs.options\"\r\n    [setMultiSelectConfigs]=\"configs\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n    [name]=\"configs.key + '.name' | translate\"\r\n  ></p-multiSelect>\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i2.MultiSelect, selector: "p-multiSelect", inputs: ["style", "styleClass", "panelStyle", "panelStyleClass", "inputId", "disabled", "readonly", "group", "filter", "filterPlaceHolder", "filterLocale", "overlayVisible", "tabindex", "appendTo", "dataKey", "name", "label", "ariaLabelledBy", "displaySelectedLabel", "maxSelectedLabels", "selectionLimit", "selectedItemsLabel", "showToggleAll", "emptyFilterMessage", "emptyMessage", "resetFilterOnHide", "dropdownIcon", "optionLabel", "optionValue", "optionDisabled", "optionGroupLabel", "optionGroupChildren", "showHeader", "autoZIndex", "baseZIndex", "filterBy", "scrollHeight", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "showTransitionOptions", "hideTransitionOptions", "ariaFilterLabel", "filterMatchMode", "tooltip", "tooltipPosition", "tooltipPositionStyle", "tooltipStyleClass", "autofocusFilter", "display", "autocomplete", "showClear", "defaultLabel", "placeholder", "options", "filterValue", "itemSize"], outputs: ["onChange", "onFilter", "onFocus", "onBlur", "onClick", "onClear", "onPanelShow", "onPanelHide", "onLazyLoad"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.PrgSetMultiselectConfigsDirective, selector: "[setMultiSelectConfigs]", inputs: ["form", "setMultiSelectConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgMultiSelectComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-multi-select-field', template: "<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.name' | translate}}</p>\r\n  <p-multiSelect\r\n    display=\"chip\"\r\n    [form]=\"form\"\r\n    (onChange)=\"onChanged($event)\"\r\n    [options]=\"configs.options\"\r\n    [setMultiSelectConfigs]=\"configs\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n    [name]=\"configs.key + '.name' | translate\"\r\n  ></p-multiSelect>\r\n</div>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibXVsdGktc2VsZWN0LmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL1ByZ0ZyYW1ld29yay5GRS5Db3JlTGliL3NyYy9saWIvbW9kdWxlcy9jb3JlL2NvbXBvbmVudHMvZHluYW1pYy1mb3JtL2R5bmFtaWMtZm9ybS1maWVsZHMvZmllbGRzL211bHRpc2VsZWN0L211bHRpLXNlbGVjdC5jb21wb25lbnQudHMiLCIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9QcmdGcmFtZXdvcmsuRkUuQ29yZUxpYi9zcmMvbGliL21vZHVsZXMvY29yZS9jb21wb25lbnRzL2R5bmFtaWMtZm9ybS9keW5hbWljLWZvcm0tZmllbGRzL2ZpZWxkcy9tdWx0aXNlbGVjdC9tdWx0aS1zZWxlY3QuY29tcG9uZW50Lmh0bWwiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFNBQVMsRUFBRSxZQUFZLEVBQUUsS0FBSyxFQUFFLE1BQU0sRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUV2RSxPQUFPLEVBQUUsaUJBQWlCLEVBQUUsTUFBTSw2QkFBNkIsQ0FBQzs7Ozs7OztBQUdoRTs7R0FFRztBQUtILE1BQU0sT0FBTyx1QkFBdUI7SUFKcEM7UUFjRTs7V0FFRztRQUNPLGtCQUFhLEdBQUcsSUFBSSxZQUFZLEVBQXFCLENBQUM7S0FnQmpFO0lBZEM7O09BRUc7SUFDSSxTQUFTLENBQUMsS0FBVTtRQUN6QixJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxtQkFBbUIsRUFBRTtZQUNyQyxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FDckIsSUFBSSxpQkFBaUIsQ0FBQztnQkFDcEIsS0FBSyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRztnQkFDdkIsS0FBSyxFQUFFLEtBQUssQ0FBQyxLQUFLO2dCQUNsQixLQUFLLEVBQUUsS0FBSzthQUNiLENBQUMsQ0FDSCxDQUFDO1NBQ0g7SUFDSCxDQUFDOztvSEE1QlUsdUJBQXVCO3dHQUF2Qix1QkFBdUIseUpDWnBDLHlxQkFpQkE7MkZETGEsdUJBQXVCO2tCQUpuQyxTQUFTOytCQUNFLHdCQUF3Qjs4QkFPekIsT0FBTztzQkFBZixLQUFLO2dCQUlHLElBQUk7c0JBQVosS0FBSztnQkFLSSxhQUFhO3NCQUF0QixNQUFNIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50LCBFdmVudEVtaXR0ZXIsIElucHV0LCBPdXRwdXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcclxuaW1wb3J0IHsgRm9ybUdyb3VwIH0gZnJvbSAnQGFuZ3VsYXIvZm9ybXMnO1xyXG5pbXBvcnQgeyBGaWVsZENoYW5nZU91dHB1dCB9IGZyb20gJy4uLy4uLy4uL21vZGVscy9iYXNlLWFjdGlvbic7XHJcbmltcG9ydCB7IE11bHRpU2VsZWN0Q29uZmlndXJhdGlvbiB9IGZyb20gJy4vbXVsdGktc2VsZWN0Lm1vZGVsJztcclxuXHJcbi8qKlxyXG4gKiBjb21wb25lbnQgbXVsdGkgc2VsZWN0XHJcbiAqL1xyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogJ3ByZy1tdWx0aS1zZWxlY3QtZmllbGQnLFxyXG4gIHRlbXBsYXRlVXJsOiAnLi9tdWx0aS1zZWxlY3QuY29tcG9uZW50Lmh0bWwnLFxyXG59KVxyXG5leHBvcnQgY2xhc3MgUHJnTXVsdGlTZWxlY3RDb21wb25lbnQge1xyXG4gIC8qKlxyXG4gICAqIE11bHRpIHNlbGVjdCBjb25maWdzXHJcbiAgICovXHJcbiAgQElucHV0KCkgY29uZmlnczogTXVsdGlTZWxlY3RDb25maWd1cmF0aW9uO1xyXG4gIC8qKlxyXG4gICAqIGZvcm1cclxuICAgKi9cclxuICBASW5wdXQoKSBmb3JtOiBGb3JtR3JvdXA7XHJcblxyXG4gIC8qKlxyXG4gICAqIG91dHB1dFxyXG4gICAqL1xyXG4gIEBPdXRwdXQoKSBvblZhbHVlQ2hhbmdlID0gbmV3IEV2ZW50RW1pdHRlcjxGaWVsZENoYW5nZU91dHB1dD4oKTtcclxuXHJcbiAgLyoqXHJcbiAgICogZnVuY3Rpb24gdGhhdCB0cmlnZ2VycyB0aGUgb3V0cHV0XHJcbiAgICovXHJcbiAgcHVibGljIG9uQ2hhbmdlZChldmVudDogYW55KSB7XHJcbiAgICBpZiAoIXRoaXMuY29uZmlncy5kaXNhYmxlZE91dHB1dEV2ZW50KSB7XHJcbiAgICAgIHRoaXMub25WYWx1ZUNoYW5nZS5lbWl0KFxyXG4gICAgICAgIG5ldyBGaWVsZENoYW5nZU91dHB1dCh7XHJcbiAgICAgICAgICBmaWVsZDogdGhpcy5jb25maWdzLmtleSxcclxuICAgICAgICAgIHZhbHVlOiBldmVudC52YWx1ZSxcclxuICAgICAgICAgIGV2ZW50OiBldmVudCxcclxuICAgICAgICB9KVxyXG4gICAgICApO1xyXG4gICAgfVxyXG4gIH1cclxufVxyXG4iLCI8ZGl2ICpuZ0lmPVwiZm9ybSAmJiBjb25maWdzICE9IG51bGxcIiBbZm9ybUdyb3VwXT1cImZvcm1cIj5cclxuICA8cD57e2NvbmZpZ3MuYmFzZVBhdGhUcmFuc2xhdGlvbiArICcuJyArIGNvbmZpZ3Mua2V5ICsgJy5uYW1lJyB8IHRyYW5zbGF0ZX19PC9wPlxyXG4gIDxwLW11bHRpU2VsZWN0XHJcbiAgICBkaXNwbGF5PVwiY2hpcFwiXHJcbiAgICBbZm9ybV09XCJmb3JtXCJcclxuICAgIChvbkNoYW5nZSk9XCJvbkNoYW5nZWQoJGV2ZW50KVwiXHJcbiAgICBbb3B0aW9uc109XCJjb25maWdzLm9wdGlvbnNcIlxyXG4gICAgW3NldE11bHRpU2VsZWN0Q29uZmlnc109XCJjb25maWdzXCJcclxuICAgIFtuZ0NsYXNzXT1cInsgJ3AtZmlsbGVkJzogZm9ybS5jb250cm9sc1tjb25maWdzPy5rZXldPy52YWx1ZSAhPT0gJycgfVwiXHJcbiAgICBbZm9ybUNvbnRyb2xOYW1lXT1cImNvbmZpZ3Mua2V5XCJcclxuICAgIFtwbGFjZWhvbGRlcl09XCJcclxuICAgICAgICBjb25maWdzLmJhc2VQYXRoVHJhbnNsYXRpb24gKyAnLicgKyBjb25maWdzLmtleSArICcucGxhY2Vob2xkZXInXHJcbiAgICAgICAgICB8IHRyYW5zbGF0ZVxyXG4gICAgICBcIlxyXG4gICAgW25hbWVdPVwiY29uZmlncy5rZXkgKyAnLm5hbWUnIHwgdHJhbnNsYXRlXCJcclxuICA+PC9wLW11bHRpU2VsZWN0PlxyXG48L2Rpdj5cclxuIl19