import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import { ReferenceType } from '../../../models/constants/reference-type';
import * as i0 from "@angular/core";
import * as i1 from "primeng/listbox";
import * as i2 from "../../../../../../lookup-table/services/lookup-table/abstract-lookup-table.service";
import * as i3 from "../../../../../../entity-types/services/entity-types/abstract-entity-type.service";
import * as i4 from "../../../../../services/utility/objects-utility.service";
/**
 * Class List box
 */
export class ListBoxConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.listBox;
        /**
         * Reference type
         */
        this.referenceType = null;
        /**
         * Reference name -> shoud be a lookup table name
         */
        this.referenceName = null;
        /**
         *Defines a string that labels the filter input.
         */
        this.ariaFilterLabel = null;
        /**
         *When specified, allows selecting items with checkboxes.
         */
        this.checkbox = false;
        /**
         *A property to uniquely identify a value in options.
         */
        this.dataKey = null;
        /**
         *When specified, displays a filter input at header.
         */
        this.filter = false;
        /**
         *Defines how the items are filtered, valid values are "contains" (default) "startsWith", "endsWith", "equals", "notEquals", "in", "lt", "lte", "gt" and "gte".
         */
        this.filterMatchMode = 'contains';
        /**
         *When specified, filter displays with this value.
         */
        this.filterValue = null;
        /**
         *Locale to use in filtering. The default locale is the host environment's current locale.
         */
        this.filterLocale = undefined;
        /**
         *When filtering is enabled, filterBy decides which field or fields (comma separated) to search against.
         */
        this.filterBy = null;
        /**
         *Defines placeholder of the filter input.
         */
        this.filterPlaceHolder = null;
        /**
         *Inline style of the list element.
         */
        this.listStyle = null;
        /**
         *Style class of the list element.
         */
        this.listStyleClass = null;
        /**
         *Defines how multiple items can be selected, when true metaKey needs to be pressed to select or unselect an item and when set to false selection of each item can be toggled individually. On touch enabled devices, metaKeySelection is turned off automatically.
         */
        this.metaKeySelection = true;
        /**
         *When specified, allows selecting multiple values.
         */
        this.multiple = false;
        /**
         *Text to display when there is no data. Defaults to global value in i18n translation configuration.
         */
        this.emptyMessage = 'No records found';
        /**
         *Text to display when filtering does not return any results. Defaults to global value in i18n translation configuration.
         */
        this.emptyFilterMessage = 'No results found';
        /**
         *An array of selectitems to display as the available options.
         */
        this.options = null;
        /**
         *Name of the label field of an option.
         */
        this.optionLabel = 'label';
        /**
         *Name of the value field of an option.
         */
        this.optionValue = 'value';
        /**
         *Name of the disabled field of an option.
         */
        this.optionDisabled = 'disabled';
        /**
         *Name of the label field of an option group.
         */
        this.optionGroupLabel = 'label';
        /**
         *Name of the options field of an option group.
         */
        this.optionGroupChildren = 'items';
        /**
         *Whether to display options as grouped when nested options are provided.
         */
        this.group = false;
        /**
         *Whether header checkbox is shown in multiple mode.
         */
        this.showToggleAll = true;
        /**
         *Inline style of the container.
         */
        this.style = null;
        /**
         *Style class of the container.
         */
        this.styleClass = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetListBoxConfigsDirective {
    /**
     * Constructor
     * @param {Listbox} element
     * @param {AbstractLookupTableService} lookupTableService
     * @param {AbstractEntityTypeService} entityTypeService
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {ChangeDetectorRef} cdc
     */
    constructor(element, lookupTableService, entityTypeService, objectsUtilityService, cdc) {
        this.element = element;
        this.lookupTableService = lookupTableService;
        this.entityTypeService = entityTypeService;
        this.objectsUtilityService = objectsUtilityService;
        this.cdc = cdc;
    }
    /**
     * get options from lookup table or entity type list
     * and assign configs to element
     */
    set setListBoxConfigs(configs) {
        switch (configs.referenceType) {
            case ReferenceType.LookupTable:
                if (configs.referenceName !== null && configs.referenceName.length) {
                    this.lookupTableService
                        .getLookupTableItemsByLookupTableNameAsync(configs.referenceName)
                        .then((options) => {
                        configs.options = options;
                        Object.assign(this.element, configs);
                        /**
                         * We have to initiate change detection
                         * through ChangeDetectorRef because for some reason
                         * this object assignment is not reflected in the template
                         */
                        this.cdc.detectChanges();
                        /**
                         * we need to set the value of the control
                         * again because for some reason it stays null
                         * and doesn't map the value selected by default,
                         * we've already had to analyse this
                         * and for now we can't understand why this behaviour
                         */
                        if (configs.value) {
                            this.form.get(configs.key).setValue(configs.value);
                        }
                    });
                }
                else {
                    this.lookupTableService.getAllLookupTableAsync().then((options) => {
                        configs.options = options;
                        Object.assign(this.element, configs);
                        /**
                         * we need to set the value of the control
                         * again because for some reason it stays null
                         * and doesn't map the value selected by default,
                         * we've already had to analyse this
                         * and for now we can't understand why this behaviour
                         */
                        if (configs.value) {
                            this.form.get(configs.key).setValue(configs.value);
                        }
                    });
                }
                break;
            case ReferenceType.EntityType:
                this.entityTypeService.getEntityTypeListAsync().then((value) => {
                    configs.options = value;
                    Object.assign(this.element, configs);
                    /**
                     * We have to initiate change detection
                     * through ChangeDetectorRef because for some reason
                     * this object assignment is not reflected in the template
                     */
                    this.cdc.detectChanges();
                    if (configs.value) {
                        this.form.get(configs.key).setValue(configs.value);
                    }
                });
                break;
            default:
                Object.assign(this.element, configs);
                break;
        }
    }
}
PrgSetListBoxConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetListBoxConfigsDirective, deps: [{ token: i1.Listbox }, { token: i2.AbstractLookupTableService }, { token: i3.AbstractEntityTypeService }, { token: i4.ObjectsUtilityService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetListBoxConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetListBoxConfigsDirective, selector: "[setListBoxConfigs]", inputs: { form: "form", setListBoxConfigs: "setListBoxConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetListBoxConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setListBoxConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.Listbox }, { type: i2.AbstractLookupTableService }, { type: i3.AbstractEntityTypeService }, { type: i4.ObjectsUtilityService }, { type: i0.ChangeDetectorRef }]; }, propDecorators: { form: [{
                type: Input
            }], setListBoxConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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