import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/listbox";
import * as i3 from "@angular/forms";
import * as i4 from "./list-box.model";
import * as i5 from "@ngx-translate/core";
/**
 * component List Box
 */
export class PrgListBoxComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.value,
                event: event,
            }));
        }
    }
}
PrgListBoxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgListBoxComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgListBoxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgListBoxComponent, selector: "prg-list-box-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "\r\n<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n  <p-listbox\r\n    [form]=\"form\"\r\n    [setListBoxConfigs]=\"configs\"\r\n    [id]=\"configs.key\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [filterPlaceHolder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.filterPlaceholder'\r\n          | translate\r\n      \"\r\n    (onChange)=\"onChanged($event)\"\r\n  ></p-listbox>\r\n\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i2.Listbox, selector: "p-listbox", inputs: ["multiple", "style", "styleClass", "listStyle", "listStyleClass", "readonly", "disabled", "checkbox", "filter", "filterBy", "filterMatchMode", "filterLocale", "metaKeySelection", "dataKey", "showToggleAll", "optionLabel", "optionValue", "optionGroupChildren", "optionGroupLabel", "optionDisabled", "ariaFilterLabel", "filterPlaceHolder", "emptyFilterMessage", "emptyMessage", "group", "options", "filterValue"], outputs: ["onChange", "onClick", "onDblClick"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.PrgSetListBoxConfigsDirective, selector: "[setListBoxConfigs]", inputs: ["form", "setListBoxConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgListBoxComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-list-box-field', template: "\r\n<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n  <p-listbox\r\n    [form]=\"form\"\r\n    [setListBoxConfigs]=\"configs\"\r\n    [id]=\"configs.key\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [filterPlaceHolder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.filterPlaceholder'\r\n          | translate\r\n      \"\r\n    (onChange)=\"onChanged($event)\"\r\n  ></p-listbox>\r\n\r\n</div>\r\n" }]
        }], propDecorators: { onValueChange: [{
                type: Output
            }], configs: [{
                type: Input
            }], form: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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