import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/knob";
/**
 * Class Knob
 */
export class KnobConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.knob;
        /**
         *Size of the component in pixels.
         */
        this.size = 100;
        /**
         *Step factor to increment/decrement the value.
         */
        this.step = 1;
        /**
         *Mininum boundary value.
         */
        this.min = 0;
        /**
         *Maximum boundary value.
         */
        this.max = 100;
        /**
         *Width of the knob stroke.
         */
        this.strokeWidth = 14;
        /**
         *Whether the show the value inside the knob.
         */
        this.showValue = true;
        /**
         *Template string of the value.
         */
        this.valueTemplate = '{value}';
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetKnobConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Knob configs and assign configs to element
     */
    set setKnobConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetKnobConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetKnobConfigsDirective, deps: [{ token: i1.Knob }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetKnobConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetKnobConfigsDirective, selector: "[setKnobConfigs]", inputs: { setKnobConfigs: "setKnobConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetKnobConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setKnobConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.Knob }]; }, propDecorators: { setKnobConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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