import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/knob";
import * as i3 from "@angular/forms";
import * as i4 from "./knob.model";
import * as i5 from "@ngx-translate/core";
/**
 * Component Knob
 */
export class PrgKnobComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event,
            }));
        }
    }
}
PrgKnobComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgKnobComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgKnobComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgKnobComponent, selector: "prg-knob-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate)}}</p>\r\n  <p-knob\r\n    [setKnobConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    (onChange)=\"onChanged($event)\"\r\n    [(ngModel)]=\"value\"\r\n  ></p-knob>\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i2.Knob, selector: "p-knob", inputs: ["styleClass", "style", "severity", "valueColor", "rangeColor", "textColor", "valueTemplate", "name", "size", "step", "min", "max", "strokeWidth", "disabled", "showValue", "readonly"], outputs: ["onChange"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.PrgSetKnobConfigsDirective, selector: "[setKnobConfigs]", inputs: ["setKnobConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgKnobComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-knob-field', template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate)}}</p>\r\n  <p-knob\r\n    [setKnobConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    (onChange)=\"onChanged($event)\"\r\n    [(ngModel)]=\"value\"\r\n  ></p-knob>\r\n</div>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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